/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import mds.connection.UpdateEvent;
import mds.connection.UpdateEventListener;
import mds.jscope.MdsWaveInterface;
import mds.jscope.jScopeDefaultValues;
import mds.wave.ColorMap;
import mds.wave.DataProvider;
import mds.wave.MultiWaveform;
import mds.wave.Signal;
import mds.wave.WaveInterface;
import mds.wave.Waveform;
import mds.wave.WaveformEvent;

public class jScopeMultiWave
extends MultiWaveform
implements UpdateEventListener {
    private static final long serialVersionUID = 1L;
    String eventName;

    public jScopeMultiWave(DataProvider dp, jScopeDefaultValues def_values) {
        this.wi = new MdsWaveInterface(this, dp, def_values);
        this.setTransferHandler(new ToTransferHandler());
    }

    public void AddEvent() throws IOException {
        ((MdsWaveInterface)this.wi).AddEvent(this);
    }

    public void AddEvent(String event) throws IOException {
        ((MdsWaveInterface)this.wi).AddEvent(this, event);
    }

    @Override
    protected void DrawImage(Graphics g, Image img, Dimension dim, int type) {
        if (type != 9) {
            super.DrawImage(g, img, dim, type);
        } else {
            ((Graphics2D)g).clearRect(0, 0, dim.width, dim.height);
            ((Graphics2D)g).drawRenderedImage((RenderedImage)((Object)img), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        }
    }

    public String getBriefError(String er, boolean brief) {
        if (brief) {
            int idx = er.indexOf(10) == -1 ? er.length() : er.indexOf(10);
            er = er.substring(0, idx);
        }
        return er;
    }

    @Override
    public ColorMap getColorMap() {
        return this.wi.getColorMap();
    }

    @Override
    public int GetMarker(int idx) {
        if (idx < this.wi.num_waves) {
            return this.wi.markers[idx];
        }
        return 0;
    }

    @Override
    protected Color getSignalColor(int i) {
        if (i > this.wi.num_waves) {
            return Color.black;
        }
        return colors[this.wi.colors_idx[i] % Waveform.colors.length];
    }

    @Override
    public int getSignalCount() {
        return this.wi.num_waves;
    }

    @Override
    protected String getSignalInfo(int i) {
        Signal sign;
        String er;
        String name = this.wi.in_label != null && this.wi.in_label[i] != null && this.wi.in_label[i].length() > 0 ? this.wi.in_label[i] : this.wi.in_y[i];
        String string = er = this.wi.w_error != null && this.wi.w_error[i] != null ? " ERROR " : "";
        if (this.signals.size() > i && this.signals.elementAt(i) != null && ((Signal)this.signals.elementAt(i)).getLegend() != null) {
            return ((Signal)this.signals.elementAt(i)).getLegend();
        }
        String s = this.wi.shots != null ? name + " " + this.wi.shots[i] + er : name + er;
        if (this.signals.size() > i && this.signals.elementAt(i) != null && (sign = (Signal)this.signals.elementAt(i)) != null && sign.getType() == 1) {
            switch (sign.getMode2D()) {
                case 0: {
                    s = s + " [X-Z Y = " + Waveform.ConvertToString(sign.getYinXZplot(), false) + " ]";
                    break;
                }
                case 1: {
                    s = s + " [Y-Z X = " + sign.getStringOfXinYZplot() + " ]";
                }
            }
        }
        return s;
    }

    @Override
    public String[] GetSignalsName() {
        return this.wi.GetSignalsName();
    }

    @Override
    public boolean[] GetSignalsState() {
        return this.wi.GetSignalsState();
    }

    @Override
    protected boolean isSignalShow(int i) {
        return this.wi.GetSignalState(i);
    }

    public void jScopeErase() {
        this.Erase();
        this.wi.Erase();
    }

    public synchronized void jScopeWaveUpdate() {
        if (this.wi.isAddSignal()) {
            if (((MdsWaveInterface)this.wi).prev_wi != null && ((MdsWaveInterface)this.wi).prev_wi.GetNumEvaluatedSignal() == ((MdsWaveInterface)this.wi).GetNumEvaluatedSignal()) {
                ((MdsWaveInterface)this.wi).prev_wi.error = ((MdsWaveInterface)this.wi).error;
                ((MdsWaveInterface)this.wi).prev_wi.w_error = ((MdsWaveInterface)this.wi).w_error;
                ((MdsWaveInterface)this.wi).prev_wi.setAddSignal(this.wi.isAddSignal());
                this.wi = ((MdsWaveInterface)this.wi).prev_wi;
                this.wi.SetIsSignalAdded(false);
            } else {
                this.wi.SetIsSignalAdded(true);
            }
            ((MdsWaveInterface)this.wi).prev_wi = null;
        }
        this.Update(this.wi);
        WaveformEvent e = new WaveformEvent((Object)this, 2010);
        this.dispatchWaveformEvent(e);
    }

    @Override
    public void processUpdateEvent(UpdateEvent e) {
        this.eventName = e.getName();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaveformEvent we = new WaveformEvent(jScopeMultiWave.this, 2006, "Update on event " + jScopeMultiWave.this.eventName);
                jScopeMultiWave.this.dispatchWaveformEvent(we);
            }
        });
    }

    public void Refresh() {
        this.setCursor(new Cursor(3));
        try {
            this.AddEvent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread p = new Thread(){

            @Override
            public void run() {
                MdsWaveInterface mwi = (MdsWaveInterface)jScopeMultiWave.this.wi;
                try {
                    mwi.refresh();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jScopeMultiWave.this.jScopeWaveUpdate();
                    }
                });
            }
        };
        p.start();
    }

    public void RefreshOnEvent() {
        MdsWaveInterface mwi = (MdsWaveInterface)this.wi;
        try {
            if (!mwi.refreshOnEvent()) {
                mwi.refresh();
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jScopeMultiWave.this.jScopeWaveUpdate();
            }
        });
    }

    public void RemoveEvent() throws IOException {
        ((MdsWaveInterface)this.wi).RemoveEvent(this);
    }

    public void RemoveEvent(String event) throws IOException {
        ((MdsWaveInterface)this.wi).AddEvent(this, event);
    }

    @Override
    public void removeNotify() {
        try {
            this.RemoveEvent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.wi = null;
        this.signals = null;
        this.orig_signals = null;
        Graphics g = this.getGraphics();
        g.dispose();
        super.removeNotify();
    }

    @Override
    public void setColorMap(ColorMap colorMap) {
        super.setColorMap(colorMap);
        this.wi.setColorMap(colorMap);
    }

    @Override
    public void SetSignalState(String label, boolean state) {
        this.wi.setSignalState(label, state);
        super.SetSignalState(label, state);
    }

    public void Update(WaveInterface _wi) {
        this.wi = _wi;
        this.resetMode();
        this.orig_signals = null;
        this.x_label = this.wi.xlabel;
        this.y_label = this.wi.ylabel;
        this.z_label = this.wi.zlabel;
        this.x_log = this.wi.x_log;
        this.y_log = this.wi.y_log;
        this.wave_error = this.wi.getErrorTitle(true);
        this.title = this.wi.title != null ? this.wi.title : "";
        this.setColorMap(this.wi.getColorMap());
        this.show_legend = this.wi.show_legend;
        this.legend_x = this.wi.legend_x;
        this.legend_y = this.wi.legend_y;
        this.is_image = this.wi.is_image;
        this.SetFrames(this.wi.getFrames());
        if (this.wi.signals != null) {
            boolean all_null = true;
            for (int i = 0; i < this.wi.signals.length; ++i) {
                if (this.wi.signals[i] == null) continue;
                all_null = false;
                if (this.wi.in_label[i] != null && this.wi.in_label[i].length() != 0) {
                    this.wi.signals[i].setName(this.wi.in_label[i]);
                } else {
                    this.wi.signals[i].setName(this.wi.in_y[i]);
                }
                this.wi.signals[i].setMarker(this.wi.markers[i]);
                this.wi.signals[i].setMarkerStep(this.wi.markers_step[i]);
                this.wi.signals[i].setInterpolate(this.wi.interpolates[i]);
                this.wi.signals[i].setColorIdx(this.wi.colors_idx[i]);
                this.wi.signals[i].setMode1D(this.wi.mode1D[i]);
                this.wi.signals[i].setMode2D(this.wi.mode2D[i]);
            }
            if (!all_null) {
                this.Update(this.wi.signals);
                return;
            }
        }
        if (this.wi.is_image && this.wi.getFrames() != null) {
            this.frames.setAspectRatio(this.wi.keep_ratio);
            this.frames.setHorizontalFlip(this.wi.horizontal_flip);
            this.frames.setVerticalFlip(this.wi.vertical_flip);
            this.curr_point_sig_idx = 0;
            if (this.signals.size() != 0) {
                this.signals.removeAllElements();
            }
            if (this.wi.getModified()) {
                this.frame = 0;
            }
            this.not_drawn = true;
            super.Update();
            return;
        }
        this.Erase();
    }

    class ToTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        ToTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            return (support.getSourceDropActions() & 3) != 0;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            try {
                String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st = new StringTokenizer(data, ":");
                String experiment = st.nextToken().substring(1);
                String path = data;
                boolean doErase = support.getDropAction() == 2;
                new Thread(() -> {
                    if (doErase) {
                        jScopeMultiWave.this.wi.Erase();
                    }
                    jScopeMultiWave.this.wi.setExperiment(experiment);
                    jScopeMultiWave.this.wi.AddSignal(path);
                    jScopeMultiWave.this.dispatchWaveformEvent(new WaveformEvent(jScopeMultiWave.this, 2006, "Update on Drop event "));
                }).start();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }
}

