/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import mds.jscope.SignalBox;
import mds.wave.ColorMap;
import mds.wave.DataProvider;
import mds.wave.FrameData;
import mds.wave.Frames;
import mds.wave.Signal;
import mds.wave.WaveData;
import mds.wave.Waveform;
import mds.wave.WaveformEvent;

public class WaveInterface {
    public static SignalBox sig_box = new SignalBox();
    static final int MAX_NUM_SHOT = 30;
    public static boolean auto_color_on_expr = false;
    public static boolean brief_error = true;
    public Waveform wave;
    public int num_waves;
    public boolean x_log;
    public boolean y_log;
    public String[] in_label;
    public String[] in_x;
    public String[] in_y;
    public String[] in_up_err;
    public String[] in_low_err;
    public String in_xmin;
    public String in_xmax;
    public String in_ymax;
    public String in_ymin;
    public String in_timemax;
    public String in_timemin;
    public String in_title;
    public String in_xlabel;
    public String in_ylabel;
    public String in_def_node;
    public boolean in_upd_limits = true;
    public String experiment;
    public int in_grid_mode;
    public int height;
    public boolean isContinuousUpdate = false;
    public String in_shot;
    public int num_shot = 1;
    private boolean modified = true;
    public boolean reversed = false;
    public boolean show_legend = false;
    public double legend_x;
    public double legend_y;
    public int[] markers_step;
    public int[] markers;
    public int[] colors_idx;
    public boolean[] interpolates;
    public int[] mode2D;
    public int[] mode1D;
    public long[] shots;
    public String error;
    private String curr_error;
    public String provider;
    public String[] w_error;
    public Signal[] signals;
    public double xmax;
    public double xmin;
    public double ymax;
    public double ymin;
    public double timemax;
    public double timemin;
    public String title;
    public String xlabel;
    public String ylabel;
    public String zlabel;
    public DataProvider dp;
    public boolean asynch_update = true;
    Signal[] wave_signals;
    protected boolean[] evaluated;
    public boolean is_image = false;
    public boolean keep_ratio = true;
    public boolean horizontal_flip = false;
    public boolean vertical_flip = false;
    public int signal_select = -1;
    private Frames frames;
    protected boolean add_signal = false;
    protected boolean is_signal_added = false;
    public ColorMap colorMap = new ColorMap();
    boolean xLimitsLong;
    long xminLong = 0L;
    long xmaxLong = 0L;

    protected static String AddNewLineCode(String s) {
        String s_new = new String();
        int new_pos = 0;
        int old_pos = 0;
        if (s == null) {
            return null;
        }
        while ((new_pos = s.indexOf("\n", old_pos)) != -1) {
            s_new = s_new.concat(s.substring(old_pos, new_pos));
            old_pos = new_pos + "\n".length();
            s_new = s_new + "|||";
        }
        s_new = s_new.concat(s.substring(old_pos, s.length()));
        return s_new;
    }

    public static long[] GetShotArray(String in_shots, String exp, DataProvider dp) throws IOException {
        long[] shot_list = null;
        if (in_shots == null || in_shots.trim().length() == 0 || dp == null) {
            return null;
        }
        String shotExpr = in_shots;
        if (exp != null) {
            shotExpr = WaveInterface.processShotExpression(in_shots, exp);
        }
        if ((shot_list = dp.getShots(shotExpr, exp)) == null || shot_list.length == 0 || shot_list.length > 30) {
            String error;
            if (shot_list != null && shot_list.length > 30) {
                error = "Too many shots. Max shot list elements 30\n";
            } else if (dp.getError() != null) {
                error = dp.getError();
                if (error.indexOf("_jScopeMainShots") != -1) {
                    error = "Undefined main shot value";
                }
            } else {
                error = "Shot syntax error\n";
            }
            throw new IOException(error);
        }
        return shot_list;
    }

    static String processShotExpression(String shotExpr, String exp) {
        String outStr = "";
        int idx = 0;
        int prevIdx = 0;
        shotExpr = shotExpr.trim();
        if (exp == null || exp.length() == 0) {
            return shotExpr;
        }
        while ((idx = shotExpr.indexOf(48, prevIdx)) != -1) {
            outStr = idx > 0 && Character.isLetterOrDigit(shotExpr.charAt(idx - 1)) || idx < shotExpr.length() - 1 && Character.isLetterOrDigit(shotExpr.charAt(idx + 1)) ? outStr + shotExpr.substring(prevIdx, idx + 1) : outStr + shotExpr.substring(prevIdx, idx) + "current_shot(\"" + exp + "\")";
            prevIdx = idx + 1;
        }
        if (outStr.length() == 0) {
            return shotExpr;
        }
        outStr = outStr + (prevIdx < shotExpr.length() ? shotExpr.substring(prevIdx, shotExpr.length()) : "");
        return outStr;
    }

    protected static String RemoveNewLineCode(String s) {
        String y_new = new String();
        int new_pos = 0;
        int old_pos = 0;
        while ((new_pos = s.indexOf("|||", old_pos)) != -1) {
            y_new = y_new.concat(s.substring(old_pos, new_pos));
            old_pos = new_pos + "|||".length();
            y_new = y_new + '\n';
        }
        y_new = y_new.concat(s.substring(old_pos, s.length()));
        return y_new;
    }

    static String TrimString(String s) {
        String s_new = new String();
        int new_pos = 0;
        int old_pos = 0;
        while ((new_pos = s.indexOf(" ", old_pos)) != -1) {
            s_new = s_new.concat(s.substring(old_pos, new_pos));
            old_pos = new_pos + " ".length();
        }
        s_new = s_new.concat(s.substring(old_pos, s.length()));
        return s_new;
    }

    public static void WriteLine(PrintWriter out, String prompt, String value) {
        if (value != null && value.length() != 0) {
            out.println(prompt + value);
        }
    }

    public WaveInterface() {
        this.CreateWaveInterface(null, null);
    }

    public WaveInterface(DataProvider dp) {
        this.CreateWaveInterface(null, dp);
    }

    public WaveInterface(Waveform wave) {
        this.CreateWaveInterface(wave, null);
    }

    public WaveInterface(Waveform wave, DataProvider dp) {
        this.CreateWaveInterface(wave, dp);
    }

    public void AddFrames(String frames) {
        this.AddFrames(frames, null);
    }

    public void AddFrames(String frames, String frames_time) {
        this.SetAsImage(true);
        this.in_x = new String[1];
        this.in_y = new String[1];
        this.in_x[0] = frames_time;
        this.in_y[0] = frames;
    }

    public boolean AddSignal(String y_expr) {
        return this.AddSignal("", y_expr);
    }

    public boolean AddSignal(String x_expr, String y_expr) {
        String[] x = new String[1];
        String[] y = new String[1];
        x[0] = x_expr;
        y[0] = y_expr;
        return this.AddSignals(x, y);
    }

    public boolean AddSignals(String[] x_expr, String[] y_expr) {
        int i;
        int new_num_waves;
        if (x_expr.length != y_expr.length || x_expr.length == 0) {
            return false;
        }
        int num_sig = x_expr.length;
        boolean[] is_new = null;
        if (this.num_waves != 0) {
            is_new = new boolean[x_expr.length];
            for (int j = 0; j < x_expr.length; ++j) {
                is_new[j] = true;
                for (int i2 = 0; i2 < this.num_waves; ++i2) {
                    if (!y_expr[j].equals(this.in_y[i2]) || this.in_x[i2] == null || !x_expr[j].equals(this.in_x[i2])) continue;
                    is_new[j] = false;
                    --num_sig;
                }
            }
            if (num_sig == 0) {
                return true;
            }
            new_num_waves = this.num_waves + (this.num_shot != 0 ? this.num_shot : 1) * num_sig;
        } else {
            new_num_waves = x_expr.length;
        }
        String[] new_in_label = new String[new_num_waves];
        String[] new_in_x = new String[new_num_waves];
        String[] new_in_y = new String[new_num_waves];
        String[] new_in_up_err = new String[new_num_waves];
        String[] new_in_low_err = new String[new_num_waves];
        int[] new_markers = new int[new_num_waves];
        int[] new_markers_step = new int[new_num_waves];
        int[] new_colors_idx = new int[new_num_waves];
        boolean[] new_interpolates = new boolean[new_num_waves];
        int[] new_mode2D = new int[new_num_waves];
        int[] new_mode1D = new int[new_num_waves];
        long[] new_shots = null;
        if (this.shots != null) {
            new_shots = new long[new_num_waves];
        }
        boolean[] new_evaluated = new boolean[new_num_waves];
        Signal[] new_signals = new Signal[new_num_waves];
        String[] new_w_error = new String[new_num_waves];
        for (i = 0; i < this.num_waves; ++i) {
            new_in_label[i] = this.in_label[i];
            new_in_x[i] = this.in_x[i];
            new_in_y[i] = this.in_y[i];
            new_in_up_err[i] = this.in_up_err[i];
            new_in_low_err[i] = this.in_low_err[i];
            new_markers[i] = this.markers[i];
            new_markers_step[i] = this.markers_step[i];
            new_colors_idx[i] = this.colors_idx[i];
            new_interpolates[i] = this.interpolates[i];
            new_mode2D[i] = this.mode2D[i];
            new_mode1D[i] = this.mode1D[i];
            if (this.shots != null) {
                new_shots[i] = this.shots[i];
            }
            new_evaluated[i] = this.evaluated != null ? this.evaluated[i] : false;
            if (this.signals != null) {
                new_signals[i] = this.signals[i];
            }
            if (this.w_error == null) continue;
            new_w_error[i] = this.w_error[i];
        }
        int k = this.num_waves;
        for (i = 0; i < x_expr.length; ++i) {
            if (is_new != null && !is_new[i]) continue;
            for (int j = 0; j < this.num_shot; ++j) {
                new_in_label[k] = "";
                new_in_x[k] = new String(x_expr[i]);
                new_in_y[k] = new String(y_expr[i]);
                new_in_up_err[k] = "";
                new_in_low_err[k] = "";
                new_markers[k] = 0;
                new_markers_step[k] = 1;
                new_colors_idx[k] = auto_color_on_expr ? (k - j) % Waveform.colors.length : j % Waveform.colors.length;
                new_interpolates[k] = true;
                new_evaluated[k] = false;
                new_mode2D[k] = 0;
                new_mode1D[k] = 0;
                if (this.shots != null && this.shots.length != 0 && this.num_shot > 0) {
                    new_shots[k] = this.shots[j];
                }
                ++k;
            }
        }
        this.in_label = new_in_label;
        this.in_x = new_in_x;
        this.in_y = new_in_y;
        this.in_up_err = new_in_up_err;
        this.in_low_err = new_in_low_err;
        this.markers = new_markers;
        this.markers_step = new_markers_step;
        this.colors_idx = new_colors_idx;
        this.interpolates = new_interpolates;
        this.mode2D = new_mode2D;
        this.mode1D = new_mode1D;
        this.shots = new_shots;
        this.num_waves = new_num_waves;
        this.evaluated = new_evaluated;
        this.signals = new_signals;
        this.w_error = new_w_error;
        this.add_signal = true;
        return true;
    }

    public boolean allEvaluated() {
        if (this.evaluated == null) {
            return false;
        }
        for (int curr_wave = 0; curr_wave < this.num_waves; ++curr_wave) {
            if (this.evaluated[curr_wave]) continue;
            this.modified = true;
            return false;
        }
        this.modified = false;
        return true;
    }

    private void CreateNewFramesClass(int image_type) throws IOException {
        if (image_type == 9) {
            try {
                Class<?> cl = Class.forName("jScope.FrameJAI");
                this.frames = (Frames)cl.newInstance();
            }
            catch (Exception e) {
                throw new IOException("Java Advanced Imaging must be installed to show this type of image");
            }
        } else {
            this.frames = new Frames();
            this.frames.setColorMap(this.colorMap);
        }
    }

    private void CreateWaveInterface(Waveform wave, DataProvider dp) {
        this.wave = wave;
        this.dp = dp;
        if (dp == null) {
            this.experiment = null;
        }
        this.shots = null;
        this.in_title = null;
        this.in_ymax = null;
        this.in_ymin = null;
        this.in_xmax = null;
        this.in_xmin = null;
        this.in_timemin = null;
        this.in_timemax = null;
        this.in_ylabel = null;
        this.in_xlabel = null;
        this.markers = null;
        this.interpolates = null;
        this.mode2D = null;
        this.mode1D = null;
        this.y_log = false;
        this.x_log = false;
        this.in_upd_limits = true;
        this.show_legend = false;
        this.reversed = false;
    }

    public void Erase() {
        this.num_waves = 0;
        this.in_label = null;
        this.in_x = null;
        this.in_y = null;
        this.in_up_err = null;
        this.in_low_err = null;
        this.in_xmin = null;
        this.in_xmax = null;
        this.in_ymax = null;
        this.in_ymin = null;
        this.in_timemax = null;
        this.in_timemin = null;
        this.in_title = null;
        this.in_xlabel = null;
        this.in_ylabel = null;
        this.experiment = null;
        this.in_shot = null;
        this.num_shot = 1;
        this.modified = true;
        this.markers_step = null;
        this.markers = null;
        this.colors_idx = null;
        this.interpolates = null;
        this.mode2D = null;
        this.mode1D = null;
        this.shots = null;
        this.error = null;
        this.curr_error = null;
        this.w_error = null;
        this.signals = null;
        this.title = null;
        this.xlabel = null;
        this.ylabel = null;
        this.is_image = false;
        this.keep_ratio = true;
        this.horizontal_flip = false;
        this.vertical_flip = false;
        this.frames = null;
        this.show_legend = false;
        this.wave_signals = null;
        this.evaluated = null;
    }

    public synchronized boolean EvaluateOthers() {
        if (this.is_image) {
            if (!this.evaluated[0]) {
                this.InitializeFrames();
                if (this.frames != null) {
                    this.frames.SetViewRect((int)this.xmin, (int)this.ymin, (int)this.xmax, (int)this.ymax);
                }
                this.error = this.curr_error;
            }
            return false;
        }
        if (this.evaluated == null) {
            this.signals = null;
            return true;
        }
        boolean retStatus = true;
        for (int curr_wave = 0; curr_wave < this.num_waves; ++curr_wave) {
            if (this.evaluated[curr_wave] || !this.interpolates[curr_wave] && this.markers[curr_wave] == 0) continue;
            this.w_error[curr_wave] = null;
            try {
                this.signals[curr_wave] = this.GetSignal(curr_wave, this.xmin, this.xmax);
                this.evaluated[curr_wave] = true;
            }
            catch (Exception exc) {
                this.signals[curr_wave] = null;
                this.curr_error = exc.getMessage();
                retStatus = false;
            }
            if (this.signals[curr_wave] == null) {
                this.w_error[curr_wave] = this.curr_error;
                this.evaluated[curr_wave] = false;
                continue;
            }
            sig_box.AddSignal(this.in_x[curr_wave], this.in_y[curr_wave]);
            try {
                this.setLimits(this.signals[curr_wave]);
                continue;
            }
            catch (Exception exc) {
                this.signals[curr_wave] = null;
                this.w_error[curr_wave] = exc.getMessage();
                retStatus = false;
            }
        }
        this.modified = false;
        return retStatus;
    }

    public synchronized void EvaluateShot(long shot) throws Exception {
        if (this.is_image) {
            return;
        }
        for (int curr_wave = 0; curr_wave < this.num_waves; ++curr_wave) {
            if (shot != 0L && (this.shots[curr_wave] != shot || this.evaluated[curr_wave] || !this.interpolates[curr_wave] && this.markers[curr_wave] == 0)) continue;
            this.w_error[curr_wave] = null;
            try {
                this.signals[curr_wave] = this.GetSignal(curr_wave, -1.7976931348623157E308, Double.MAX_VALUE);
                this.evaluated[curr_wave] = true;
            }
            catch (Exception exc) {
                this.signals[curr_wave] = null;
                this.w_error[curr_wave] = exc.getMessage();
            }
            if (this.signals[curr_wave] == null) {
                this.w_error[curr_wave] = this.curr_error;
                this.evaluated[curr_wave] = false;
                continue;
            }
            sig_box.AddSignal(this.in_x[curr_wave], this.in_y[curr_wave]);
            this.setLimits(this.signals[curr_wave]);
        }
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public DataProvider getDataProvider() {
        return this.dp;
    }

    long getDate(String inVal) {
        try {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy HH:mm");
            Date date = df.parse(inVal);
            cal.setTime(date);
            long javaTime = cal.getTime().getTime();
            return javaTime;
        }
        catch (Exception exc) {
            return -1L;
        }
    }

    public String getErrorTitle() {
        return this.getErrorTitle(brief_error);
    }

    public String getErrorTitle(boolean brief) {
        int n_error = 0;
        String er = this.error;
        if (this.num_waves == 0 || this.is_image && this.frames == null) {
            if (this.error != null && brief) {
                er = this.GetFirstLine(new String(this.error));
            }
            return er;
        }
        for (int ii = 0; ii < this.num_waves; ++ii) {
            if (this.w_error == null || this.w_error[ii] == null) continue;
            ++n_error;
        }
        if (this.error == null && n_error > 1 && n_error == this.num_waves) {
            er = "Evaluation error on all signals";
        } else if (this.error != null) {
            er = this.error;
        } else if (n_error == 1 && this.num_waves == 1) {
            er = this.w_error[0];
        } else if (n_error > 0) {
            er = "< Evaluation error on " + n_error + " signal" + (n_error > 1 ? "s" : "") + " >";
        }
        if (er != null && brief) {
            int idx = er.indexOf(10) == -1 ? er.length() : er.indexOf(10);
            er = er.substring(0, idx);
        }
        return er;
    }

    private String GetFirstLine(String str) {
        int idx = str.indexOf("\n");
        if (idx != -1) {
            return str.substring(0, idx);
        }
        return str;
    }

    public Frames getFrames() {
        return this.frames;
    }

    public boolean getModified() {
        return this.modified;
    }

    public int GetNumEvaluatedSignal() {
        if (this.signals == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.signals.length; ++i) {
            if (this.signals[i] == null) continue;
            ++n;
        }
        return n;
    }

    public long[] GetShotArray(String in_shots) throws IOException {
        long[] curr_shots = WaveInterface.GetShotArray(in_shots, this.experiment, this.dp);
        return curr_shots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Signal GetSignal(int curr_wave, double xmin, double xmax) throws IOException {
        Signal out_signal = null;
        int mode = this.wave.GetMode();
        try {
            this.wave.SetMode(5);
            if (this.in_y[curr_wave] == null) {
                this.curr_error = "Missing Y value";
                this.wave.SetMode(mode);
                return null;
            }
            DataProvider dataProvider = this.dp;
            synchronized (dataProvider) {
                out_signal = this.GetSignalFromProvider(curr_wave, xmin, xmax);
            }
            if (out_signal != null) {
                if (xmin > xmax) {
                    xmin = xmax;
                }
                if (this.ymin > this.ymax) {
                    this.ymin = this.ymax;
                }
                out_signal.setXLimits(xmin, xmax, 3);
                if (this.in_ymax != null && this.in_ymax.trim().length() != 0 && this.in_upd_limits) {
                    out_signal.setYmax(this.ymax, 3);
                }
                if (this.in_ymin != null && this.in_ymin.trim().length() != 0 && this.in_upd_limits) {
                    out_signal.setYmin(this.ymin, 3);
                }
            }
            this.wave.SetMode(mode);
        }
        catch (IOException exc) {
            this.wave.SetMode(mode);
            throw exc;
        }
        return out_signal;
    }

    private Signal GetSignalFromProvider(int curr_wave, double xmin, double xmax) throws IOException {
        WaveData up_err = null;
        WaveData low_err = null;
        WaveData wd = null;
        WaveData xwd = null;
        int xDimension = 1;
        String xlabel = null;
        String ylabel = null;
        String title = null;
        if (this.shots != null && this.shots.length != 0) {
            this.dp.update(this.experiment, this.shots[curr_wave]);
        } else {
            this.dp.update(null, 0L);
        }
        if (this.dp.getError() != null) {
            this.error = this.dp.getError();
            return null;
        }
        if (this.in_def_node != null && this.in_def_node.length() > 0) {
            this.dp.setEnvironment("__default_node = " + this.in_def_node);
        } else {
            this.dp.setEnvironment("__default_node = " + this.experiment + "::TOP");
        }
        if (this.dp.getError() != null) {
            this.error = this.dp.getError();
            return null;
        }
        if (this.in_x[curr_wave] != null && this.in_x[curr_wave].trim().length() != 0) {
            wd = this.dp.getWaveData(this.in_y[curr_wave], this.in_x[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (wd != null) {
                xlabel = wd.GetXLabel();
                ylabel = wd.GetYLabel();
            }
            if (wd != null && this.in_up_err != null && this.in_up_err[curr_wave] != null && this.in_up_err[curr_wave].trim().length() != 0) {
                up_err = this.dp.getWaveData(this.in_up_err[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            }
            if (this.in_low_err != null && this.in_low_err[curr_wave] != null && this.in_low_err[curr_wave].trim().length() != 0) {
                low_err = this.dp.getWaveData(this.in_low_err[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            }
        } else {
            if (wd == null) {
                wd = this.dp.getWaveData(this.in_y[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            }
            if (this.in_up_err != null && this.in_up_err[curr_wave] != null && this.in_up_err[curr_wave].trim().length() != 0) {
                up_err = this.dp.getWaveData(this.in_up_err[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            }
            if (this.in_low_err != null && this.in_low_err[curr_wave] != null && this.in_low_err[curr_wave].trim().length() != 0) {
                low_err = this.dp.getWaveData(this.in_low_err[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            }
        }
        if (wd == null) {
            this.curr_error = this.dp.getError();
            return null;
        }
        if (this.in_x[curr_wave] != null && (xDimension = (xwd = this.dp.getWaveData(this.in_x[curr_wave], this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex())).getNumDimension()) == 1) {
            xwd = null;
        }
        Signal out_signal = xDimension == 1 ? (this.xLimitsLong ? new Signal(wd, xwd, this.xminLong, this.xmaxLong, low_err, up_err) : new Signal(wd, xwd, xmin, xmax, low_err, up_err)) : (this.xLimitsLong ? new Signal(wd, xwd, this.xminLong, this.xmaxLong) : new Signal(wd, xwd, xmin, xmax));
        out_signal.setMode1D(this.mode1D[curr_wave]);
        if (wd != null) {
            try {
                title = wd.GetTitle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (up_err != null && low_err != null) {
            out_signal.AddAsymError(up_err, low_err);
        } else if (up_err != null) {
            out_signal.AddError(up_err);
        }
        if (wd != null) {
            try {
                xlabel = wd.GetXLabel();
                ylabel = wd.GetYLabel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        out_signal.setLabels(title, xlabel, ylabel, null);
        return out_signal;
    }

    public String[] GetSignalsName() {
        String[] name = null;
        if (this.num_waves != 0) {
            int ns = this.num_shot > 0 ? this.num_shot : 1;
            name = new String[this.num_waves / ns];
            int j = 0;
            for (int i = 0; i < this.num_waves; i += ns) {
                String s = this.in_label[i] != null && this.in_label[i].length() != 0 ? this.in_label[i] : this.in_y[i];
                name[j++] = s;
            }
        }
        return name;
    }

    public boolean[] GetSignalsState() {
        boolean[] state = null;
        if (this.num_waves != 0) {
            int ns = this.num_shot > 0 ? this.num_shot : 1;
            state = new boolean[this.num_waves / ns];
            int j = 0;
            for (int i = 0; i < this.num_waves; i += ns) {
                state[j++] = this.interpolates[i] || this.markers[i] != 0;
            }
        }
        return state;
    }

    public boolean GetSignalState(int i) {
        boolean state = false;
        if (i < this.num_waves) {
            state = this.interpolates[i] || this.markers[i] != 0;
        }
        return state;
    }

    private void InitializeFrames() {
        this.curr_error = null;
        int mode = this.wave.GetMode();
        this.wave.SetMode(5);
        if (this.in_y[0] == null) {
            this.curr_error = "Missing Y value";
            return;
        }
        if (this.shots != null && this.shots.length != 0) {
            this.dp.update(this.experiment, this.shots[0]);
        } else {
            this.dp.update(null, 0L);
        }
        try {
            WaveformEvent we = new WaveformEvent((Object)this.wave, "Loading single or multi frame image");
            this.wave.dispatchWaveformEvent(we);
            FrameData fd = this.dp.getFrameData(this.in_y[0], this.in_x[0], (float)this.timemin, (float)this.timemax);
            if (fd != null) {
                this.CreateNewFramesClass(fd.getFrameType());
                this.frames.SetFrameData(fd);
                if (this.in_label != null && this.in_label[0] != null && this.in_label[0].length() != 0) {
                    this.frames.setName(this.in_label[0]);
                } else {
                    this.frames.setName(this.in_y[0]);
                }
                this.evaluated[0] = true;
            } else {
                this.frames = null;
                this.curr_error = this.dp.getError();
                this.evaluated[0] = false;
            }
            this.wave.SetMode(mode);
        }
        catch (Throwable e) {
            this.wave.SetMode(mode);
            this.frames = null;
            this.curr_error = " Load Frames error " + e.getMessage();
        }
    }

    public boolean isAddSignal() {
        return this.add_signal;
    }

    public boolean IsSignalAdded() {
        return this.is_signal_added;
    }

    public void setAddSignal(boolean add_signal) {
        this.add_signal = add_signal;
    }

    public void SetAsImage(boolean is_image) {
        this.is_image = is_image;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void SetDataProvider(DataProvider _dp) {
        this.dp = _dp;
        this.error = null;
        this.curr_error = null;
        this.w_error = null;
        this.signals = null;
        this.modified = true;
    }

    public void setExperiment(String experiment) {
        this.experiment = experiment;
    }

    public void setFrames(Frames f) {
        this.frames = f;
    }

    public void SetIsSignalAdded(boolean is_signal_added) {
        this.is_signal_added = is_signal_added;
    }

    public void SetLegendPosition(double x, double y) {
        this.legend_x = x;
        this.legend_y = y;
        this.show_legend = true;
    }

    public void setLimits() {
        try {
            for (Signal signal : this.signals) {
                if (signal == null) continue;
                this.setLimits(signal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLimits(Signal s) throws Exception {
        s.setXLimits(this.xmin, this.xmax, 1);
        s.setYmin(this.ymin, 1);
        s.setYmax(this.ymax, 1);
    }

    public void setModified(boolean state) {
        this.modified = state;
    }

    public void setShotArray(String in_shot) throws IOException {
        this.in_shot = in_shot;
        long[] curr_shots = this.GetShotArray(in_shot);
        this.UpdateShot(curr_shots);
    }

    public void setSignalState(String name, boolean state) {
        if (this.num_waves != 0) {
            int ns = this.num_shot == 0 ? 1 : this.num_shot;
            for (int i = 0; i < this.num_waves; ++i) {
                if (!name.equals(this.in_y[i]) && !name.equals(this.in_label[i])) continue;
                for (int j = i; j < i + ns; ++j) {
                    this.interpolates[j] = state;
                    this.markers[i] = 0;
                }
                return;
            }
        }
    }

    public void ShowLegend(boolean state) {
        this.show_legend = state;
    }

    public synchronized int StartEvaluate() throws IOException {
        this.error = null;
        if (this.modified) {
            this.evaluated = null;
        }
        if (this.in_y == null || this.in_x == null) {
            this.error = "Missing Y or X values";
            this.signals = null;
            return 0;
        }
        if (this.shots == null && this.experiment != null && this.experiment.trim().length() != 0) {
            this.error = "Missing shot value";
            this.signals = null;
        }
        if (this.shots != null && (this.experiment == null || this.experiment.trim().length() == 0)) {
            this.error = "Missing experiment name";
            this.signals = null;
        }
        this.num_waves = this.in_y.length;
        if (this.modified) {
            if (!this.is_image) {
                this.signals = new Signal[this.num_waves];
            }
            this.evaluated = new boolean[this.num_waves];
            this.w_error = new String[this.num_waves];
        }
        if (this.in_x != null && this.num_waves != this.in_x.length) {
            this.error = "X values are different from Y values";
            return 0;
        }
        if (this.shots != null && this.shots.length > 0) {
            int i = 0;
            do {
                this.dp.update(this.experiment, this.shots[i]);
            } while (++i < this.shots.length && this.dp.getError() != null);
        } else {
            this.dp.update(null, 0L);
        }
        if (this.dp.getError() != null) {
            this.error = this.dp.getError();
            return 0;
        }
        if (this.in_title != null && this.in_title.trim().length() != 0) {
            this.title = this.dp.getString(this.in_title, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.title == null) {
                this.error = this.dp.getError();
                return 0;
            }
        }
        if (this.in_xmin != null && this.in_xmin.trim().length() != 0 && this.in_upd_limits) {
            this.xmin = this.dp.getFloat(this.in_xmin, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.dp.getError() != null) {
                this.error = this.dp.getError();
                return 0;
            }
            long timeLong = this.getDate(this.in_xmin);
            if (timeLong != -1L) {
                this.xLimitsLong = true;
                this.xminLong = timeLong;
            }
        } else {
            double d = this.xmin = !this.is_image ? -1.7976931348623157E308 : -1.0;
        }
        if (this.in_xmax != null && this.in_xmax.trim().length() != 0 && this.in_upd_limits) {
            this.xmax = this.dp.getFloat(this.in_xmax, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.dp.getError() != null) {
                this.error = this.dp.getError();
                return 0;
            }
            long timeLong = this.getDate(this.in_xmax);
            if (timeLong != -1L) {
                this.xLimitsLong = true;
                this.xmaxLong = timeLong;
            }
        } else {
            double d = this.xmax = !this.is_image ? Double.MAX_VALUE : -1.0;
        }
        if (this.in_ymax != null && this.in_ymax.trim().length() != 0 && this.in_upd_limits) {
            this.ymax = this.dp.getFloat(this.in_ymax, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.dp.getError() != null) {
                this.error = this.dp.getError();
                return 0;
            }
        } else {
            double d = this.ymax = !this.is_image ? Double.MAX_VALUE : -1.0;
        }
        if (this.in_ymin != null && this.in_ymin.trim().length() != 0 && this.in_upd_limits) {
            this.ymin = this.dp.getFloat(this.in_ymin, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.dp.getError() != null) {
                this.error = this.dp.getError();
                return 0;
            }
        } else {
            double d = this.ymin = !this.is_image ? -1.7976931348623157E308 : -1.0;
        }
        if (this.is_image) {
            if (this.in_timemax != null && this.in_timemax.trim().length() != 0) {
                this.timemax = this.dp.getFloat(this.in_timemax, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
                if (this.dp.getError() != null) {
                    this.error = this.dp.getError();
                    return 0;
                }
            } else {
                this.timemax = Double.MAX_VALUE;
            }
            if (this.in_timemin != null && this.in_timemin.trim().length() != 0) {
                this.timemin = this.dp.getFloat(this.in_timemin, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
                if (this.dp.getError() != null) {
                    this.error = this.dp.getError();
                    return 0;
                }
            } else {
                this.timemin = -1.7976931348623157E308;
            }
        }
        if (this.in_xlabel != null && this.in_xlabel.trim().length() != 0) {
            this.xlabel = this.dp.getString(this.in_xlabel, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.xlabel == null) {
                this.error = this.dp.getError();
                return 0;
            }
        }
        if (this.in_ylabel != null && this.in_ylabel.trim().length() != 0) {
            this.ylabel = this.dp.getString(this.in_ylabel, this.wave.getRow(), this.wave.getColumn(), this.wave.getIndex());
            if (this.ylabel == null) {
                this.error = this.dp.getError();
                return 0;
            }
        }
        if (this.xmin > this.xmax) {
            this.xmin = this.xmax;
        }
        if (this.ymin > this.ymax) {
            this.ymin = this.ymax;
        }
        return 1;
    }

    public boolean UpdateShot(long[] curr_shots) throws IOException {
        int num_expr;
        int num_signal;
        int curr_num_shot;
        if (curr_shots == null) {
            curr_num_shot = 1;
            this.shots = null;
            if (this.num_shot == 0) {
                return false;
            }
        } else {
            curr_num_shot = curr_shots.length;
        }
        if (this.num_shot == 0) {
            num_signal = this.num_waves * curr_num_shot;
            num_expr = this.num_waves;
        } else {
            num_signal = this.num_waves / this.num_shot * curr_num_shot;
            num_expr = this.num_waves / this.num_shot;
        }
        if (this.is_image) {
            this.modified = true;
            this.shots = curr_shots;
            return true;
        }
        if (num_signal == 0) {
            return false;
        }
        this.modified = true;
        String[] in_label = new String[num_signal];
        String[] in_x = new String[num_signal];
        String[] in_y = new String[num_signal];
        String[] in_up_err = new String[num_signal];
        String[] in_low_err = new String[num_signal];
        int[] markers = new int[num_signal];
        int[] markers_step = new int[num_signal];
        int[] colors_idx = new int[num_signal];
        boolean[] interpolates = new boolean[num_signal];
        int[] mode2D = new int[num_signal];
        int[] mode1D = new int[num_signal];
        long[] shots = null;
        if (curr_shots != null) {
            shots = new long[num_signal];
        }
        int sig_idx = this.num_shot == 0 ? 1 : this.num_shot;
        int k = 0;
        for (int i = 0; i < num_expr; ++i) {
            int j = 0;
            while (j < curr_num_shot) {
                in_label[k] = this.in_label[i * sig_idx];
                in_x[k] = this.in_x[i * sig_idx];
                in_y[k] = this.in_y[i * sig_idx];
                if (j < this.num_shot) {
                    markers[k] = this.markers[i * this.num_shot + j];
                    markers_step[k] = this.markers_step[i * this.num_shot + j];
                    interpolates[k] = this.interpolates[i * this.num_shot + j];
                    mode2D[k] = this.mode2D[i * this.num_shot + j];
                    mode1D[k] = this.mode1D[i * this.num_shot + j];
                    if (curr_shots != null) {
                        shots[k] = curr_shots[j];
                    }
                    in_up_err[k] = this.in_up_err[i * this.num_shot + j];
                    in_low_err[k] = this.in_low_err[i * this.num_shot + j];
                    colors_idx[k] = this.colors_idx[i * this.num_shot + j];
                } else {
                    markers[k] = this.markers[i * this.num_shot];
                    markers_step[k] = this.markers_step[i * this.num_shot];
                    interpolates[k] = this.interpolates[i * this.num_shot];
                    mode2D[k] = this.mode2D[i * this.num_shot];
                    mode1D[k] = this.mode1D[i * this.num_shot];
                    in_up_err[k] = this.in_up_err[i * this.num_shot];
                    in_low_err[k] = this.in_low_err[i * this.num_shot];
                    colors_idx[k] = auto_color_on_expr ? i % Waveform.colors.length : j % Waveform.colors.length;
                    if (curr_shots != null) {
                        shots[k] = curr_shots[j];
                    }
                }
                ++j;
                ++k;
            }
        }
        this.in_label = in_label;
        this.in_x = in_x;
        this.in_y = in_y;
        this.in_up_err = in_up_err;
        this.in_low_err = in_low_err;
        this.markers = markers;
        this.markers_step = markers_step;
        this.colors_idx = colors_idx;
        this.interpolates = interpolates;
        this.mode2D = mode2D;
        this.mode1D = mode1D;
        this.shots = shots;
        this.num_shot = shots != null ? curr_num_shot : 1;
        this.num_waves = num_signal;
        return true;
    }
}

