/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import mds.connection.ConnectionListener;
import mds.connection.UpdateEventListener;
import mds.wave.DataProvider;
import mds.wave.FrameData;
import mds.wave.WaveData;

public class DataServerItem {
    public static final DataProvider NotConnected = new DataProvider(){

        @Override
        public void addConnectionListener(ConnectionListener l) {
        }

        @Override
        public void addUpdateEventListener(UpdateEventListener l, String event) {
        }

        @Override
        public void close() {
        }

        @Override
        public String getError() {
            return "Not Connected";
        }

        @Override
        public double getFloat(String in, int row, int col, int index) {
            return Double.parseDouble(in);
        }

        @Override
        public FrameData getFrameData(String in_y, String in_x, float time_min, float time_max) throws IOException {
            return null;
        }

        @Override
        public long[] getShots(String in, String experiment) {
            long[] d = new long[]{0L};
            return d;
        }

        @Override
        public String getString(String in, int row, int col, int index) {
            return "";
        }

        @Override
        public WaveData getWaveData(String in, int row, int col, int index) {
            return null;
        }

        @Override
        public WaveData getWaveData(String in_y, String in_x, int row, int col, int index) {
            return null;
        }

        @Override
        public int inquireCredentials(JFrame f, DataServerItem server_item) {
            return 1;
        }

        @Override
        public boolean isBusy() {
            return false;
        }

        @Override
        public void removeConnectionListener(ConnectionListener l) {
        }

        @Override
        public void removeUpdateEventListener(UpdateEventListener l, String event) {
        }

        @Override
        public void setArgument(String arg) {
        }

        @Override
        public void setEnvironment(String exp) {
        }

        @Override
        public boolean supportsTunneling() {
            return false;
        }

        @Override
        public void update(String exp, long s) {
        }
    };
    public static final Set<Class<?>> knownProviders = DataServerItem.getClasses("mds.provider", DataProvider.class);
    private String argument;
    private final String browse_class;
    private final String browse_url;
    private String class_name;
    private String name;
    private String tunnel_port;
    private String user;

    public static final Set<Class<?>> getClasses(String packageName, Class<?> type) {
        HashSet classes = new HashSet();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            assert (classLoader != null);
            Enumeration<URL> resources = classLoader.getResources(packageName.replace('.', '/'));
            File directory = new File(resources.nextElement().getFile());
            if (directory.exists()) {
                File[] files;
                for (File file : files = directory.listFiles()) {
                    String name = file.getName();
                    if (!name.endsWith(".class") || name.contains("$")) continue;
                    try {
                        classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)).asSubclass(type));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static final String trimArg(String arg) {
        if (arg == null) {
            return null;
        }
        String trimmed = arg.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    public DataServerItem() {
        this("Not Connected", null, null, null, null, null, null);
    }

    public DataServerItem(String user) {
        this(null, null, user, null, null, null, null);
    }

    public DataServerItem(String name, String argument, String user, String class_name, String browse_class, String browse_url, String tunnel_port) {
        this.name = DataServerItem.trimArg(name);
        this.argument = DataServerItem.trimArg(argument);
        this.user = DataServerItem.trimArg(user);
        this.class_name = DataServerItem.trimArg(class_name);
        this.browse_class = DataServerItem.trimArg(browse_class);
        this.browse_url = DataServerItem.trimArg(browse_url);
        this.tunnel_port = DataServerItem.trimArg(tunnel_port);
    }

    public boolean equals(DataServerItem dsi) {
        try {
            boolean out = this.name.equals(dsi.name);
            return out;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public boolean equals(String name) {
        return this.name.equals(name);
    }

    public final String getArgument() {
        return this.argument;
    }

    public final String getBrowseClass() {
        return this.browse_class;
    }

    public final String getBrowseUrl() {
        return this.browse_url;
    }

    public final String getClassName() {
        return this.class_name;
    }

    public final String getName() {
        return this.name;
    }

    public DataProvider getProvider() throws Exception {
        if (this.isNotConnected()) {
            return NotConnected;
        }
        try {
            Class<?> cl = this.class_name.contains(".") ? Class.forName(this.class_name) : Class.forName("mds.provider." + this.class_name);
            return (DataProvider)cl.newInstance();
        }
        catch (Exception e) {
            throw new Exception("Can't load data provider class: " + this.class_name + "\n" + e);
        }
    }

    public final String getTunnelPort() {
        return this.tunnel_port;
    }

    public final String getUser() {
        return this.user;
    }

    public boolean isNotConnected() {
        return this.class_name == null;
    }

    public void print() {
        System.out.println("name: " + this.name);
        System.out.println("argument: " + this.argument);
        System.out.println("user: " + this.user);
        System.out.println("class_name: " + this.getClassName());
        System.out.println("browse_class: " + this.name);
        System.out.println("tunnel_port: " + this.tunnel_port);
    }

    public String toString() {
        return this.name;
    }

    public void update(String name, String argument, String user, String class_name, String tunnel_port) {
        this.name = DataServerItem.trimArg(name);
        this.argument = DataServerItem.trimArg(argument);
        this.user = DataServerItem.trimArg(user);
        this.class_name = DataServerItem.trimArg(class_name);
        this.tunnel_port = DataServerItem.trimArg(tunnel_port);
    }
}

