/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mds.jscope.jScopeFacade;
import mds.wave.Waveform;

class ColorDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    JList<String> colorList;
    DefaultListModel<String> listModel = new DefaultListModel();
    JTextField colorName;
    JComboBox<String> color;
    JSlider red;
    JSlider green;
    JSlider blue;
    JButton ok;
    JButton reset;
    JButton cancel;
    JButton add;
    JButton erase;
    jScopeFacade main_scope;
    JLabel label;
    Canvas color_test;
    int red_i;
    int green_i;
    int blue_i;
    boolean changed = false;
    Vector<Item> color_set = new Vector();
    Vector<Item> color_set_clone;
    Color[] color_vector;
    String[] color_name;
    int[] colorMapIndex = null;
    private boolean reversed = false;

    ColorDialog(Frame dw, String title) {
        super(dw, title, true);
        this.main_scope = (jScopeFacade)dw;
        this.GetPropertiesValue();
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        c.insets = new Insets(4, 4, 4, 4);
        c.fill = 1;
        c.gridwidth = 0;
        this.label = new JLabel("Color list customization");
        gridbag.setConstraints(this.label, c);
        this.getContentPane().add(this.label);
        c.gridwidth = 1;
        this.label = new JLabel("Name");
        gridbag.setConstraints(this.label, c);
        this.getContentPane().add(this.label);
        this.colorName = new JTextField(15);
        this.colorName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ColorDialog.this.keyPressedAction(e);
            }
        });
        gridbag.setConstraints(this.colorName, c);
        this.getContentPane().add(this.colorName);
        if (this.GetNumColor() == 0) {
            this.ColorSetItems(Waveform.COLOR_NAME, Waveform.COLOR_SET);
        }
        this.SetColorVector();
        this.GetColorsName();
        this.color = new JComboBox();
        for (String name : this.color_name) {
            this.color.addItem(name);
        }
        this.color.addItemListener(this);
        gridbag.setConstraints(this.color, c);
        this.getContentPane().add(this.color);
        c.gridwidth = 0;
        this.color_test = new Canvas();
        this.color_test.setBackground(Color.black);
        gridbag.setConstraints(this.color_test, c);
        this.getContentPane().add(this.color_test);
        c.gridwidth = 2;
        c.gridheight = 5;
        this.colorList = new JList<String>(this.listModel);
        JScrollPane scrollColorList = new JScrollPane(this.colorList);
        this.colorList.setSelectionMode(0);
        this.colorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int color_idx = ((JList)e.getSource()).getSelectedIndex();
                if (color_idx >= 0 && color_idx < ColorDialog.this.color_set.size()) {
                    Item c_item = ColorDialog.this.color_set.elementAt(color_idx);
                    ColorDialog.this.SetSliderToColor(c_item.color);
                    ColorDialog.this.colorName.setText(c_item.name);
                }
            }
        });
        this.colorList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ColorDialog.this.keyPressedAction(e);
            }
        });
        gridbag.setConstraints(scrollColorList, c);
        this.getContentPane().add(scrollColorList);
        this.label = new JLabel("Red");
        c.gridheight = 1;
        gridbag.setConstraints(this.label, c);
        this.getContentPane().add(this.label);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("0"));
        labelTable.put(64, new JLabel("64"));
        labelTable.put(128, new JLabel("128"));
        labelTable.put(192, new JLabel("192"));
        labelTable.put(255, new JLabel("255"));
        c.gridwidth = 0;
        c.gridheight = 1;
        this.red = new JSlider(0, 0, 255, 0);
        this.red.setMinorTickSpacing(8);
        this.red.setPaintTicks(true);
        this.red.setPaintLabels(true);
        this.red.setLabelTable(labelTable);
        this.red.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.red.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorDialog.this.colorValueChanged(e);
            }
        });
        gridbag.setConstraints(this.red, c);
        this.getContentPane().add(this.red);
        c.gridwidth = 1;
        this.label = new JLabel("Green");
        c.gridheight = 1;
        gridbag.setConstraints(this.label, c);
        this.getContentPane().add(this.label);
        c.gridwidth = 0;
        this.green = new JSlider(0, 0, 255, 0);
        this.green.setMinorTickSpacing(8);
        this.green.setPaintTicks(true);
        this.green.setPaintLabels(true);
        this.green.setLabelTable(labelTable);
        this.green.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.green.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorDialog.this.colorValueChanged(e);
            }
        });
        gridbag.setConstraints(this.green, c);
        this.getContentPane().add(this.green);
        c.gridwidth = 1;
        this.label = new JLabel("Blue");
        c.gridheight = 1;
        gridbag.setConstraints(this.label, c);
        this.getContentPane().add(this.label);
        c.gridwidth = 0;
        this.blue = new JSlider(0, 0, 255, 0);
        this.blue.setMinorTickSpacing(8);
        this.blue.setPaintTicks(true);
        this.blue.setPaintLabels(true);
        this.blue.setLabelTable(labelTable);
        this.blue.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.blue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorDialog.this.colorValueChanged(e);
            }
        });
        gridbag.setConstraints(this.blue, c);
        this.getContentPane().add(this.blue);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(1));
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        p1.add(this.ok);
        this.add = new JButton("Add/Apply");
        this.add.addActionListener(this);
        p1.add(this.add);
        this.erase = new JButton("Erase");
        this.erase.addActionListener(this);
        p1.add(this.erase);
        this.reset = new JButton("Reset");
        this.reset.addActionListener(this);
        p1.add(this.reset);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        p1.add(this.cancel);
        c.gridwidth = 0;
        gridbag.setConstraints(p1, c);
        this.getContentPane().add(p1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob == this.ok) {
            if (ob == this.ok) {
                this.color_set_clone = null;
                this.setVisible(false);
            }
            this.AddUpdateItem(this.colorName.getText(), this.getColor());
            this.SetColorVector();
            this.main_scope.UpdateColors();
            this.main_scope.RepaintAllWaves();
            this.main_scope.setChange(true);
        }
        if (ob == this.add) {
            this.AddUpdateItem(this.colorName.getText(), this.getColor());
        }
        if (ob == this.erase) {
            this.colorName.setText("");
            this.removeAllColorItems();
            if (this.listModel.getSize() > 0) {
                this.listModel.clear();
            }
            this.AddUpdateItem(Waveform.COLOR_NAME[0], Waveform.COLOR_SET[0]);
            this.SetColorVector();
        }
        if (ob == this.reset) {
            this.color_set = this.CopyColorItemsVector(this.color_set_clone);
            this.setColorItemToList();
            this.SetColorVector();
        }
        if (ob == this.cancel) {
            this.color_set = this.CopyColorItemsVector(this.color_set_clone);
            this.setColorItemToList();
            this.SetColorVector();
            this.color_set_clone = null;
            this.setVisible(false);
        }
    }

    private void AddUpdateItem(String name, Color color) {
        int i;
        if (name == null || name.length() == 0) {
            return;
        }
        Item c_item = new Item(name, color);
        String[] c_name = this.GetColorsName();
        for (i = 0; c_name != null && i < c_name.length && !c_name[i].equals(name); ++i) {
        }
        if (c_name == null || i == c_name.length) {
            this.color_set.addElement(c_item);
            this.listModel.addElement(name);
        } else {
            this.color_set.setElementAt(c_item, i);
        }
    }

    public void ColorSetItems(String[] color_name, Color[] colors) {
        for (int i = 0; i < color_name.length; ++i) {
            Item c_item;
            if (this.reversed) {
                if (colors[i].equals(Color.black)) {
                    c_item = new Item("White", Color.white);
                    this.color_set.addElement(c_item);
                    continue;
                }
            } else if (colors[i].equals(Color.white)) {
                c_item = new Item("Black", Color.black);
                this.color_set.addElement(c_item);
                continue;
            }
            c_item = new Item(color_name[i], colors[i]);
            this.color_set.addElement(c_item);
        }
    }

    public void colorValueChanged(ChangeEvent e) {
        this.color_test.setBackground(this.getColor());
        this.color_test.repaint();
    }

    private Vector<Item> CopyColorItemsVector(Vector<Item> in) {
        Vector<Item> out = new Vector<Item>(in.size());
        for (int i = 0; i < in.size(); ++i) {
            out.addElement(new Item(in.elementAt((int)i).name, in.elementAt((int)i).color));
        }
        return out;
    }

    public void FromFile(Properties pr, String prompt) throws IOException {
        String prop;
        int idx = 0;
        Vector<Integer> newColorMap = new Vector<Integer>();
        this.removeAllColorItems();
        while ((prop = pr.getProperty(prompt + idx)) != null) {
            StringTokenizer st = new StringTokenizer(prop, ",");
            String name = st.nextToken();
            st.nextToken("[");
            Color cr = this.StringToColor(st.nextToken(""));
            newColorMap.addElement(new Integer(this.InsertItemAt(name, cr)));
            ++idx;
        }
        this.colorMapIndex = new int[newColorMap.size()];
        for (int i = 0; i < newColorMap.size(); ++i) {
            this.colorMapIndex[i] = (Integer)newColorMap.elementAt(i);
        }
        if (this.GetNumColor() == 0) {
            if (this.main_scope.js_prop != null) {
                this.GetPropertiesValue();
            } else {
                this.ColorSetItems(Waveform.COLOR_NAME, Waveform.COLOR_SET);
            }
        }
        this.SetColorVector();
        this.GetColorsName();
    }

    private Color getColor() {
        return new Color(this.red.getValue(), this.green.getValue(), this.blue.getValue());
    }

    public Color GetColorAt(int idx) {
        if (idx >= 0 && idx < this.color_set.size()) {
            Color color = this.color_set.elementAt((int)idx).color;
            return color;
        }
        return null;
    }

    public int[] getColorMapIndex() {
        return this.colorMapIndex;
    }

    public Color[] GetColors() {
        return this.color_vector;
    }

    public String[] GetColorsName() {
        this.color_name = null;
        if (this.color_set.size() > 0) {
            this.color_name = new String[this.color_set.size()];
            for (int i = 0; i < this.color_set.size(); ++i) {
                this.color_name[i] = this.color_set.elementAt((int)i).name;
            }
        }
        return this.color_name;
    }

    public String GetNameAt(int idx) {
        if (idx >= 0 && idx < this.color_set.size()) {
            String name = this.color_set.elementAt((int)idx).name;
            return name;
        }
        return null;
    }

    public int GetNumColor() {
        return this.color_set.size();
    }

    private void GetPropertiesValue() {
        String prop;
        Properties js_prop = this.main_scope.js_prop;
        if (js_prop == null) {
            return;
        }
        int i = 0;
        while ((prop = js_prop.getProperty("jScope.item_color_" + i)) != null) {
            int len = prop.indexOf(",");
            String name = new String(prop.substring(0, len));
            Color cr = this.StringToColor(new String(prop.substring(len + 2, prop.length())));
            this.InsertItemAt(name, cr, i);
            ++i;
        }
    }

    public int InsertItemAt(String name, Color color) {
        int i;
        String ext = "";
        int extIdx = 1;
        for (i = 0; i < this.color_set.size(); ++i) {
            if (this.color_set.elementAt((int)i).name.equals(name + ext)) {
                ext = "_" + extIdx;
                ++extIdx;
            }
            if (!this.color_set.elementAt((int)i).color.equals(color)) continue;
            return i;
        }
        Item c_item = new Item(name + ext, color);
        this.color_set.insertElementAt(c_item, i);
        return i;
    }

    public void InsertItemAt(String name, Color color, int idx) {
        Item c_item = new Item(name, color);
        this.color_set.insertElementAt(c_item, idx);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object ob = e.getSource();
        if (ob == this.color) {
            int color_idx = this.color.getSelectedIndex();
            this.colorName.setText(Waveform.COLOR_NAME[color_idx]);
            this.SetSliderToColor(Waveform.COLOR_SET[color_idx]);
        }
    }

    public void keyPressedAction(KeyEvent e) {
        Object ob = e.getSource();
        char key = e.getKeyChar();
        if (key == '\uffff') {
            return;
        }
        if (key == '\u007f' && ob == this.colorList) {
            int idx = this.colorList.getSelectedIndex();
            this.listModel.remove(idx);
            this.color_set.removeElementAt(idx);
            this.colorName.setText("");
        }
        if (key == '\n' && ob == this.colorName) {
            this.AddUpdateItem(this.colorName.getText(), this.getColor());
        }
    }

    public void removeAllColorItems() {
        if (this.color_set.size() != 0) {
            this.color_set.removeAllElements();
        }
    }

    private void ReversedColor(String[] color_name, Color[] colors) {
        for (int i = 0; i < color_name.length; ++i) {
            if (this.reversed) {
                if (!colors[i].equals(Color.black)) continue;
                Item c_item = new Item("White", Color.white);
                this.color_set.setElementAt(c_item, i);
                break;
            }
            if (!colors[i].equals(Color.white)) continue;
            Item c_item = new Item("Black", Color.black);
            this.color_set.setElementAt(c_item, i);
            break;
        }
    }

    public void setColorItemToList() {
        if (this.listModel.getSize() > 0) {
            this.listModel.clear();
        }
        for (int i = 0; i < this.color_set.size(); ++i) {
            this.listModel.addElement(this.color_set.elementAt((int)i).name);
        }
    }

    public Color[] SetColorVector() {
        this.color_vector = new Color[this.color_set.size()];
        for (int i = 0; i < this.color_set.size(); ++i) {
            this.color_vector[i] = this.color_set.elementAt((int)i).color;
        }
        return this.color_vector;
    }

    public void SetReversed(boolean reversed) {
        if (this.reversed != reversed) {
            this.reversed = reversed;
            this.ReversedColor(this.color_name, this.color_vector);
            this.SetColorVector();
            this.GetColorsName();
        }
    }

    private void SetSliderToColor(Color c) {
        this.red.setValue(c.getRed());
        this.green.setValue(c.getGreen());
        this.blue.setValue(c.getBlue());
        this.color_test.setBackground(c);
        this.color_test.repaint();
    }

    public void ShowColorDialog(Component f) {
        this.setColorItemToList();
        this.color_set_clone = this.CopyColorItemsVector(this.color_set);
        this.pack();
        this.setLocationRelativeTo(f);
        this.setVisible(true);
    }

    private Color StringToColor(String str) {
        int pos = str.indexOf(",");
        String tmp = str.substring(str.indexOf("=") + 1, pos);
        int r = Integer.parseInt(tmp);
        int n = pos + 3;
        pos = str.indexOf(",", pos + 1);
        tmp = str.substring(n, pos);
        int g = Integer.parseInt(tmp);
        tmp = str.substring(pos + 3, str.indexOf("]", pos + 1));
        int b = Integer.parseInt(tmp);
        int c = r << 16 | g << 8 | b;
        return new Color(c);
    }

    public void toFile(PrintWriter out, String prompt) {
        for (int i = 0; i < this.GetNumColor(); ++i) {
            out.println(prompt + i + ": " + this.GetNameAt(i) + "," + this.GetColorAt(i));
        }
        out.println("");
    }

    static class Item {
        String name;
        Color color;

        Item(String n, Color c) {
            this.name = new String(n);
            this.color = c;
        }
    }
}

