/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Data;
import MDSplus.MdsException;
import MDSplus.Uint64;

public class Event {
    long time = 0L;
    Data data = null;
    byte[] dataBuf;
    String name;
    boolean disposed = false;
    boolean timeout;
    long eventId;

    public Event(String name) throws MdsException {
        this.name = name;
        this.eventId = this.registerEvent(name);
        if (this.eventId == -1L) {
            throw new MdsException("Cannot Register to event " + name);
        }
    }

    public String getName() {
        return this.name;
    }

    public Uint64 getTime() {
        return new Uint64(this.time);
    }

    public Data getData() {
        if (this.data != null) {
            return this.data;
        }
        if (this.dataBuf.length == 0) {
            this.data = null;
        } else {
            try {
                this.data = Data.deserialize(this.dataBuf);
            }
            catch (Exception exc) {
                this.data = null;
            }
        }
        return this.data;
    }

    public byte[] getRaw() {
        return this.dataBuf;
    }

    public synchronized void run() {
        this.timeout = false;
        this.notifyAll();
    }

    public synchronized Data waitData() {
        try {
            this.wait();
        }
        catch (InterruptedException exc) {
            return null;
        }
        return this.getData();
    }

    public synchronized Data waitData(int milliseconds) throws MdsException {
        this.timeout = true;
        try {
            this.wait(milliseconds);
        }
        catch (InterruptedException exc) {
            return null;
        }
        if (this.timeout) {
            throw new MdsException("Timeout occurred in Event wait");
        }
        return this.getData();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.unregisterEvent(this.eventId);
    }

    public static void setEvent(String evName) {
        Event.setEventRaw(evName, new byte[0]);
    }

    public static void setEvent(String evName, Data data) {
        Event.setEventRaw(evName, data == null ? new byte[]{} : data.serialize());
    }

    public static void setevent(String evName) {
        Event.setEvent(evName);
    }

    public static void setevent(String evName, Data data) {
        Event.setEvent(evName, data);
    }

    void intRun(byte[] buf, long time) {
        this.time = time;
        this.dataBuf = buf;
        this.data = null;
        this.run();
    }

    public static void seteventRaw(String evName, byte[] buf) {
        Event.setEventRaw(evName, buf);
    }

    public static native void setEventRaw(String var0, byte[] var1);

    native long registerEvent(String var1);

    native void unregisterEvent(long var1);

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                Event ev = new Event(args[0]);
                Data data = ev.waitData();
                System.out.println(data);
            }
            catch (MdsException exc) {
                System.out.println(exc);
            }
        } else if (args.length == 2) {
            try {
                Event.setEvent(args[0], Data.compile(args[1]));
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
    }

    static {
        try {
            boolean loaded = false;
            try {
                String value = System.getenv("JavaMdsLib");
                if (value == null) {
                    value = System.getProperty("JavaMdsLib");
                }
                if (value != null) {
                    System.load(value);
                    loaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loaded) {
                System.loadLibrary("JavaMds");
            }
        }
        catch (Throwable e) {
            System.out.println("Error loading library javamds: " + e);
            e.printStackTrace();
        }
    }
}

