/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.io.IOException;
import java.util.StringTokenizer;
import mds.provider.MdsDataProvider;

public class JetDataProvider
extends MdsDataProvider {
    public JetDataProvider() {
        super("mdsplus.jet.efda.org");
    }

    @Override
    public synchronized int[] getIntArray(String in) throws IOException {
        return super.getIntArray(this.parseExpression(in));
    }

    @Override
    public synchronized MdsDataProvider.RealArray GetRealArray(String in) throws IOException {
        return super.GetRealArray(this.parseExpression(in));
    }

    private String parseExpression(String in) {
        this.error = null;
        StringTokenizer st = new StringTokenizer(in, " /(){}[]*+,:;", true);
        String parsed = "";
        String signal = "";
        int state = 0;
        try {
            while (st.hasMoreTokens()) {
                String curr_str = st.nextToken();
                switch (state) {
                    case 0: {
                        if (curr_str.equals("/")) {
                            if (parsed.endsWith("PPF") || parsed.endsWith("ppf") || parsed.endsWith("JPF") || parsed.endsWith("jpf")) {
                                signal = parsed.substring(parsed.length() - 3) + "/";
                                parsed = parsed.substring(0, parsed.length() - 3);
                                state = 1;
                                break;
                            }
                            parsed = parsed + curr_str;
                            break;
                        }
                        parsed = parsed + curr_str;
                        break;
                    }
                    case 1: {
                        signal = signal + curr_str;
                        state = 2;
                        break;
                    }
                    case 2: {
                        signal = signal + curr_str;
                        state = 3;
                        break;
                    }
                    case 3: {
                        parsed = parsed + "(jet(\"" + signal + curr_str + "\", " + this.shot + ")) ";
                        signal = "";
                        state = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return parsed;
    }
}

