/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import mds.wave.ColorMapDialog;
import mds.wave.ImageTransferable;
import mds.wave.ProfileDialog;
import mds.wave.SetupWaveformParams;
import mds.wave.Signal;
import mds.wave.Waveform;
import mds.wave.WaveformContainer;
import mds.wave.WaveformManager;

public class WavePopup
extends JPopupMenu
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected Waveform wave = null;
    protected SetupWaveformParams setup_params;
    protected JSeparator sep1;
    protected JSeparator sep2;
    protected JSeparator sep3;
    protected JMenuItem setup = new JMenuItem("Set Limits...");
    protected JMenuItem autoscale;
    protected JMenuItem autoscaleY;
    protected JMenuItem autoscaleAll;
    protected JMenuItem autoscaleAllY;
    protected JMenuItem allSameScale;
    protected JMenuItem allSameXScale;
    protected JMenuItem allSameXScaleAutoY;
    protected JMenuItem allSameYScale;
    protected JMenuItem resetScales;
    protected JMenuItem resetAllScales;
    protected JMenuItem playFrame;
    protected JMenuItem remove_panel;
    protected JMenuItem set_point;
    protected JMenuItem undo_zoom;
    protected JMenuItem maximize;
    protected JMenuItem cb_copy;
    protected JMenuItem profile_dialog;
    protected JMenuItem colorMap;
    protected JMenuItem saveAsText;
    protected JMenu markerList;
    protected JMenu colorList;
    protected JMenu markerStep;
    protected JMenu mode_2d;
    protected JMenu mode_1d;
    protected JRadioButtonMenuItem plot_y_time;
    protected JRadioButtonMenuItem plot_x_y;
    protected JRadioButtonMenuItem plot_contour;
    protected JRadioButtonMenuItem plot_image;
    protected JRadioButtonMenuItem plot_line;
    protected JRadioButtonMenuItem plot_no_line;
    protected JRadioButtonMenuItem plot_step;
    protected ButtonGroup markerList_bg;
    protected ButtonGroup colorList_bg;
    protected ButtonGroup markerStep_bg;
    protected ButtonGroup mode_2d_bg;
    protected ButtonGroup mode_1d_bg;
    protected int curr_x;
    protected int curr_y;
    protected Container parent;
    private Waveform profile_source = null;
    ProfileDialog profDialog;
    ColorMapDialog colorMapDialog = null;

    public WavePopup() {
        this(null, null);
    }

    public WavePopup(SetupWaveformParams setup_params, ProfileDialog profDialog) {
        JRadioButtonMenuItem ob;
        int i;
        this.setup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.ShowDialog();
            }
        });
        this.setup_params = setup_params;
        this.profDialog = profDialog;
        this.remove_panel = new JMenuItem("Remove panel");
        this.remove_panel.setEnabled(false);
        this.remove_panel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] options = new Object[]{"Yes", "No"};
                int opt = JOptionPane.showOptionDialog(null, "Are you sure you want to remove this wave panel?", "Warning", 0, 3, null, options, options[1]);
                switch (opt) {
                    case 0: {
                        ((WaveformManager)((Object)WavePopup.this.parent)).removePanel(WavePopup.this.wave);
                    }
                }
            }
        });
        this.maximize = new JMenuItem("Maximize Panel");
        this.maximize.setEnabled(false);
        this.maximize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((WaveformManager)((Object)WavePopup.this.parent)).isMaximize()) {
                    ((WaveformManager)((Object)WavePopup.this.parent)).maximizeComponent(null);
                } else {
                    ((WaveformManager)((Object)WavePopup.this.parent)).maximizeComponent(WavePopup.this.wave);
                }
            }
        });
        this.set_point = new JMenuItem("Set Point");
        this.set_point.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.SetDeselectPoint(WavePopup.this.wave);
            }
        });
        this.markerList = new JMenu("Markers");
        this.markerList_bg = new ButtonGroup();
        for (i = 0; i < Signal.markerList.length; ++i) {
            ob = new JRadioButtonMenuItem(Signal.markerList[i]);
            this.markerList_bg.add(ob);
            ob.getModel().setActionCommand("MARKER " + i);
            this.markerList.add(ob);
            ob.addItemListener(this);
        }
        this.markerList.setEnabled(false);
        this.markerStep_bg = new ButtonGroup();
        this.markerStep = new JMenu("Marker step");
        for (i = 0; i < Signal.markerStepList.length; ++i) {
            ob = new JRadioButtonMenuItem("" + Signal.markerStepList[i]);
            this.markerStep_bg.add(ob);
            ob.getModel().setActionCommand("MARKER_STEP " + i);
            this.markerStep.add(ob);
            ob.addItemListener(this);
        }
        this.markerStep.setEnabled(false);
        this.colorList = new JMenu("Colors");
        this.colorList.setEnabled(false);
        this.mode_1d_bg = new ButtonGroup();
        this.mode_1d = new JMenu("Mode Plot 1D");
        this.plot_line = new JRadioButtonMenuItem("Line");
        this.mode_1d.add(this.plot_line);
        this.mode_1d_bg.add(this.plot_line);
        this.plot_line.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.SetMode1D(0);
                }
            }
        });
        this.plot_no_line = new JRadioButtonMenuItem("No Line");
        this.mode_1d.add(this.plot_no_line);
        this.mode_1d_bg.add(this.plot_no_line);
        this.plot_no_line.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.SetMode1D(2);
                }
            }
        });
        this.plot_step = new JRadioButtonMenuItem("Step Plot");
        this.mode_1d.add(this.plot_step);
        this.mode_1d_bg.add(this.plot_step);
        this.plot_step.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.SetMode1D(3);
                }
            }
        });
        this.mode_2d_bg = new ButtonGroup();
        this.mode_2d = new JMenu("signal 2D");
        this.plot_y_time = new JRadioButtonMenuItem("Plot xz(y)");
        this.mode_2d.add(this.plot_y_time);
        this.mode_2d_bg.add(this.plot_y_time);
        this.plot_y_time.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.SetMode2D(0);
                }
            }
        });
        this.plot_x_y = new JRadioButtonMenuItem("Plot yz(x)");
        this.mode_2d.add(this.plot_x_y);
        this.mode_2d_bg.add(this.plot_x_y);
        this.plot_x_y.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.SetMode2D(1);
                }
            }
        });
        this.plot_contour = new JRadioButtonMenuItem("Plot Contour");
        this.mode_2d.add(this.plot_contour);
        this.mode_2d_bg.add(this.plot_contour);
        this.plot_contour.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.SetMode2D(2);
                }
            }
        });
        this.plot_image = new JRadioButtonMenuItem("Plot Image");
        this.mode_2d.add(this.plot_image);
        this.mode_2d_bg.add(this.plot_image);
        this.plot_image.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WavePopup.this.wave.setShowSigImage(true);
                    WavePopup.this.SetMode2D(3);
                } else {
                    WavePopup.this.wave.setShowSigImage(false);
                }
            }
        });
        this.sep1 = new JSeparator();
        this.sep2 = new JSeparator();
        this.autoscale = new JMenuItem("Autoscale");
        this.autoscale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.wave.Autoscale();
            }
        });
        this.autoscaleY = new JMenuItem("Autoscale Y");
        this.autoscaleY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.wave.AutoscaleY();
            }
        });
        this.autoscaleAll = new JMenuItem("Autoscale all");
        this.autoscaleAll.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.autoscaleAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WavePopup.this.wave.IsImage()) {
                    ((WaveformManager)((Object)WavePopup.this.parent)).autoscaleAllImages();
                } else {
                    ((WaveformManager)((Object)WavePopup.this.parent)).autoscaleAll();
                }
            }
        });
        this.autoscaleAllY = new JMenuItem("Autoscale all Y");
        this.autoscaleAllY.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.autoscaleAllY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformManager)((Object)WavePopup.this.parent)).autoscaleAllY();
            }
        });
        this.allSameScale = new JMenuItem("All same scale");
        this.allSameScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformManager)((Object)WavePopup.this.parent)).allSameScale(WavePopup.this.wave);
            }
        });
        this.allSameXScale = new JMenuItem("All same X scale");
        this.allSameXScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformManager)((Object)WavePopup.this.parent)).allSameXScale(WavePopup.this.wave);
            }
        });
        this.allSameXScaleAutoY = new JMenuItem("All same X scale (auto Y)");
        this.allSameXScaleAutoY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformManager)((Object)WavePopup.this.parent)).allSameXScaleAutoY(WavePopup.this.wave);
            }
        });
        this.allSameYScale = new JMenuItem("All same Y scale");
        this.allSameYScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformManager)((Object)WavePopup.this.parent)).allSameYScale(WavePopup.this.wave);
            }
        });
        this.resetScales = new JMenuItem("Reset scales");
        this.resetScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.wave.ResetScales();
            }
        });
        this.resetAllScales = new JMenuItem("Reset all scales");
        this.resetAllScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformManager)((Object)WavePopup.this.parent)).resetAllScales();
            }
        });
        this.undo_zoom = new JMenuItem("Undo Zoom");
        this.undo_zoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.wave.undoZoom();
            }
        });
        this.cb_copy = new JMenuItem("Copy to Clipboard");
        this.cb_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension dim = WavePopup.this.wave.getSize();
                BufferedImage ri = new BufferedImage(dim.width, dim.height, 1);
                Graphics2D g2d = (Graphics2D)ri.getGraphics();
                g2d.setBackground(Color.white);
                WavePopup.this.wave.paint(g2d, dim, 2);
                try {
                    ImageTransferable imageTransferable = new ImageTransferable(ri);
                    Clipboard cli = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cli.setContents(imageTransferable, imageTransferable);
                }
                catch (Exception exc) {
                    System.out.println("Exception " + exc);
                }
            }
        });
        this.playFrame = new JMenuItem();
        this.playFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WavePopup.this.wave.Playing()) {
                    WavePopup.this.wave.StopFrame();
                } else {
                    WavePopup.this.wave.PlayFrame();
                }
            }
        });
        this.profile_dialog = new JMenuItem("Show profile dialog");
        this.profile_dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.ShowProfileDialog(WavePopup.this.wave);
            }
        });
        this.colorMap = new JMenuItem("Color Palette");
        this.colorMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WavePopup.this.ShowColorMapDialog(WavePopup.this.wave);
            }
        });
        this.sep3 = new JSeparator();
        this.saveAsText = new JMenuItem("Save as text ...");
        this.saveAsText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WaveformContainer)WavePopup.this.parent).SaveAsText(WavePopup.this.wave, false);
            }
        });
    }

    protected void InitColorMenu() {
        if (!Waveform.isColorsChanged() && this.colorList_bg != null) {
            return;
        }
        if (this.colorList.getItemCount() != 0) {
            this.colorList.removeAll();
        }
        String[] colors_name = Waveform.getColorsName();
        JRadioButtonMenuItem ob = null;
        this.colorList_bg = new ButtonGroup();
        if (colors_name != null) {
            for (int i = 0; i < colors_name.length; ++i) {
                ob = new JRadioButtonMenuItem(colors_name[i]);
                this.colorList.add(ob);
                ob.getModel().setActionCommand("COLOR_LIST " + i);
                this.colorList_bg.add(ob);
                ob.addItemListener(this);
            }
        }
    }

    protected void InitOptionMenu() {
        boolean state = this.wave.GetShowSignalCount() == 1;
        this.markerList.setEnabled(state);
        this.colorList.setEnabled(state);
        this.set_point.setEnabled(true);
        if (state) {
            int st;
            boolean state_m = this.wave.GetMarker() != 0;
            this.markerStep.setEnabled(state_m);
            this.SelectListItem(this.markerList_bg, this.wave.GetMarker());
            for (st = 0; st < Signal.markerStepList.length && Signal.markerStepList[st] != this.wave.GetMarkerStep(); ++st) {
            }
            this.SelectListItem(this.markerStep_bg, st);
            this.SelectListItem(this.colorList_bg, this.wave.GetColorIdx());
        } else {
            this.markerStep.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object target = e.getSource();
        if (target instanceof JRadioButtonMenuItem && e.getStateChange() == 1) {
            JRadioButtonMenuItem cb = (JRadioButtonMenuItem)target;
            String action_cmd = cb.getModel().getActionCommand();
            if (action_cmd == null) {
                return;
            }
            StringTokenizer act = new StringTokenizer(action_cmd);
            String action = act.nextToken();
            int idx = Integer.parseInt(act.nextToken());
            if (action.equals("MARKER")) {
                this.SetMarker(idx);
                this.markerStep.setEnabled(this.wave.GetMarker() != 0 && this.wave.GetMarker() != 5);
                this.wave.ReportChanges();
                return;
            }
            if (action.equals("MARKER_STEP")) {
                this.SetMarkerStep(Signal.markerStepList[idx]);
                this.wave.ReportChanges();
                return;
            }
            if (action.equals("COLOR_LIST")) {
                this.SetColor(idx);
                this.wave.ReportChanges();
                return;
            }
        }
    }

    protected void SelectListItem(ButtonGroup bg, int idx) {
        if (idx >= 0 && idx < bg.getButtonCount()) {
            AbstractButton b = null;
            Enumeration<AbstractButton> e = bg.getElements();
            for (int i = 0; i <= idx; ++i) {
                b = e.nextElement();
            }
            bg.setSelected(b.getModel(), true);
        }
    }

    protected void SetColor(int idx) {
        if (this.wave.GetColorIdx() != idx) {
            this.wave.SetColorIdx(idx);
        }
    }

    public void setColorMapDialog(ColorMapDialog colorMapDialog) {
        this.colorMapDialog = colorMapDialog;
    }

    public void SetDeselectPoint(Waveform w) {
        if (w.ShowMeasure()) {
            if (this.parent != null && this.parent instanceof WaveformManager) {
                ((WaveformManager)((Object)this.parent)).setShowMeasure(false);
            }
            w.SetShowMeasure(false);
        } else {
            if (this.parent != null && this.parent instanceof WaveformManager) {
                ((WaveformManager)((Object)this.parent)).setShowMeasure(true);
            }
            w.SetShowMeasure(true);
            w.SetPointMeasure();
        }
        w.repaint();
    }

    protected void SetImageMenu() {
        this.SetMenuItem(true);
        boolean state = this.wave.frames != null && this.wave.frames.getNumFrame() != 0;
        this.colorList.setEnabled(state);
        this.SelectListItem(this.colorList_bg, this.wave.GetColorIdx());
        this.playFrame.setEnabled(state);
        this.set_point.setEnabled(state && this.wave.mode == 2);
        this.profile_dialog.setEnabled(!this.wave.isSendProfile());
    }

    protected void SetMarker(int idx) {
        if (this.wave.GetMarker() != idx) {
            this.wave.SetMarker(idx);
        }
    }

    protected void SetMarkerStep(int step) {
        if (this.wave.GetMarkerStep() != step) {
            this.wave.SetMarkerStep(step);
        }
    }

    protected void SetMenu() {
        this.InitColorMenu();
        if (this.wave.is_image) {
            this.SetImageMenu();
        } else {
            this.SetSignalMenu();
        }
        if (this.parent != null && this.parent instanceof WaveformManager) {
            this.remove_panel.setEnabled(((WaveformManager)((Object)this.parent)).getWaveformCount() > 1);
        }
    }

    protected void SetMenuItem(boolean is_image) {
        if (this.getComponentCount() != 0) {
            this.removeAll();
        }
        if (this.parent != null && this.parent instanceof WaveformManager) {
            if (((WaveformManager)((Object)this.parent)).isMaximize()) {
                this.maximize.setText("Show All Panels");
            } else {
                this.maximize.setText("Maximize Panel");
            }
        }
        if (is_image) {
            this.add(this.setup);
            this.colorList.setText("Colors");
            if (this.profDialog != null) {
                this.add(this.profile_dialog);
            }
            if (this.parent != null && this.parent instanceof WaveformManager) {
                this.add(this.maximize);
                this.add(this.remove_panel);
            }
            this.add(this.colorList);
            this.add(this.colorMap);
            this.add(this.playFrame);
            this.add(this.set_point);
            this.add(this.sep2);
            this.add(this.autoscale);
            if (this.parent != null && this.parent instanceof WaveformManager) {
                this.autoscaleAll.setText("Autoscale all images");
                this.add(this.autoscaleAll);
                this.maximize.setEnabled(((WaveformManager)((Object)this.parent)).getWaveformCount() > 1);
            }
            this.set_point.setEnabled(this.wave.mode == 2);
        } else {
            this.add(this.setup);
            this.setup.setEnabled(this.setup_params != null);
            this.add(this.set_point);
            this.set_point.setEnabled(this.wave.mode == 2);
            this.add(this.sep1);
            this.add(this.markerList);
            this.add(this.markerStep);
            this.colorList.setText("Colors");
            this.add(this.colorList);
            if (this.wave.mode == 2 || this.wave.GetShowSignalCount() == 1) {
                if (this.wave.getSignalType() == 0 || this.wave.getSignalType() == 1 && (this.wave.getSignalMode2D() == 0 || this.wave.getSignalMode2D() == 1)) {
                    this.add(this.mode_1d);
                    switch (this.wave.getSignalMode1D()) {
                        case 0: {
                            this.mode_1d_bg.setSelected(this.plot_line.getModel(), true);
                            break;
                        }
                        case 2: {
                            this.mode_1d_bg.setSelected(this.plot_no_line.getModel(), true);
                            break;
                        }
                        case 3: {
                            this.mode_1d_bg.setSelected(this.plot_step.getModel(), true);
                        }
                    }
                }
                if (this.wave.getSignalType() == 1) {
                    this.add(this.colorMap);
                    this.add(this.mode_2d);
                    this.mode_2d.setEnabled(this.wave.getSignalMode2D() != 5);
                    switch (this.wave.getSignalMode2D()) {
                        case 0: {
                            this.mode_2d_bg.setSelected(this.plot_y_time.getModel(), true);
                            break;
                        }
                        case 1: {
                            this.mode_2d_bg.setSelected(this.plot_x_y.getModel(), true);
                            break;
                        }
                        case 2: {
                            this.mode_2d_bg.setSelected(this.plot_contour.getModel(), true);
                            break;
                        }
                        case 3: {
                            this.mode_2d_bg.setSelected(this.plot_image.getModel(), true);
                        }
                    }
                    this.plot_image.setEnabled(!this.wave.IsShowSigImage());
                }
            }
            this.add(this.sep2);
            this.add(this.autoscale);
            this.add(this.autoscaleY);
            if (this.parent != null && this.parent instanceof WaveformManager) {
                this.insert(this.maximize, 1);
                this.insert(this.remove_panel, 2);
                this.autoscaleAll.setText("Autoscale all");
                this.add(this.autoscaleAll);
                this.add(this.autoscaleAllY);
                this.add(this.allSameScale);
                this.add(this.allSameXScale);
                this.add(this.allSameXScaleAutoY);
                this.add(this.allSameYScale);
                this.add(this.resetAllScales);
                this.maximize.setEnabled(((WaveformManager)((Object)this.parent)).getWaveformCount() > 1);
            }
            this.add(this.resetScales);
            this.add(this.undo_zoom);
            this.add(this.cb_copy);
            this.add(this.sep3);
            this.add(this.saveAsText);
        }
    }

    protected void SetMenuLabel() {
        if (!this.wave.IsImage()) {
            if (this.wave.ShowMeasure()) {
                this.set_point.setText("Deselect Point");
            } else {
                this.set_point.setText("Set Point");
            }
        } else {
            if (this.wave.ShowMeasure()) {
                this.set_point.setText("Deselect Point");
            } else {
                this.set_point.setText("Set Point");
            }
            if (this.wave.is_playing) {
                this.playFrame.setText("Stop play");
            } else {
                this.playFrame.setText("Start play");
            }
        }
    }

    protected void SetMode1D(int mode) {
        this.wave.setSignalMode1D(mode);
    }

    protected void SetMode2D(int mode) {
        this.wave.setSignalMode2D(mode);
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    protected void SetSignalMenu() {
        this.SetMenuItem(false);
        if (this.wave.GetShowSignalCount() != 0) {
            this.InitOptionMenu();
        } else {
            this.markerList.setEnabled(false);
            this.colorList.setEnabled(false);
            this.markerStep.setEnabled(false);
            this.set_point.setEnabled(false);
        }
        this.undo_zoom.setEnabled(this.wave.undoZoomPendig());
    }

    public void Show(Waveform w, int x, int y, int tran_x, int tran_y) {
        this.wave = w;
        this.SetMenu();
        this.SetMenuLabel();
        this.curr_x = x;
        this.curr_y = y;
        this.show(w, x - tran_x, y - tran_y);
    }

    public void ShowColorMapDialog(Waveform wave) {
        if (this.colorMapDialog == null) {
            this.colorMapDialog = new ColorMapDialog(null, null);
        } else {
            this.colorMapDialog.setWave(wave);
        }
        this.colorMapDialog.setLocationRelativeTo(wave);
        this.colorMapDialog.setVisible(true);
    }

    protected void ShowDialog() {
        if (this.setup_params != null) {
            this.setup_params.Show(this.wave);
        }
    }

    public void ShowProfileDialog(Waveform wave) {
        if (this.profDialog != null && this.profDialog.isVisible()) {
            this.profDialog.dispose();
        }
        this.profDialog.setWaveSource(wave);
        this.profDialog.pack();
        this.profDialog.setSize(200, 250);
        if (this.profile_source != null) {
            this.profile_source.setSendProfile(false);
        }
        wave.setSendProfile(true);
        this.profile_source = wave;
        this.profDialog.setLocationRelativeTo(wave);
        this.profDialog.setVisible(true);
        wave.sendProfileEvent();
    }
}

