/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.Int32;
import MDSplus.MdsException;

public class Int32Array
extends Array {
    int[] datum = new int[0];

    public Int32Array(int[] inDatum) {
        this.help = null;
        this.units = null;
        this.error = null;
        this.validation = null;
        this.clazz = 4;
        this.dtype = 8;
        this.dims = new int[1];
        this.dims[0] = inDatum.length;
        this.datum = new int[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
    }

    public Int32Array(int[] inDatum, int[] dims) throws MdsException {
        this(inDatum, dims, null, null, null, null);
    }

    public Int32Array(int[] inDatum, int[] dims, Data help, Data units, Data error, Data validation) throws MdsException {
        super(dims, help, units, error, validation);
        this.clazz = 4;
        this.dtype = 8;
        this.datum = new int[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
        this.setShape(dims);
    }

    private static int getTotSize(int[][] arr) {
        int totSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            totSize += arr[i].length;
        }
        return totSize;
    }

    private static int[] copyToLinearized(int[][] arr, int[] linArr) {
        int currSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            System.arraycopy(arr[i], 0, linArr, currSize, arr[i].length);
            currSize += arr[i].length;
        }
        return linArr;
    }

    private static int[] getDims(int[][] arr) {
        int[] d = new int[]{arr.length, arr[0].length};
        return d;
    }

    public Int32Array(int[][] inDatum) throws MdsException {
        this(Int32Array.copyToLinearized(inDatum, new int[Int32Array.getTotSize(inDatum)]), Int32Array.getDims(inDatum));
    }

    private static int getTotSize(int[][][] arr) {
        int totSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                totSize += arr[i][j].length;
            }
        }
        return totSize;
    }

    private static int[] copyToLinearized(int[][][] arr, int[] linArr) {
        int currSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                System.arraycopy(linArr, currSize, arr[i][j], 0, arr[i][j].length);
                currSize += arr[i][j].length;
            }
        }
        return linArr;
    }

    private static int[] getDims(int[][][] arr) {
        int[] d = new int[]{arr.length, arr[0].length, arr[0][0].length};
        return d;
    }

    public Int32Array(int[][][] inDatum) throws MdsException {
        this(Int32Array.copyToLinearized(inDatum, new int[Int32Array.getTotSize(inDatum)]), Int32Array.getDims(inDatum));
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof Int32Array)) {
            return false;
        }
        Int32Array data = (Int32Array)obj;
        if (data.dims.length != this.dims.length) {
            return false;
        }
        for (i = 0; i < this.dims.length; ++i) {
            if (data.dims[i] == this.dims[i]) continue;
            return false;
        }
        for (i = 0; i < this.datum.length; ++i) {
            if (data.datum[i] == this.datum[i]) continue;
            return false;
        }
        return true;
    }

    public static Data getData(int[] datum, int[] dims, Data help, Data units, Data error, Data validation) {
        try {
            return new Int32Array(datum, dims, help, units, error, validation);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public Data getElementAt(int idx) {
        return new Int32(this.datum[idx]);
    }

    @Override
    public int getSize() {
        return this.datum.length;
    }

    @Override
    protected Array getPortionAt(int startIdx, int[] newDims, int newSize) throws MdsException {
        int[] newDatum = new int[newSize];
        System.arraycopy(this.datum, startIdx, newDatum, 0, newSize);
        return new Int32Array(newDatum, newDims);
    }

    @Override
    public void setElementAt(int idx, Data data) throws MdsException {
        this.datum[idx] = data.getInt();
    }

    @Override
    protected void setPortionAt(Array data, int startIdx, int size) throws MdsException {
        int[] newDatum = data.getIntArray();
        System.arraycopy(this.datum, startIdx, newDatum, 0, size);
    }

    @Override
    public byte[] getByteArray() {
        byte[] retDatum = new byte[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (byte)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public short[] getShortArray() {
        short[] retDatum = new short[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (short)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public int[] getIntArray() {
        int[] retDatum = new int[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public long[] getLongArray() {
        long[] retDatum = new long[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public float[] getFloatArray() {
        float[] retDatum = new float[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public double[] getDoubleArray() {
        double[] retDatum = new double[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public String[] getStringArray() throws MdsException {
        throw new MdsException("Cannot convert byte array to string array");
    }

    @Override
    public int getSizeInBytes() {
        return this.getSize() * 4;
    }
}

