/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Data;
import MDSplus.Float32Array;
import MDSplus.String;
import java.lang.reflect.Method;

public class Scope {
    private static boolean loaded = false;
    private static Method createWindow;
    private static Method removeAllSignals;
    private static Method showWindow;
    private static Method addSignal;
    Object window;

    public Scope(java.lang.String name, int x, int y, int width, int height) {
        try {
            if (!loaded) {
                Class<?> cls = Class.forName("mds.jscope.CompositeWaveDisplay");
                createWindow = cls.getMethod("createWindow", String.class);
                showWindow = cls.getMethod("showWindow", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                removeAllSignals = cls.getMethod("removeAllSignals", Integer.TYPE, String.class);
                addSignal = cls.getMethod("addSignal", float[].class, float[].class, Integer.TYPE, Integer.TYPE, String.class, String.class, Boolean.TYPE, Integer.TYPE);
            }
            this.window = createWindow.invoke(null, name);
            showWindow.invoke(this.window, x, y, width, height);
        }
        catch (Exception e) {
            this.window = e;
        }
        loaded = true;
    }

    public void plot(Data x, Data y, int row, int col, java.lang.String color) throws Exception {
        if (this.window instanceof Exception) {
            throw (Exception)this.window;
        }
        removeAllSignals.invoke(this.window, row, col);
        this.oplot(x, y, row, col, color);
    }

    public void oplot(Data x, Data y, int row, int col, java.lang.String color) throws Exception {
        addSignal.invoke(this.window, x.getFloatArray(), y.getFloatArray(), row, col, color, "", true, 0);
    }

    public static void main(java.lang.String[] args) {
        Scope scope = new Scope("CACCA", 100, 100, 100, 100);
        float[] x = new float[1000];
        float[] y1 = new float[1000];
        float[] y2 = new float[1000];
        for (int i = 0; i < 1000; ++i) {
            x[i] = i;
            y1[i] = x[i] * x[i];
            y2[i] = 2.0f * y1[i];
        }
        try {
            scope.plot(new Float32Array(x), new Float32Array(y1), 1, 1, "black");
            scope.oplot(new Float32Array(x), new Float32Array(y2), 1, 1, "red");
        }
        catch (Exception exc) {
            System.err.println(exc);
        }
    }
}

