/*
 * Decompiled with CFR 0.152.
 */
package mds.jscope;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import mds.jscope.FontPanel;
import mds.jscope.jScopeFacade;

public class FontSelection
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    JLabel fontLabel;
    JLabel sizeLabel;
    JLabel styleLabel;
    JLabel testLabel;
    JRadioButton application_i;
    JRadioButton waveform_i;
    JButton ok;
    JButton cancel;
    JButton apply;
    FontPanel fontC;
    JComboBox<String> fonts;
    JComboBox<String> sizes;
    JComboBox<String> styles;
    String[] size_l;
    String[] style_l;
    int index = 0;
    String fontchoice = "fontchoice";
    int stChoice = 0;
    String siChoice = "10";
    jScopeFacade main_scope;
    Font font;

    public FontSelection(Frame dw, String title) {
        super(dw, title, true);
        this.main_scope = (jScopeFacade)dw;
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel topPanel = new JPanel();
        JPanel fontPanel = new JPanel();
        JPanel sizePanel = new JPanel();
        JPanel stylePanel = new JPanel();
        JPanel sizeAndStylePanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JPanel fontSelectionPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(5, 5));
        fontPanel.setLayout(new GridLayout(2, 1));
        sizePanel.setLayout(new GridLayout(2, 1));
        stylePanel.setLayout(new GridLayout(2, 1));
        fontSelectionPanel.setLayout(new GridLayout(2, 1));
        sizeAndStylePanel.setLayout(new BorderLayout());
        buttonPanel.setLayout(new FlowLayout());
        topPanel.add("West", fontPanel);
        sizeAndStylePanel.add("West", sizePanel);
        sizeAndStylePanel.add("Center", stylePanel);
        topPanel.add("Center", sizeAndStylePanel);
        topPanel.add("South", fontSelectionPanel);
        this.getContentPane().add("North", topPanel);
        this.fontLabel = new JLabel();
        this.fontLabel.setText("Fonts");
        Font newFont = this.getFont();
        this.fontLabel.setFont(newFont);
        this.fontLabel.setHorizontalAlignment(0);
        fontPanel.add(this.fontLabel);
        this.sizeLabel = new JLabel();
        this.sizeLabel.setText("Sizes");
        this.sizeLabel.setFont(newFont);
        this.sizeLabel.setHorizontalAlignment(0);
        sizePanel.add(this.sizeLabel);
        this.styleLabel = new JLabel();
        this.styleLabel.setText("Styles");
        this.styleLabel.setFont(newFont);
        this.styleLabel.setHorizontalAlignment(0);
        stylePanel.add(this.styleLabel);
        ButtonGroup font_selection = new ButtonGroup();
        this.application_i = new JRadioButton("Application");
        fontSelectionPanel.add(this.application_i);
        this.waveform_i = new JRadioButton("Waveform", true);
        fontSelectionPanel.add(this.waveform_i);
        font_selection.add(this.application_i);
        font_selection.add(this.waveform_i);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        this.fonts = new JComboBox<String>(envfonts);
        this.fonts.addItemListener(this);
        this.fontchoice = envfonts[0];
        fontPanel.add(this.fonts);
        this.size_l = new String[]{"10", "12", "14", "16", "18", "20", "22", "24", "26", "28"};
        this.sizes = new JComboBox<String>(this.size_l);
        this.sizes.addItemListener(this);
        sizePanel.add(this.sizes);
        this.style_l = new String[]{"PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"};
        this.styles = new JComboBox<String>(this.style_l);
        this.styles.addItemListener(this);
        stylePanel.add(this.styles);
        this.fontC = new FontPanel();
        this.fontC.setBackground(Color.white);
        this.getContentPane().add("Center", this.fontC);
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        this.apply = new JButton("Apply");
        this.apply.addActionListener(this);
        buttonPanel.add(this.apply);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        buttonPanel.add(this.cancel);
        this.getContentPane().add("South", buttonPanel);
        this.pack();
        this.GetPropertiesValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob == this.ok || ob == this.apply) {
            if (this.waveform_i.isSelected()) {
                this.font = this.GetFont();
                this.main_scope.UpdateFont();
                this.main_scope.RepaintAllWaves();
                this.main_scope.setChange(true);
            }
            if (this.application_i.isSelected()) {
                this.main_scope.SetApplicationFonts(this.GetFont());
            }
            if (ob == this.ok) {
                this.setVisible(false);
            }
        }
        if (ob == this.cancel) {
            this.setVisible(false);
        }
    }

    public void fromFile(Properties pr, String prompt) throws IOException {
        String prop = pr.getProperty(prompt);
        if (prop != null) {
            this.font = this.StringToFont(prop);
        }
        if (this.font != null) {
            this.setFontChoice();
            this.fontC.changeFont(this.font);
        }
    }

    public Font GetFont() {
        this.fontchoice = (String)this.fonts.getSelectedItem();
        this.stChoice = this.styles.getSelectedIndex();
        this.siChoice = (String)this.sizes.getSelectedItem();
        Font f = new Font(this.fontchoice, this.stChoice, Integer.parseInt(this.siChoice));
        f = this.StringToFont(f.toString());
        return f;
    }

    private void GetPropertiesValue() {
        Properties js_prop = this.main_scope.js_prop;
        if (js_prop == null) {
            return;
        }
        String prop = js_prop.getProperty("jScope.font.application");
        if (prop != null) {
            this.main_scope.SetApplicationFonts(this.StringToFont(prop));
        }
        this.font = (prop = js_prop.getProperty("jScope.font")) == null ? this.StringToFont(this.getFont().toString()) : this.StringToFont(prop);
        if (this.font != null) {
            this.setFontChoice();
            this.fontC.changeFont(this.font);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this.fontC.changeFont(this.GetFont());
    }

    private void setFontChoice() {
        this.fonts.removeItemListener(this);
        this.styles.removeItemListener(this);
        this.sizes.removeItemListener(this);
        this.fonts.setSelectedItem(this.fontchoice);
        this.styles.setSelectedIndex(this.stChoice);
        this.sizes.setSelectedItem(this.siChoice);
        this.fonts.addItemListener(this);
        this.styles.addItemListener(this);
        this.sizes.addItemListener(this);
    }

    public Font StringToFont(String f) {
        int i;
        if (f.indexOf("java.awt.Font[") == -1) {
            return null;
        }
        if (jScopeFacade.is_debug) {
            System.out.println("Font desiderato " + f);
        }
        int pos = f.indexOf(",name=");
        this.fontchoice = f.substring(f.indexOf("family=") + 7, pos);
        int n = f.indexOf("style=", ++pos) + 6;
        pos = f.indexOf(",size", pos);
        String style = f.substring(n, pos);
        for (i = 0; i < this.style_l.length && !this.style_l[i].equals(style.toUpperCase()); ++i) {
        }
        this.stChoice = i == this.style_l.length ? 0 : i;
        this.siChoice = f.substring(f.indexOf("size=") + 5, f.indexOf("]", pos));
        Font font = new Font(this.fontchoice, this.stChoice, Integer.parseInt(this.siChoice));
        if (!this.fontC.isFontAvailable(font)) {
            this.fontchoice = "Default";
            this.stChoice = 0;
            this.siChoice = "12";
            font = new Font(this.fontchoice, this.stChoice, Integer.parseInt(this.siChoice));
        }
        if (jScopeFacade.is_debug) {
            System.out.println("Font ottenuto " + font);
        }
        return font;
    }

    public void toFile(PrintWriter out, String prompt) {
        if (this.font != null) {
            out.println(prompt + ": " + this.font.toString());
        }
        out.println("");
    }
}

