/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import mds.provider.MdsDataProvider;
import mds.wave.DataServerItem;

public class FtuDataProvider
extends MdsDataProvider {
    public FtuDataProvider() {
    }

    public FtuDataProvider(String provider) throws IOException {
        super(provider);
        this.setEnvironment("public _IMODE = 0;");
    }

    @Override
    public synchronized float[] GetFloatArray(String in) throws IOException {
        this.error = null;
        float[] out_array = super.GetFloatArray(this.ParseExpression(in));
        if (out_array == null && this.error == null) {
            this.error = "Cannot evaluate " + in + " for shot " + this.shot;
        }
        if (out_array != null && out_array.length <= 1) {
            this.error = "Cannot evaluate " + in + " for shot " + this.shot;
            return null;
        }
        return out_array;
    }

    @Override
    public int[] getIntArray(String in) throws IOException {
        return super.getIntArray(this.ParseExpression(in));
    }

    @Override
    public int inquireCredentials(JFrame f, DataServerItem server_item) {
        return 1;
    }

    private String ParseExpression(String in) {
        StringTokenizer st = new StringTokenizer(in, "\\", true);
        StringBuffer parsed = new StringBuffer();
        int state = 0;
        try {
            while (st.hasMoreTokens()) {
                String curr_str = st.nextToken();
                switch (state) {
                    case 0: {
                        if (curr_str.equals("\\")) {
                            state = 1;
                            break;
                        }
                        parsed.append(curr_str);
                        break;
                    }
                    case 1: {
                        if (curr_str.equals("\\")) {
                            parsed.append("\\");
                            state = 0;
                            break;
                        }
                        if (curr_str.startsWith("$")) {
                            parsed.append("ftu(" + this.shot + ",\"_" + curr_str.substring(1));
                        } else {
                            parsed.append("ftu(" + this.shot + ",\"" + curr_str);
                        }
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (!st.hasMoreTokens()) {
                            parsed.append("\", _IMODE)");
                        }
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (!curr_str.equals("\\") || !st.hasMoreTokens()) {
                            parsed.append("\", _IMODE) " + curr_str);
                            state = 0;
                            break;
                        }
                        parsed.append("\\");
                        state = 4;
                        break;
                    }
                    case 4: {
                        if (curr_str.equals("\\")) {
                            parsed.append("\\");
                            state = 4;
                            break;
                        }
                        parsed.append(curr_str);
                        state = 2;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return parsed.toString();
    }

    @Override
    public void setArgument(String arg) throws IOException {
        this.mds.setProvider(arg);
        this.setEnvironment("public _IMODE = 0;");
    }

    @Override
    public void SetCompression(boolean state) {
    }

    @Override
    public boolean SupportsCompression() {
        return false;
    }

    @Override
    public synchronized void update(String exp, long s) {
        this.error = null;
        this.shot = s;
    }
}

