/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JFrame;
import mds.wave.Signal;
import mds.wave.Waveform;
import mds.wave.WaveformEditorListener;

public class WaveformEditor
extends Waveform {
    private static final long serialVersionUID = 1L;
    public static final float MIN_STEP = 1.0E-6f;
    static float[] copyX;
    static float[] copyY;
    float[] currentX;
    float[] currentY;
    float minY;
    float maxY;
    int closestIdx = -1;
    Vector<WaveformEditorListener> listeners = new Vector();
    protected boolean editable = false;

    public static void main(String[] args) {
        float[] x = new float[10];
        float[] y = new float[10];
        for (int i = 0; i < 10; ++i) {
            x[i] = (float)((double)i / 10.0);
            y[i] = 0.0f;
        }
        WaveformEditor we = new WaveformEditor();
        we.setWaveform(x, y, -10.0f, 20.0f);
        JFrame frame = new JFrame("Test WaveformEditor");
        frame.setSize(400, 300);
        frame.getContentPane().add(we);
        frame.pack();
        frame.setVisible(true);
    }

    public WaveformEditor() {
        this.setupCopyPaste();
    }

    public WaveformEditor(float[] x, float[] y, float minY, float maxY) {
        super(new Signal(x, y, x.length, x[0], x[x.length - 1], minY, maxY));
        this.SetMarker(1);
        this.currentX = x;
        this.currentY = y;
        this.minY = minY;
        this.maxY = maxY;
        this.setupCopyPaste();
    }

    public synchronized void addWaveformEditorListener(WaveformEditorListener listener) {
        this.listeners.add(listener);
    }

    int convertXPix(float x) {
        return this.wm.XPixel(x, this.getWaveSize());
    }

    int convertYPix(float y) {
        return this.wm.YPixel(y, this.getWaveSize());
    }

    public synchronized void notifyUpdate(float[] waveX, float[] waveY, int newIdx) {
        for (WaveformEditorListener l : this.listeners) {
            l.waveformUpdated(waveX, waveY, newIdx);
        }
    }

    @Override
    public void print(Graphics g) {
        System.out.println("WAVE PRINT");
        this.paint(g, this.getSize(), 1);
    }

    public synchronized void removeWaveformEditorListener(WaveformEditorListener listener) {
        this.listeners.remove(listener);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    protected void setMouse() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int newIdx = -1;
                int currX = e.getX();
                int currY = e.getY();
                int minDist = Integer.MAX_VALUE;
                int prevIdx = -1;
                WaveformEditor.this.closestIdx = 0;
                for (int i = 0; i < WaveformEditor.this.currentX.length; ++i) {
                    int currentYPix;
                    int currentXPix;
                    int currDist;
                    if (prevIdx == -1 && i < WaveformEditor.this.currentX.length - 1 && WaveformEditor.this.convertXPix(WaveformEditor.this.currentX[i + 1]) > currX) {
                        prevIdx = i;
                    }
                    if ((currDist = (currX - (currentXPix = WaveformEditor.this.convertXPix(WaveformEditor.this.currentX[i]))) * (currX - currentXPix) + (currY - (currentYPix = WaveformEditor.this.convertYPix(WaveformEditor.this.currentY[i]))) * (currY - currentYPix)) >= minDist) continue;
                    minDist = currDist;
                    WaveformEditor.this.closestIdx = i;
                }
                WaveformEditor.this.notifyUpdate(WaveformEditor.this.currentX, WaveformEditor.this.currentY, WaveformEditor.this.closestIdx);
                if (!WaveformEditor.this.editable) {
                    return;
                }
                if ((e.getModifiersEx() & 0x1000) != 0) {
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        if (WaveformEditor.this.closestIdx != 0 && WaveformEditor.this.closestIdx != WaveformEditor.this.currentX.length - 1) {
                            float[] newCurrentX = new float[WaveformEditor.this.currentX.length - 1];
                            float[] newCurrentY = new float[WaveformEditor.this.currentY.length - 1];
                            int j = 0;
                            int i = 0;
                            while (i < WaveformEditor.this.closestIdx) {
                                newCurrentX[i] = WaveformEditor.this.currentX[i];
                                newCurrentY[i] = WaveformEditor.this.currentY[i];
                                ++i;
                                ++j;
                            }
                            i = WaveformEditor.this.closestIdx + 1;
                            while (i < WaveformEditor.this.currentX.length) {
                                newCurrentX[j] = WaveformEditor.this.currentX[i];
                                newCurrentY[j] = WaveformEditor.this.currentY[i];
                                ++i;
                                ++j;
                            }
                            WaveformEditor.this.currentX = newCurrentX;
                            WaveformEditor.this.currentY = newCurrentY;
                        }
                    } else {
                        float newX = WaveformEditor.this.convertX(e.getX());
                        float[] newCurrentX = new float[WaveformEditor.this.currentX.length + 1];
                        float[] newCurrentY = new float[WaveformEditor.this.currentY.length + 1];
                        int j = 0;
                        int i = 0;
                        while (i <= prevIdx) {
                            newCurrentX[i] = WaveformEditor.this.currentX[i];
                            newCurrentY[i] = WaveformEditor.this.currentY[i];
                            ++i;
                            ++j;
                        }
                        newCurrentX[j] = newX;
                        newCurrentY[j] = WaveformEditor.this.currentY[j - 1] + (newX - WaveformEditor.this.currentX[j - 1]) * (WaveformEditor.this.currentY[j] - WaveformEditor.this.currentY[j - 1]) / (WaveformEditor.this.currentX[j] - WaveformEditor.this.currentX[j - 1]);
                        ++j;
                        i = prevIdx + 1;
                        while (i < WaveformEditor.this.currentX.length) {
                            newCurrentX[j] = WaveformEditor.this.currentX[i];
                            newCurrentY[j] = WaveformEditor.this.currentY[i];
                            ++i;
                            ++j;
                        }
                        WaveformEditor.this.currentX = newCurrentX;
                        WaveformEditor.this.currentY = newCurrentY;
                        newIdx = prevIdx + 1;
                    }
                    Signal newSig = new Signal(WaveformEditor.this.currentX, WaveformEditor.this.currentY, WaveformEditor.this.currentX.length, WaveformEditor.this.currentX[0], WaveformEditor.this.currentX[WaveformEditor.this.currentX.length - 1], WaveformEditor.this.minY, WaveformEditor.this.maxY);
                    newSig.setMarker(1);
                    WaveformEditor.this.Update(newSig);
                    WaveformEditor.this.notifyUpdate(WaveformEditor.this.currentX, WaveformEditor.this.currentY, newIdx);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WaveformEditor.this.closestIdx = -1;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent e) {
                if (!WaveformEditor.this.editable) {
                    return;
                }
                WaveformEditor waveformEditor = WaveformEditor.this;
                synchronized (waveformEditor) {
                    float currY;
                    float currX;
                    if (WaveformEditor.this.closestIdx == -1) {
                        return;
                    }
                    try {
                        currX = WaveformEditor.this.convertX(e.getX());
                        currY = WaveformEditor.this.convertY(e.getY());
                    }
                    catch (Exception exc) {
                        return;
                    }
                    if (WaveformEditor.this.closestIdx > 0 && WaveformEditor.this.closestIdx < WaveformEditor.this.currentX.length - 1) {
                        if (currX < WaveformEditor.this.currentX[WaveformEditor.this.closestIdx - 1] + 1.0E-6f) {
                            currX = WaveformEditor.this.currentX[WaveformEditor.this.closestIdx - 1] + 1.0E-6f;
                        }
                        if (currX > WaveformEditor.this.currentX[WaveformEditor.this.closestIdx + 1] - 1.0E-6f) {
                            currX = WaveformEditor.this.currentX[WaveformEditor.this.closestIdx + 1] - 1.0E-6f;
                        }
                    } else {
                        currX = WaveformEditor.this.currentX[WaveformEditor.this.closestIdx];
                    }
                    WaveformEditor.this.currentX[WaveformEditor.this.closestIdx] = currX;
                    if (currY < WaveformEditor.this.minY) {
                        currY = WaveformEditor.this.minY;
                    }
                    if (currY > WaveformEditor.this.maxY) {
                        currY = WaveformEditor.this.maxY;
                    }
                    WaveformEditor.this.currentY[WaveformEditor.this.closestIdx] = currY;
                    Signal newSig = new Signal(WaveformEditor.this.currentX, WaveformEditor.this.currentY, WaveformEditor.this.currentX.length, WaveformEditor.this.currentX[0], WaveformEditor.this.currentX[WaveformEditor.this.currentX.length - 1], WaveformEditor.this.minY, WaveformEditor.this.maxY);
                    newSig.setMarker(1);
                    WaveformEditor.this.Update(newSig);
                    WaveformEditor.this.notifyUpdate(WaveformEditor.this.currentX, WaveformEditor.this.currentY, -1);
                }
            }
        });
    }

    protected void setupCopyPaste() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WaveformEditor.this.requestFocus();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if ((ke.getModifiersEx() & 0x80) != 0 && ke.getKeyCode() == 67) {
                    copyX = new float[WaveformEditor.this.currentX.length];
                    copyY = new float[WaveformEditor.this.currentY.length];
                    for (int i = 0; i < WaveformEditor.this.currentX.length && i < WaveformEditor.this.currentY.length; ++i) {
                        WaveformEditor.copyX[i] = WaveformEditor.this.currentX[i];
                        WaveformEditor.copyY[i] = WaveformEditor.this.currentY[i];
                    }
                }
                if ((ke.getModifiersEx() & 0x80) != 0 && ke.getKeyCode() == 86) {
                    if (copyX == null) {
                        return;
                    }
                    Signal sig = new Signal(copyX, copyY, copyX.length, copyX[0], copyX[copyX.length - 1], WaveformEditor.this.minY, WaveformEditor.this.maxY);
                    sig.setMarker(1);
                    WaveformEditor.this.currentX = new float[copyX.length];
                    WaveformEditor.this.currentY = new float[copyY.length];
                    for (int i = 0; i < copyX.length; ++i) {
                        WaveformEditor.this.currentX[i] = copyX[i];
                        WaveformEditor.this.currentY[i] = copyY[i];
                    }
                    WaveformEditor.this.Update(sig);
                    WaveformEditor.this.notifyUpdate(WaveformEditor.this.currentX, WaveformEditor.this.currentY, WaveformEditor.this.currentX.length - 1);
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }

            @Override
            public void keyTyped(KeyEvent ke) {
            }
        });
    }

    public void setWaveform(float[] x, float[] y, float minY, float maxY) {
        Signal sig = new Signal(x, y, x.length, x[0], x[x.length - 1], minY, maxY);
        sig.setMarker(1);
        this.currentX = new float[x.length];
        this.currentY = new float[y.length];
        for (int i = 0; i < x.length; ++i) {
            this.currentX[i] = x[i];
            this.currentY[i] = y[i];
        }
        this.minY = minY;
        this.maxY = maxY;
        this.Update(sig);
    }
}

