/*
 * Decompiled with CFR 0.152.
 */
package mds.wave;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import mds.wave.WavePopup;
import mds.wave.Waveform;
import mds.wave.WaveformContainer;
import mds.wave.WaveformEvent;
import mds.wave.WaveformListener;

public class ProfileDialog
extends JDialog
implements WaveformListener {
    private static final long serialVersionUID = 1L;
    static final String[] TITLE = new String[]{"X profile", "Y profile", "Pixel time profile"};
    private final WaveformContainer profile_container;
    int[] row = new int[]{2};
    Waveform[] wave = new Waveform[2];
    Waveform w_profile_line = null;
    private Waveform source_profile = null;

    public ProfileDialog(JFrame parent, Waveform source_profile) {
        super((Frame)parent, "Profile Dialog");
        this.source_profile = source_profile;
        this.profile_container = new WaveformContainer(this.row, false);
        WavePopup wp = new WavePopup();
        this.profile_container.setPopupMenu(wp);
        for (int i = 0; i < 2; ++i) {
            this.wave[i] = new Waveform();
            this.wave[i].SetTitle(TITLE[i]);
        }
        this.profile_container.add(this.wave);
        this.getContentPane().add(this.profile_container);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProfileDialog.this.source_profile != null) {
                    ProfileDialog.this.source_profile.setSendProfile(false);
                    ProfileDialog.this.source_profile.removeWaveformListener(ProfileDialog.this);
                }
                ProfileDialog.this.dispose();
            }
        });
        this.setAlwaysOnTop(true);
    }

    public void addProfileLine() {
        this.w_profile_line = new Waveform();
        this.profile_container.add((Component)this.w_profile_line, 3, 1);
        this.w_profile_line.SetTitle("Line Profile");
        this.profile_container.update();
    }

    @Override
    public void processWaveformEvent(WaveformEvent e) {
        WaveformEvent we = e;
        int we_id = we.getID();
        switch (we_id) {
            case 2007: {
                if (!this.isShowing()) break;
                if (e.frame_type == 5 || e.frame_type == 3 || e.frame_type == 6 || e.frame_type == 4 || e.frame_type == 7) {
                    this.updateProfiles(e.name, e.x_pixel, e.y_pixel, e.time_value, e.values_x, e.start_pixel_x, e.values_y, e.start_pixel_y);
                    if (e.values_line != null) {
                        this.updateProfileLine(e.values_line);
                        break;
                    }
                    this.removeProfileLine();
                    break;
                }
                this.updateProfiles(e.name, e.x_pixel, e.y_pixel, e.time_value, e.pixels_x, e.start_pixel_x, e.pixels_y, e.start_pixel_y);
                if (e.pixels_line != null) {
                    this.updateProfileLine(e.pixels_line);
                    break;
                }
                this.removeProfileLine();
            }
        }
    }

    public void removeProfileLine() {
        if (this.w_profile_line == null) {
            return;
        }
        this.profile_container.removeComponent(this.w_profile_line);
        this.w_profile_line = null;
        this.profile_container.update();
    }

    public void setWaveSource(Waveform source_profile) {
        if (this.source_profile != null) {
            this.source_profile.removeWaveformListener(this);
        }
        this.source_profile = source_profile;
        source_profile.addWaveformListener(this);
    }

    public synchronized void updateProfileLine(float[] values_line) {
        float[] xt = new float[values_line.length];
        if (this.w_profile_line == null) {
            this.addProfileLine();
        }
        for (int i = 0; i < values_line.length; ++i) {
            xt[i] = i;
        }
        this.w_profile_line.Update(xt, values_line);
    }

    public synchronized void updateProfileLine(int[] pixels_line) {
        float[] x = new float[pixels_line.length];
        float[] xt = new float[pixels_line.length];
        if (this.w_profile_line == null) {
            this.addProfileLine();
        }
        for (int i = 0; i < pixels_line.length; ++i) {
            x[i] = pixels_line[i] & 0xFF;
            xt[i] = i;
        }
        this.w_profile_line.Update(xt, x);
    }

    public synchronized void updateProfiles(String name, int x_pixel, int y_pixel, double time, float[] values_x, int start_pixel_x, float[] values_y, int start_pixel_y) {
        int i;
        this.setTitle("Profile Dialog - " + name + " x_pix : " + x_pixel + " y_pix : " + y_pixel + " time : " + time);
        if (values_x != null && values_x.length > 0) {
            float[] xt = new float[values_x.length];
            for (i = 0; i < values_x.length; ++i) {
                xt[i] = (float)start_pixel_x + (float)i;
            }
            this.wave[0].setProperties("expr=" + name + "\nx_pix=" + x_pixel + "\ny_pix=" + y_pixel + "\ntime=" + time + "\n");
            this.wave[0].Update(xt, values_x);
        }
        if (values_y != null && values_y.length > 0) {
            float[] yt = new float[values_y.length];
            for (i = 0; i < values_y.length; ++i) {
                yt[i] = (float)start_pixel_y + (float)i;
            }
            this.wave[1].setProperties("expr=" + name + "\nx_pix=" + x_pixel + "\ny_pix=" + y_pixel + "\ntime=" + time + "\n");
            this.wave[1].Update(yt, values_y);
        }
    }

    public synchronized void updateProfiles(String name, int x_pixel, int y_pixel, double time, int[] pixels_x, int start_pixel_x, int[] pixels_y, int start_pixel_y) {
        int i;
        this.setTitle("Profile Dialog - " + name + " x_pix : " + x_pixel + " y_pix : " + y_pixel + " time : " + time);
        if (pixels_x != null && pixels_x.length > 0) {
            float[] x = new float[pixels_x.length];
            float[] xt = new float[pixels_x.length];
            for (i = 0; i < pixels_x.length; ++i) {
                x[i] = pixels_x[i] & 0xFF;
                xt[i] = (float)start_pixel_x + (float)i;
            }
            this.wave[0].setProperties("expr=" + name + "\nx_pix=" + x_pixel + "\ny_pix=" + y_pixel + "\ntime=" + time + "\n");
            this.wave[0].Update(xt, x);
        }
        if (pixels_y != null && pixels_y.length > 0) {
            float[] y = new float[pixels_y.length];
            float[] yt = new float[pixels_y.length];
            for (i = 0; i < pixels_y.length; ++i) {
                y[i] = pixels_y[i] & 0xFF;
                yt[i] = (float)start_pixel_y + (float)i;
            }
            this.wave[1].setProperties("expr=" + name + "\nx_pix=" + x_pixel + "\ny_pix=" + y_pixel + "\ntime=" + time + "\n");
            this.wave[1].Update(yt, y);
        }
    }
}

