/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.DataStreamListener;
import MDSplus.Event;
import MDSplus.Float32;
import MDSplus.Float32Array;
import MDSplus.MdsException;
import MDSplus.Scalar;
import MDSplus.Uint64;
import MDSplus.Uint64Array;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class EventStream
extends Event {
    static boolean debug = false;
    String streamName;
    Hashtable<String, Vector<DataStreamListener>> listenerHash = new Hashtable();

    public EventStream() throws MdsException {
        super("STREAMING");
    }

    public EventStream(String streamName) throws MdsException {
        super(streamName);
        this.streamName = streamName;
    }

    public synchronized void registerListener(DataStreamListener listener) {
        this.registerListener(this.streamName, listener);
    }

    public synchronized void registerListener(String streamName, DataStreamListener listener) {
        Vector<DataStreamListener> listenerV = this.listenerHash.get(streamName);
        if (listenerV == null) {
            listenerV = new Vector();
        }
        listenerV.addElement(listener);
        this.listenerHash.put(streamName, listenerV);
    }

    private static String toJSON(int shot, String chanName, float[] times, float[] samples) {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        JsonArrayBuilder timesArr = factory.createArrayBuilder();
        for (int i = 0; i < times.length; ++i) {
            timesArr.add((double)times[i]);
        }
        JsonArrayBuilder samplesArr = factory.createArrayBuilder();
        for (int i = 0; i < samples.length; ++i) {
            samplesArr.add((double)samples[i]);
        }
        JsonObjectBuilder streamObj = factory.createObjectBuilder();
        streamObj.add("name", chanName);
        streamObj.add("timestamp", 0);
        streamObj.add("shot", shot);
        streamObj.add("absolute_time", 0);
        streamObj.add("times", (JsonValue)timesArr.build());
        streamObj.add("samples", (JsonValue)samplesArr.build());
        String jsonString = "";
        try {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write((JsonStructure)streamObj.build());
            jsonString = ((Object)writer).toString();
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return jsonString;
    }

    private static String toJSON(int shot, String chanName, long[] times, float[] samples) {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        JsonArrayBuilder timesArr = factory.createArrayBuilder();
        for (int i = 0; i < times.length; ++i) {
            timesArr.add(times[i]);
        }
        JsonArrayBuilder samplesArr = factory.createArrayBuilder();
        for (int i = 0; i < samples.length; ++i) {
            samplesArr.add((double)samples[i]);
        }
        JsonObjectBuilder streamObj = factory.createObjectBuilder();
        streamObj.add("name", chanName);
        streamObj.add("timestamp", 0);
        streamObj.add("shot", shot);
        streamObj.add("absolute_time", 1);
        streamObj.add("times", (JsonValue)timesArr.build());
        streamObj.add("samples", (JsonValue)samplesArr.build());
        String jsonString = "";
        try {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write((JsonStructure)streamObj.build());
            jsonString = ((Object)writer).toString();
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return jsonString;
    }

    public static void send(int shot, String streamName, float time, float sample) {
        String payload = EventStream.toJSON(shot, streamName, new float[]{time}, new float[]{sample});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, float time, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, new float[]{time}, samples);
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long time, float sample) {
        String payload = EventStream.toJSON(shot, streamName, new long[]{time}, new float[]{sample});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long time, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, new long[]{time}, samples);
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long[] times, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, times, samples);
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, float[] times, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, times, samples);
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, Data timesD, Data samplesD) {
        try {
            String payload;
            float[] samples = samplesD instanceof Array ? samplesD.getFloatArray() : new float[]{samplesD.getFloat()};
            if (timesD instanceof Uint64) {
                long[] absTimes = new long[]{timesD.getLong()};
                payload = EventStream.toJSON(shot, streamName, absTimes, samples);
            } else if (timesD instanceof Uint64Array) {
                long[] absTimes = timesD.getLongArray();
                payload = EventStream.toJSON(shot, streamName, absTimes, samples);
            } else if (timesD instanceof Array) {
                float[] relTimes = timesD.getFloatArray();
                payload = EventStream.toJSON(shot, streamName, relTimes, samples);
            } else {
                float[] relTimes = new float[]{timesD.getFloat()};
                payload = EventStream.toJSON(shot, streamName, relTimes, samples);
            }
            System.out.println(payload);
            EventStream.seteventRaw(streamName, payload.getBytes());
        }
        catch (Exception exc) {
            System.out.println("Cannot send stream: " + exc);
        }
    }

    private void handleEventJSON(String evString) {
        Data timesD;
        int i;
        Object[] times;
        JsonReader reader = Json.createReader((Reader)new StringReader(evString));
        JsonObject evObj = reader.readObject();
        int shot = evObj.getInt("shot");
        String streamName = evObj.getString("name");
        boolean isAbsTime = evObj.getInt("absolute_time") == 1;
        JsonArray samplesArr = evObj.getJsonArray("samples");
        JsonArray timesArr = evObj.getJsonArray("times");
        float[] samples = new float[samplesArr.size()];
        for (int i2 = 0; i2 < samplesArr.size(); ++i2) {
            samples[i2] = (float)samplesArr.getJsonNumber(i2).doubleValue();
        }
        Data samplesD = samples.length == 1 ? new Float32(samples[0]) : new Float32Array(samples);
        if (isAbsTime) {
            times = new long[timesArr.size()];
            for (i = 0; i < timesArr.size(); ++i) {
                times[i] = timesArr.getJsonNumber(i).longValue();
            }
            timesD = times.length == 1 ? new Uint64(times[0]) : new Uint64Array((long[])times);
        } else {
            times = new float[timesArr.size()];
            for (i = 0; i < timesArr.size(); ++i) {
                times[i] = (long)timesArr.getJsonNumber(i).doubleValue();
            }
            timesD = times.length == 1 ? new Float32(times[0]) : new Float32Array((float[])times);
        }
        Vector<DataStreamListener> listeners = this.listenerHash.get(streamName);
        for (i = 0; i < listeners.size(); ++i) {
            listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
        }
    }

    @Override
    public synchronized void run() {
        String evName = this.getName();
        byte[] rawMsg = this.getRaw();
        String evMessage = new String(rawMsg);
        if (evMessage.charAt(0) == '{') {
            this.handleEventJSON(evMessage);
            return;
        }
        int byteIdx = 0;
        if (debug) {
            System.out.println(evMessage);
        }
        StringTokenizer st = new StringTokenizer(evMessage);
        try {
            String currStr = st.nextToken();
            byteIdx = currStr.length() + 1;
            int shot = Integer.parseInt(currStr);
            String streamName = st.nextToken();
            byteIdx += streamName.length() + 1;
            Vector<DataStreamListener> listeners = this.listenerHash.get(streamName);
            if (listeners != null && listeners.size() > 0) {
                String mode = st.nextToken();
                byteIdx += 2;
                currStr = st.nextToken();
                byteIdx += currStr.length() + 1;
                int numSamples = Integer.parseInt(currStr);
                if (mode.equals("B")) {
                    byte[] serTimes = new byte[numSamples];
                    byte[] serSamples = new byte[rawMsg.length - byteIdx - numSamples];
                    System.arraycopy(rawMsg, byteIdx, serTimes, 0, numSamples);
                    System.arraycopy(rawMsg, byteIdx + numSamples, serSamples, 0, rawMsg.length - byteIdx - numSamples);
                    Data timesD = Data.deserialize(serTimes);
                    Data samplesD = Data.deserialize(serSamples);
                    for (int i = 0; i < listeners.size(); ++i) {
                        listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
                    }
                    return;
                }
                if (numSamples == 1) {
                    Scalar timeD = mode.equals("A") || mode.equals("F") ? new Float32(Float.parseFloat(st.nextToken())) : new Uint64(Long.parseLong(st.nextToken()));
                    Float32 sampleD = new Float32(Float.parseFloat(st.nextToken()));
                    for (int i = 0; i < listeners.size(); ++i) {
                        DataStreamListener listener = listeners.elementAt(i);
                        listener.dataReceived(streamName, shot, timeD, sampleD);
                    }
                } else {
                    Array timesD;
                    int i;
                    Object[] times;
                    if (mode.equals("A") || mode.equals("F")) {
                        times = new float[numSamples];
                        for (i = 0; i < numSamples; ++i) {
                            times[i] = Float.parseFloat(st.nextToken());
                        }
                        timesD = new Float32Array((float[])times);
                    } else {
                        times = new long[numSamples];
                        for (i = 0; i < numSamples; ++i) {
                            times[i] = Long.parseLong(st.nextToken());
                        }
                        timesD = new Uint64Array((long[])times);
                    }
                    float[] samples = new float[numSamples];
                    for (i = 0; i < numSamples; ++i) {
                        samples[i] = Float.parseFloat(st.nextToken());
                    }
                    Float32Array samplesD = new Float32Array(samples);
                    for (i = 0; i < listeners.size(); ++i) {
                        listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
                    }
                }
            }
        }
        catch (Exception exc) {
            System.out.println("Error getting data from stream: " + exc);
        }
    }

    public static void main(String[] args) {
        try {
            EventStream es = new EventStream("ciccior");
            es.registerListener(new DataStreamListener(){

                @Override
                public void dataReceived(String streamName, int shot, Data times, Data samples) {
                    System.out.println(streamName + " Time: " + times + "Sample: " + samples);
                }
            });
            Thread.currentThread();
            Thread.sleep(1000000L);
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }
}

