/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.MdsException;
import MDSplus.Uint32;

public class Uint32Array
extends Array {
    int[] datum;

    public Uint32Array(int[] inDatum) {
        this.help = null;
        this.units = null;
        this.error = null;
        this.validation = null;
        this.clazz = 4;
        this.dtype = 4;
        this.dims = new int[1];
        this.dims[0] = inDatum.length;
        this.datum = new int[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
    }

    public Uint32Array(int[] inDatum, int[] dims) throws MdsException {
        this(inDatum, dims, null, null, null, null);
    }

    public Uint32Array(int[] inDatum, int[] dims, Data help, Data units, Data error, Data validation) throws MdsException {
        super(dims, help, units, error, validation);
        this.clazz = 4;
        this.dtype = 4;
        this.datum = new int[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
        this.setShape(dims);
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof Uint32Array)) {
            return false;
        }
        Uint32Array data = (Uint32Array)obj;
        if (data.dims.length != this.dims.length) {
            return false;
        }
        for (i = 0; i < this.dims.length; ++i) {
            if (data.dims[i] == this.dims[i]) continue;
            return false;
        }
        for (i = 0; i < this.datum.length; ++i) {
            if (data.datum[i] == this.datum[i]) continue;
            return false;
        }
        return true;
    }

    public static Data getData(int[] datum, int[] dims, Data help, Data units, Data error, Data validation) {
        try {
            return new Uint32Array(datum, dims, help, units, error, validation);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public Data getElementAt(int idx) {
        return new Uint32(this.datum[idx]);
    }

    @Override
    public int getSize() {
        return this.datum.length;
    }

    @Override
    protected Array getPortionAt(int startIdx, int[] newDims, int newSize) throws MdsException {
        int[] newDatum = new int[newSize];
        System.arraycopy(this.datum, startIdx, newDatum, 0, newSize);
        return new Uint32Array(newDatum, newDims);
    }

    @Override
    public void setElementAt(int idx, Data data) throws MdsException {
        this.datum[idx] = data.getInt();
    }

    @Override
    protected void setPortionAt(Array data, int startIdx, int size) throws MdsException {
        int[] newDatum = data.getIntArray();
        System.arraycopy(this.datum, startIdx, newDatum, 0, size);
    }

    @Override
    public byte[] getByteArray() {
        byte[] retDatum = new byte[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (byte)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public short[] getShortArray() {
        short[] retDatum = new short[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (short)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public int[] getIntArray() {
        int[] retDatum = new int[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public long[] getLongArray() {
        long[] retDatum = new long[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public float[] getFloatArray() {
        float[] retDatum = new float[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public double[] getDoubleArray() {
        double[] retDatum = new double[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public String[] getStringArray() throws MdsException {
        throw new MdsException("Cannot convert byte array to string array");
    }

    @Override
    public int getSizeInBytes() {
        return this.getSize() * 4;
    }
}

