/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.Float64;
import MDSplus.MdsException;

public class Float64Array
extends Array {
    double[] datum;

    public Float64Array(double[] inDatum) {
        this.help = null;
        this.units = null;
        this.error = null;
        this.validation = null;
        this.clazz = 4;
        this.dtype = 53;
        this.dims = new int[1];
        this.dims[0] = inDatum.length;
        this.datum = new double[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
    }

    public Float64Array(double[] inDatum, int[] dims) throws MdsException {
        this(inDatum, dims, null, null, null, null);
    }

    public Float64Array(double[] inDatum, int[] dims, Data help, Data units, Data error, Data validation) throws MdsException {
        super(dims, help, units, error, validation);
        this.clazz = 4;
        this.dtype = 53;
        this.datum = new double[inDatum.length];
        System.arraycopy(inDatum, 0, this.datum, 0, inDatum.length);
        this.setShape(dims);
    }

    private static int getTotSize(double[][] arr) {
        int totSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            totSize += arr[i].length;
        }
        return totSize;
    }

    private static double[] copyToLinearized(double[][] arr, double[] linArr) {
        int currSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            System.arraycopy(arr[i], 0, linArr, currSize, arr[i].length);
            currSize += arr[i].length;
        }
        return linArr;
    }

    private static int[] getDims(double[][] arr) {
        int[] d = new int[]{arr.length, arr[0].length};
        return d;
    }

    public Float64Array(double[][] inDatum) throws MdsException {
        this(Float64Array.copyToLinearized(inDatum, new double[Float64Array.getTotSize(inDatum)]), Float64Array.getDims(inDatum));
    }

    private static int getTotSize(double[][][] arr) {
        int totSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                totSize += arr[i][j].length;
            }
        }
        return totSize;
    }

    private static double[] copyToLinearized(double[][][] arr, double[] linArr) {
        int currSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                System.arraycopy(linArr, currSize, arr[i][j], 0, arr[i][j].length);
                currSize += arr[i][j].length;
            }
        }
        return linArr;
    }

    private static int[] getDims(double[][][] arr) {
        int[] d = new int[]{arr.length, arr[0].length, arr[0][0].length};
        return d;
    }

    public Float64Array(double[][][] inDatum) throws MdsException {
        this(Float64Array.copyToLinearized(inDatum, new double[Float64Array.getTotSize(inDatum)]), Float64Array.getDims(inDatum));
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof Float64Array)) {
            return false;
        }
        Float64Array data = (Float64Array)obj;
        if (data.dims.length != this.dims.length) {
            return false;
        }
        for (i = 0; i < this.dims.length; ++i) {
            if (data.dims[i] == this.dims[i]) continue;
            return false;
        }
        for (i = 0; i < this.datum.length; ++i) {
            if (data.datum[i] == this.datum[i]) continue;
            return false;
        }
        return true;
    }

    public static Data getData(double[] datum, int[] dims, Data help, Data units, Data error, Data validation) {
        try {
            return new Float64Array(datum, dims, help, units, error, validation);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public Data getElementAt(int idx) {
        return new Float64(this.datum[idx]);
    }

    @Override
    public int getSize() {
        return this.datum.length;
    }

    @Override
    protected Array getPortionAt(int startIdx, int[] newDims, int newSize) throws MdsException {
        double[] newDatum = new double[newSize];
        System.arraycopy(this.datum, startIdx, newDatum, 0, newSize);
        return new Float64Array(newDatum, newDims);
    }

    @Override
    public void setElementAt(int idx, Data data) throws MdsException {
        this.datum[idx] = data.getDouble();
    }

    @Override
    protected void setPortionAt(Array data, int startIdx, int size) throws MdsException {
        double[] newDatum = data.getDoubleArray();
        System.arraycopy(this.datum, startIdx, newDatum, 0, size);
    }

    @Override
    public byte[] getByteArray() {
        byte[] retDatum = new byte[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (byte)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public short[] getShortArray() {
        short[] retDatum = new short[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (short)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public int[] getIntArray() {
        int[] retDatum = new int[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (int)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public long[] getLongArray() {
        long[] retDatum = new long[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (long)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public float[] getFloatArray() {
        float[] retDatum = new float[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = (float)this.datum[i];
        }
        return retDatum;
    }

    @Override
    public double[] getDoubleArray() {
        double[] retDatum = new double[this.datum.length];
        for (int i = 0; i < this.datum.length; ++i) {
            retDatum[i] = this.datum[i];
        }
        return retDatum;
    }

    @Override
    public String[] getStringArray() throws MdsException {
        throw new MdsException("Cannot convert byte array to string array");
    }

    @Override
    public int getSizeInBytes() {
        return this.getSize() * 8;
    }
}

