/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Data;
import MDSplus.MdsException;
import MDSplus.TreeNode;
import MDSplus.TreeNodeArray;
import MDSplus.TreePath;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Tree {
    static final int DbiNAME = 1;
    static final int DbiSHOTID = 2;
    static final int DbiMODIFIED = 3;
    static final int DbiOPEN_FOR_EDIT = 4;
    static final int DbiINDEX = 5;
    static final int DbiNUMBER_OPENED = 6;
    static final int DbiMAX_OPEN = 7;
    static final int DbiDEFAULT = 8;
    static final int DbiOPEN_READONLY = 9;
    static final int DbiVERSIONS_IN_MODEL = 10;
    static final int DbiVERSIONS_IN_PULSE = 11;
    public static final int TreeUSAGE_ANY = 0;
    public static final int TreeUSAGE_NONE = 1;
    public static final int TreeUSAGE_STRUCTURE = 1;
    public static final int TreeUSAGE_ACTION = 2;
    public static final int TreeUSAGE_DEVICE = 3;
    public static final int TreeUSAGE_DISPATCH = 4;
    public static final int TreeUSAGE_NUMERIC = 5;
    public static final int TreeUSAGE_SIGNAL = 6;
    public static final int TreeUSAGE_TASK = 7;
    public static final int TreeUSAGE_TEXT = 8;
    public static final int TreeUSAGE_WINDOW = 9;
    public static final int TreeUSAGE_AXIS = 10;
    public static final int TreeUSAGE_SUBTREE = 11;
    public static final int TreeUSAGE_COMPOUND_DATA = 12;
    private static Tree active;
    private final int shot;
    private final String name;
    private String mode;
    protected long ctx = 0L;
    private boolean open = false;
    private boolean edit = false;
    private static final String OPEN_CLOSED = "CLOSED";
    public static final String OPEN_NORMAL = "NORMAL";
    public static final String OPEN_READONLY = "READONLY";
    public static final String OPEN_NEW = "NEW";
    public static final String OPEN_EDIT = "EDIT";

    public Tree(String name, int shot) throws MdsException {
        this(name, shot, OPEN_NORMAL);
    }

    public Tree(String name, int shot, String mode) throws MdsException {
        this.shot = shot;
        this.name = name;
        if (OPEN_READONLY.equalsIgnoreCase(mode)) {
            this.readonly();
        } else if (OPEN_NORMAL.equalsIgnoreCase(mode)) {
            this.normal();
        } else if (OPEN_EDIT.equalsIgnoreCase(mode)) {
            this.edit();
        } else if (OPEN_NEW.equalsIgnoreCase(mode)) {
            this._new();
        } else {
            this.mode = OPEN_CLOSED;
        }
    }

    public void close() throws MdsException {
        if (this.open) {
            this.closeTree(this.ctx, this.name, this.shot);
        }
        this.open = false;
        this.edit = false;
        this.mode = OPEN_CLOSED;
    }

    protected void finalize() throws Throwable {
        if (this.edit) {
            this.quit();
        } else {
            this.close();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public String toString() {
        return "Tree(" + this.name + ", " + this.getShot() + ", " + this.mode + ")";
    }

    public static void setActiveTree(Tree tree) throws MdsException {
        active = tree;
    }

    static Tree getTree(String name, int shot) throws MdsException {
        return new Tree(name, shot);
    }

    public String getName() {
        return this.name;
    }

    public int getShot() {
        if (this.shot != 0) {
            return this.shot;
        }
        try {
            return this.getCurrent();
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public String getMode() {
        return this.mode;
    }

    static native int findNode(long var0, String var2) throws MdsException;

    private native void openTree(long var1, String var3, int var4, boolean var5) throws MdsException;

    private native void closeTree(long var1, String var3, int var4) throws MdsException;

    private native void editTree(long var1, String var3, int var4, boolean var5) throws MdsException;

    private native void writeTree(long var1, String var3, int var4) throws MdsException;

    private native void quitTree(long var1, String var3, int var4) throws MdsException;

    private static native int[] getWild(long var0, String var2, int var3) throws MdsException;

    private static native int getDefaultNid(long var0) throws MdsException;

    private static native void setDefaultNid(long var0, int var2) throws MdsException;

    private static native boolean getDbiFlag(long var0, int var2) throws MdsException;

    private static native void setDbiFlag(long var0, boolean var2, int var3) throws MdsException;

    private static native void setTreeViewDate(String var0) throws MdsException;

    private static native void setTreeTimeContext(long var0, Data var2, Data var3, Data var4);

    public static native void setCurrent(String var0, int var1) throws MdsException;

    private static native int getCurrent(String var0) throws MdsException;

    private static native void createPulseFile(long var0, int var2) throws MdsException;

    private static native void deletePulseFile(long var0, int var2) throws MdsException;

    private static native String[] findTreeTags(long var0, String var2) throws MdsException;

    private static native int addTreeNode(long var0, String var2, int var3) throws MdsException;

    private static native void addTreeDevice(long var0, String var2, String var3) throws MdsException;

    private static native void deleteTreeNode(long var0, String var2) throws MdsException;

    private static native void removeTreeTag(long var0, String var2) throws MdsException;

    private static native long getDatafileSize(long var0);

    private static native Data execute(long var0, String var2, Data[] var3);

    private static native Data compile(long var0, String var2, Data[] var3);

    private static native Data data(long var0, Data var2);

    private static native Data evaluate(long var0, Data var2);

    protected long getCtx() {
        return this.ctx;
    }

    public TreeNode getNode(String path) throws MdsException {
        TreeNode t = new TreeNode(Tree.findNode(this.ctx, path), this);
        t.setCtxTree(this);
        return t;
    }

    public TreeNode getNode(int nid) throws MdsException {
        return new TreeNode(nid, this);
    }

    public TreeNode getNode(TreePath path) throws MdsException {
        return new TreeNode(Tree.findNode(this.ctx, path.getString()), this);
    }

    public TreeNodeArray getNodeWild(String path) throws MdsException {
        return this.getNodeWild(path, -1);
    }

    public TreeNodeArray getNodeWild(String path, int usage) throws MdsException {
        return new TreeNodeArray(Tree.getWild(this.ctx, path, usage), this);
    }

    public TreeNodeArray getNodeWild(String path, String usage) throws MdsException {
        return this.getNodeWild(path, Tree.convertUsage(usage));
    }

    public TreeNode getDefault() throws MdsException {
        return new TreeNode(Tree.getDefaultNid(this.ctx), this);
    }

    public void setDefault(TreeNode node) throws MdsException {
        Tree.setDefaultNid(this.ctx, node.getNid());
    }

    public boolean versionsInModelEnabled() throws MdsException {
        return Tree.getDbiFlag(this.ctx, 10);
    }

    public boolean versionsInPulseEnabled() throws MdsException {
        return Tree.getDbiFlag(this.ctx, 11);
    }

    public void setVersionsInModel(boolean enabled) throws MdsException {
        Tree.setDbiFlag(this.ctx, enabled, 10);
    }

    public void setVersionsInPulse(boolean enabled) throws MdsException {
        Tree.setDbiFlag(this.ctx, enabled, 11);
    }

    public boolean isModified() throws MdsException {
        return Tree.getDbiFlag(this.ctx, 3);
    }

    public boolean isOpenForEdit() throws MdsException {
        return Tree.getDbiFlag(this.ctx, 4);
    }

    public boolean isReadOnly() throws MdsException {
        return Tree.getDbiFlag(this.ctx, 9);
    }

    public void setViewDate(Date date) throws MdsException {
        Tree.setTreeViewDate(new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(date));
    }

    public void setTimeContext(Data start, Data end, Data delta) throws MdsException {
        Tree.setTreeTimeContext(this.ctx, start, end, delta);
    }

    public void setCurrent() throws MdsException {
        Tree.setCurrent(this.name, this.shot);
    }

    public int getCurrent() throws MdsException {
        return Tree.getCurrent(this.name);
    }

    public void createPulse(int pulseShot) throws MdsException {
        Tree.createPulseFile(this.ctx, pulseShot);
    }

    public void deletePulse(int pulseShot) throws MdsException {
        Tree.deletePulseFile(this.ctx, pulseShot);
    }

    public String[] findTags(String wild) throws MdsException {
        return Tree.findTreeTags(this.ctx, wild);
    }

    public void normal() throws MdsException {
        this.openTree(this.ctx, this.name, this.shot, false);
        this.edit = false;
        this.open = true;
        this.mode = OPEN_NORMAL;
    }

    public void readonly() throws MdsException {
        this.openTree(this.ctx, this.name, this.shot, true);
        this.edit = false;
        this.open = true;
        this.mode = OPEN_READONLY;
    }

    public void edit() throws MdsException {
        this.editTree(this.ctx, this.name, this.shot, false);
        this.edit = true;
        this.open = true;
        this.mode = OPEN_EDIT;
    }

    private void _new() throws MdsException {
        this.editTree(this.ctx, this.name, this.shot, true);
        this.edit = true;
        this.open = true;
        this.mode = OPEN_EDIT;
    }

    public void write() throws MdsException {
        this.writeTree(this.ctx, this.name, this.shot);
    }

    public void quit() throws MdsException {
        if (this.open) {
            this.quitTree(this.ctx, this.name, this.shot);
        }
        this.open = false;
        this.edit = false;
        this.mode = OPEN_CLOSED;
    }

    static int convertUsage(String usageStr) {
        String upUsageStr = usageStr.toUpperCase();
        if (upUsageStr.equals("ANY")) {
            return 0;
        }
        if (upUsageStr.equals("STRUCTURE")) {
            return 1;
        }
        if (upUsageStr.equals("ACTION")) {
            return 2;
        }
        if (upUsageStr.equals("DEVICE")) {
            return 3;
        }
        if (upUsageStr.equals("DISPATCH")) {
            return 4;
        }
        if (upUsageStr.equals("NUMERIC")) {
            return 5;
        }
        if (upUsageStr.equals("SIGNAL")) {
            return 6;
        }
        if (upUsageStr.equals("TASK")) {
            return 7;
        }
        if (upUsageStr.equals("TEXT")) {
            return 8;
        }
        if (upUsageStr.equals("WINDOW")) {
            return 9;
        }
        if (upUsageStr.equals("AXIS")) {
            return 10;
        }
        if (upUsageStr.equals("SUBTREE")) {
            return 11;
        }
        if (upUsageStr.equals("COMPOUND_DATA")) {
            return 12;
        }
        return 0;
    }

    public TreeNode addNode(String name, String usage) throws MdsException {
        int newNid = Tree.addTreeNode(this.ctx, name, Tree.convertUsage(usage));
        return new TreeNode(newNid, this);
    }

    public void addDevice(String name, String type) throws MdsException {
        Tree.addTreeDevice(this.ctx, name, type);
    }

    public void deleteNode(String name) throws MdsException {
        Tree.deleteTreeNode(this.ctx, name);
    }

    public void removeTag(String tag) throws MdsException {
        Tree.removeTreeTag(this.ctx, tag);
    }

    public long getDatafileSize() throws MdsException {
        long size = Tree.getDatafileSize(this.ctx);
        if (size == -1L) {
            throw new MdsException("Cannot get Datafile Size");
        }
        return size;
    }

    public Data tdiCompile(String expr, Data ... args) {
        if (expr == null || expr.isEmpty()) {
            return new Data();
        }
        Data retData = Tree.compile(this.ctx, expr, args);
        retData.setCtxTree(this);
        return retData;
    }

    public Data tdiExecute(String expr, Data ... args) {
        if (expr == null || expr.isEmpty()) {
            return new Data();
        }
        Data retData = Tree.execute(this.ctx, expr, args);
        retData.setCtxTree(this);
        return retData;
    }

    public Data tdiData(Data data) {
        Data retData = Tree.data(this.ctx, data);
        retData.setCtxTree(this);
        return retData;
    }

    public Data tdiEvaluate(Data data) {
        Data retData = Tree.evaluate(this.ctx, data);
        retData.setCtxTree(this);
        return retData;
    }

    public static Tree getActiveTree() {
        return active;
    }

    static {
        try {
            boolean loaded = false;
            try {
                String value = System.getenv("JavaMdsLib");
                if (value == null) {
                    value = System.getProperty("JavaMdsLib");
                }
                if (value != null) {
                    System.load(value);
                    loaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loaded) {
                System.loadLibrary("JavaMds");
            }
        }
        catch (Throwable e) {
            System.out.println("Error loading library javamds: " + e);
            e.printStackTrace();
        }
    }
}

