/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Data;
import MDSplus.DataStreamListener;
import MDSplus.Event;
import MDSplus.Float32;
import MDSplus.Float32Array;
import MDSplus.MdsException;
import MDSplus.Scalar;
import MDSplus.Uint64;
import MDSplus.Uint64Array;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class EventStream
extends Event {
    static boolean debug = false;
    String streamName;
    Hashtable<String, Vector<DataStreamListener>> listenerHash = new Hashtable();
    static Hashtable<String, Long> seqHash = new Hashtable();

    public EventStream() throws MdsException {
        super("STREAMING");
    }

    public EventStream(String streamName) throws MdsException {
        super(streamName);
        this.streamName = streamName;
    }

    public synchronized void registerListener(DataStreamListener listener) {
        this.registerListener(this.streamName, listener);
    }

    public synchronized void registerListener(String streamName, DataStreamListener listener) {
        Vector<DataStreamListener> listenerV = this.listenerHash.get(streamName);
        if (listenerV == null) {
            listenerV = new Vector();
        }
        listenerV.addElement(listener);
        this.listenerHash.put(streamName, listenerV);
    }

    private static JsonArrayBuilder makeSampleArray(float[] samples, int[] dims, JsonBuilderFactory factory) {
        JsonArrayBuilder samplesArr = factory.createArrayBuilder();
        if (dims.length == 1) {
            for (int i = 0; i < samples.length; ++i) {
                samplesArr.add((double)samples[i]);
            }
            return samplesArr;
        }
        int sliceSize = 1;
        for (int i = 1; i < dims.length; ++i) {
            sliceSize *= dims[i];
        }
        int[] sliceDims = new int[dims.length - 1];
        System.arraycopy(dims, 1, sliceDims, 0, dims.length - 1);
        for (int i = 0; i < dims[0]; ++i) {
            float[] slice = new float[sliceSize];
            System.arraycopy(samples, i * sliceSize, slice, 0, sliceSize);
            samplesArr.add(EventStream.makeSampleArray(slice, sliceDims, factory));
        }
        return samplesArr;
    }

    static long getSeqNumber(String chanName) {
        Long seqL;
        try {
            seqL = seqHash.get(chanName);
            if (seqL == null) {
                seqL = new Long(0L);
            }
        }
        catch (Exception exc) {
            seqL = new Long(0L);
        }
        seqHash.put(chanName, new Long(seqL + 1L));
        return seqL;
    }

    private static String toJSON(int shot, String chanName, float[] times, float[] samples, int[] samplesDim) {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        JsonArrayBuilder timesArr = factory.createArrayBuilder();
        for (int i = 0; i < times.length; ++i) {
            timesArr.add((double)times[i]);
        }
        JsonArrayBuilder samplesArr = EventStream.makeSampleArray(samples, samplesDim, factory);
        JsonObjectBuilder streamObj = factory.createObjectBuilder();
        streamObj.add("name", chanName);
        streamObj.add("timestamp", new Date().getTime());
        streamObj.add("seq_number", EventStream.getSeqNumber(chanName));
        streamObj.add("shot", shot);
        streamObj.add("absolute_time", 0);
        streamObj.add("times", (JsonValue)timesArr.build());
        streamObj.add("samples", (JsonValue)samplesArr.build());
        String jsonString = "";
        try {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write((JsonStructure)streamObj.build());
            jsonString = ((Object)writer).toString();
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return jsonString;
    }

    private static String toJSON(int shot, String chanName, long[] times, float[] samples, int[] samplesDim) {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        JsonArrayBuilder timesArr = factory.createArrayBuilder();
        for (int i = 0; i < times.length; ++i) {
            timesArr.add(times[i]);
        }
        JsonArrayBuilder samplesArr = EventStream.makeSampleArray(samples, samplesDim, factory);
        JsonObjectBuilder streamObj = factory.createObjectBuilder();
        streamObj.add("name", chanName);
        streamObj.add("timestamp", new Date().getTime());
        streamObj.add("seq_number", EventStream.getSeqNumber(chanName));
        streamObj.add("shot", shot);
        streamObj.add("absolute_time", 1);
        streamObj.add("times", (JsonValue)timesArr.build());
        streamObj.add("samples", (JsonValue)samplesArr.build());
        String jsonString = "";
        try {
            StringWriter writer = new StringWriter();
            Json.createWriter((Writer)writer).write((JsonStructure)streamObj.build());
            jsonString = ((Object)writer).toString();
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        return jsonString;
    }

    public static void send(int shot, String streamName, float time, float sample) {
        String payload = EventStream.toJSON(shot, streamName, new float[]{time}, new float[]{sample}, new int[]{1});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, float time, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, new float[]{time}, samples, new int[]{samples.length});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long time, float sample) {
        String payload = EventStream.toJSON(shot, streamName, new long[]{time}, new float[]{sample}, new int[]{1});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long time, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, new long[]{time}, samples, new int[]{samples.length});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long[] times, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, times, samples, new int[]{samples.length});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, float[] times, float[] samples) {
        String payload = EventStream.toJSON(shot, streamName, times, samples, new int[]{samples.length});
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, long[] times, float[] samples, int[] samplesDim) {
        String payload = EventStream.toJSON(shot, streamName, times, samples, samplesDim);
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, float[] times, float[] samples, int[] samplesDim) {
        String payload = EventStream.toJSON(shot, streamName, times, samples, samplesDim);
        EventStream.seteventRaw(streamName, payload.getBytes());
    }

    public static void send(int shot, String streamName, Data timesD, Data samplesD) {
        try {
            String payload;
            int[] samplesDim;
            float[] samples;
            if (samplesD instanceof Array) {
                samples = samplesD.getFloatArray();
                samplesDim = samplesD.getShape();
            } else {
                samples = new float[]{samplesD.getFloat()};
                samplesDim = new int[]{1};
            }
            if (timesD instanceof Uint64) {
                long[] absTimes = new long[]{timesD.getLong()};
                payload = EventStream.toJSON(shot, streamName, absTimes, samples, samplesDim);
            } else if (timesD instanceof Uint64Array) {
                long[] absTimes = timesD.getLongArray();
                payload = EventStream.toJSON(shot, streamName, absTimes, samples, samplesDim);
            } else if (timesD instanceof Array) {
                float[] relTimes = timesD.getFloatArray();
                payload = EventStream.toJSON(shot, streamName, relTimes, samples, samplesDim);
            } else {
                float[] relTimes = new float[]{timesD.getFloat()};
                payload = EventStream.toJSON(shot, streamName, relTimes, samples, samplesDim);
            }
            System.out.println(payload);
            EventStream.seteventRaw(streamName, payload.getBytes());
        }
        catch (Exception exc) {
            System.out.println("Cannot send stream: " + exc);
        }
    }

    static int countArraySamples(JsonArray array) {
        try {
            double firstVal = array.getJsonNumber(0).doubleValue();
            return array.size();
        }
        catch (Exception exception) {
            return array.size() * EventStream.countArraySamples(array.getJsonArray(0));
        }
    }

    static int countArrayDims(JsonArray array) {
        try {
            double firstVal = array.getJsonNumber(0).doubleValue();
            return 1;
        }
        catch (Exception exception) {
            return EventStream.countArrayDims(array.getJsonArray(0)) + 1;
        }
    }

    static void readSamplesArr(JsonArray array, float[] samples, int samplesIdx, int[] dims, int dimIdx) {
        dims[dimIdx] = array.size();
        try {
            for (int i = 0; i < array.size(); ++i) {
                samples[samplesIdx + i] = (float)array.getJsonNumber(i).doubleValue();
            }
            return;
        }
        catch (Exception i) {
            int sliceSamples = EventStream.countArraySamples(array.getJsonArray(0));
            for (int i2 = 0; i2 < array.size(); ++i2) {
                EventStream.readSamplesArr(array.getJsonArray(i2), samples, samplesIdx + i2 * sliceSamples, dims, dimIdx - 1);
            }
            return;
        }
    }

    private void handleEventJSON(String evString) {
        Data timesD;
        int i;
        Object[] times;
        Data samplesD;
        JsonReader reader = Json.createReader((Reader)new StringReader(evString));
        JsonObject evObj = reader.readObject();
        int shot = evObj.getInt("shot");
        String streamName = evObj.getString("name");
        boolean isAbsTime = evObj.getInt("absolute_time") == 1;
        JsonArray samplesArr = evObj.getJsonArray("samples");
        JsonArray timesArr = evObj.getJsonArray("times");
        float[] samples = new float[EventStream.countArraySamples(samplesArr)];
        int[] dims = new int[EventStream.countArrayDims(samplesArr)];
        EventStream.readSamplesArr(samplesArr, samples, 0, dims, dims.length - 1);
        if (samples.length == 1) {
            samplesD = new Float32(samples[0]);
        } else {
            try {
                samplesD = new Float32Array(samples, dims);
            }
            catch (Exception exc) {
                System.out.println("Wrong sample array in data stream");
                return;
            }
        }
        if (isAbsTime) {
            times = new long[timesArr.size()];
            for (i = 0; i < timesArr.size(); ++i) {
                times[i] = timesArr.getJsonNumber(i).longValue();
            }
            timesD = times.length == 1 ? new Uint64(times[0]) : new Uint64Array((long[])times);
        } else {
            times = new float[timesArr.size()];
            for (i = 0; i < timesArr.size(); ++i) {
                times[i] = (long)timesArr.getJsonNumber(i).doubleValue();
            }
            timesD = times.length == 1 ? new Float32(times[0]) : new Float32Array((float[])times);
        }
        Vector<DataStreamListener> listeners = this.listenerHash.get(streamName);
        for (i = 0; i < listeners.size(); ++i) {
            listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
        }
    }

    @Override
    public synchronized void run() {
        String evName = this.getName();
        byte[] rawMsg = this.getRaw();
        String evMessage = new String(rawMsg);
        if (evMessage.charAt(0) == '{') {
            this.handleEventJSON(evMessage);
            return;
        }
        int byteIdx = 0;
        if (debug) {
            System.out.println(evMessage);
        }
        StringTokenizer st = new StringTokenizer(evMessage);
        try {
            String currStr = st.nextToken();
            byteIdx = currStr.length() + 1;
            int shot = Integer.parseInt(currStr);
            String streamName = st.nextToken();
            byteIdx += streamName.length() + 1;
            Vector<DataStreamListener> listeners = this.listenerHash.get(streamName);
            if (listeners != null && listeners.size() > 0) {
                String mode = st.nextToken();
                byteIdx += 2;
                currStr = st.nextToken();
                byteIdx += currStr.length() + 1;
                int numSamples = Integer.parseInt(currStr);
                if (mode.equals("B")) {
                    byte[] serTimes = new byte[numSamples];
                    byte[] serSamples = new byte[rawMsg.length - byteIdx - numSamples];
                    System.arraycopy(rawMsg, byteIdx, serTimes, 0, numSamples);
                    System.arraycopy(rawMsg, byteIdx + numSamples, serSamples, 0, rawMsg.length - byteIdx - numSamples);
                    Data timesD = Data.deserialize(serTimes);
                    Data samplesD = Data.deserialize(serSamples);
                    for (int i = 0; i < listeners.size(); ++i) {
                        listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
                    }
                    return;
                }
                if (numSamples == 1) {
                    Scalar timeD = mode.equals("A") || mode.equals("F") ? new Float32(Float.parseFloat(st.nextToken())) : new Uint64(Long.parseLong(st.nextToken()));
                    Float32 sampleD = new Float32(Float.parseFloat(st.nextToken()));
                    for (int i = 0; i < listeners.size(); ++i) {
                        DataStreamListener listener = listeners.elementAt(i);
                        listener.dataReceived(streamName, shot, timeD, sampleD);
                    }
                } else {
                    Array timesD;
                    int i;
                    Object[] times;
                    if (mode.equals("A") || mode.equals("F")) {
                        times = new float[numSamples];
                        for (i = 0; i < numSamples; ++i) {
                            times[i] = Float.parseFloat(st.nextToken());
                        }
                        timesD = new Float32Array((float[])times);
                    } else {
                        times = new long[numSamples];
                        for (i = 0; i < numSamples; ++i) {
                            times[i] = Long.parseLong(st.nextToken());
                        }
                        timesD = new Uint64Array((long[])times);
                    }
                    float[] samples = new float[numSamples];
                    for (i = 0; i < numSamples; ++i) {
                        samples[i] = Float.parseFloat(st.nextToken());
                    }
                    Float32Array samplesD = new Float32Array(samples);
                    for (i = 0; i < listeners.size(); ++i) {
                        listeners.elementAt(i).dataReceived(streamName, shot, timesD, samplesD);
                    }
                }
            }
        }
        catch (Exception exc) {
            System.out.println("Error getting data from stream: " + exc);
        }
    }

    public static void main(String[] args) {
        try {
            EventStream.send(0, "Channel1", new Float32Array(new float[]{0.0f, 1.0f}), new Float32Array(new float[]{10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f}, new int[]{2, 3}));
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }
}

