/*
 * Decompiled with CFR 0.152.
 */
package MDSplus;

import MDSplus.Array;
import MDSplus.Float32;
import MDSplus.Float32Array;
import MDSplus.Float64;
import MDSplus.Float64Array;
import MDSplus.Int16;
import MDSplus.Int16Array;
import MDSplus.Int32;
import MDSplus.Int32Array;
import MDSplus.Int64;
import MDSplus.Int64Array;
import MDSplus.Int8;
import MDSplus.Int8Array;
import MDSplus.MdsException;
import MDSplus.Scalar;
import MDSplus.Scope;
import MDSplus.String;
import MDSplus.StringArray;
import MDSplus.Tree;

public class Data {
    public static final int DTYPE_BU = 2;
    public static final int DTYPE_WU = 3;
    public static final int DTYPE_LU = 4;
    public static final int DTYPE_QU = 5;
    public static final int DTYPE_OU = 25;
    public static final int DTYPE_B = 6;
    public static final int DTYPE_W = 7;
    public static final int DTYPE_L = 8;
    public static final int DTYPE_Q = 9;
    public static final int DTYPE_O = 26;
    public static final int DTYPE_FLOAT = 52;
    public static final int DTYPE_DOUBLE = 53;
    public static final int DTYPE_T = 14;
    public static final int DTYPE_IDENT = 191;
    public static final int DTYPE_NID = 192;
    public static final int DTYPE_PATH = 193;
    public static final int DTYPE_PARAM = 194;
    public static final int DTYPE_SIGNAL = 195;
    public static final int DTYPE_DIMENSION = 196;
    public static final int DTYPE_WINDOW = 197;
    public static final int DTYPE_SLOPE = 198;
    public static final int DTYPE_FUNCTION = 199;
    public static final int DTYPE_CONGLOM = 200;
    public static final int DTYPE_RANGE = 201;
    public static final int DTYPE_ACTION = 202;
    public static final int DTYPE_DISPATCH = 203;
    public static final int DTYPE_PROGRAM = 204;
    public static final int DTYPE_ROUTINE = 205;
    public static final int DTYPE_PROCEDURE = 206;
    public static final int DTYPE_METHOD = 207;
    public static final int DTYPE_DEPENDENCY = 208;
    public static final int DTYPE_CONDITION = 209;
    public static final int DTYPE_EVENT = 210;
    public static final int DTYPE_WITH_UNITS = 211;
    public static final int DTYPE_CALL = 212;
    public static final int DTYPE_WITH_ERROR = 213;
    public static final int DTYPE_LIST = 214;
    public static final int DTYPE_TUPLE = 215;
    public static final int DTYPE_DICTIONARY = 216;
    public static final int DTYPE_DSC = 24;
    public static final int TreeNEGATE_CONDITION = 7;
    public static final int TreeIGNORE_UNDEFINED = 8;
    public static final int TreeIGNORE_STATUS = 9;
    public static final int TreeDEPENDENCY_AND = 10;
    public static final int TreeDEPENDENCY_OR = 11;
    public static final int CLASS_S = 1;
    public static final int CLASS_D = 2;
    public static final int CLASS_A = 4;
    public static final int CLASS_R = 194;
    public static final int CLASS_APD = 196;
    int clazz;
    int dtype;
    Data help;
    Data units;
    Data error;
    Data validation;
    Data dataCache;
    boolean changed = true;
    Tree ctxTree = null;

    boolean isImmutable() {
        return false;
    }

    boolean hasChanged() {
        return !this.isImmutable() || this.changed;
    }

    public Data() {
    }

    public Data(Data help, Data units, Data error, Data validation) {
        this.help = help;
        this.units = units;
        this.error = error;
        this.validation = validation;
    }

    public double[] toDouble() throws Exception {
        return this.getDoubleArray();
    }

    public void setCtxTree(Tree ctxTree) {
        this.ctxTree = ctxTree;
    }

    public Tree getCtxTree() {
        return this.ctxTree;
    }

    public static Data compile(java.lang.String expr) {
        return Data.compile(expr, new Data[0]);
    }

    public Data executeWithContext(java.lang.String expr, Data ... args) {
        if (this.ctxTree != null && this.ctxTree.isOpen()) {
            return this.ctxTree.tdiExecute(expr, args);
        }
        return Data.execute(expr, args);
    }

    protected static native java.lang.String convertToDate(long var0);

    public static native long getTime();

    public static native Data compile(java.lang.String var0, Data ... var1);

    public static native Data execute(java.lang.String var0, Data ... var1);

    public static native Data deserialize(byte[] var0);

    public native byte[] serialize();

    private native java.lang.String decompile(long var1);

    private native Data cloneData();

    private native Data dataData(long var1);

    private native String evaluateData(long var1);

    public static native java.lang.String getMdsMsg(int var0);

    public java.lang.String toString() {
        if (this.ctxTree != null) {
            try {
                return this.decompile(this.ctxTree.getCtx());
            }
            catch (Exception exc) {
                return "";
            }
        }
        return this.decompile(0L);
    }

    public Data data() {
        if (this.hasChanged()) {
            if (this.ctxTree != null && this.ctxTree.isOpen()) {
                try {
                    this.dataCache = this.dataData(this.ctxTree.getCtx());
                }
                catch (Exception exception) {}
            } else {
                this.dataCache = this.dataData(0L);
            }
            this.changed = false;
        }
        return this.dataCache.cloneData();
    }

    public String evaluate() {
        if (this.ctxTree != null && this.ctxTree.isOpen()) {
            try {
                return this.evaluateData(this.ctxTree.getCtx());
            }
            catch (Exception exc) {
                return new String("");
            }
        }
        return this.evaluateData(0L);
    }

    public byte getByte() throws MdsException {
        Data data = this.executeWithContext("BYTE(DATA($1))", this);
        if (!(data instanceof Scalar)) {
            throw new MdsException("Cannot convert Data to byte");
        }
        return data.getByte();
    }

    public short getShort() throws MdsException {
        Data data = this.executeWithContext("WORD(DATA($1))", this);
        if (!(data instanceof Scalar)) {
            throw new MdsException("Cannot convert Data to byte");
        }
        return data.getShort();
    }

    public int getInt() throws MdsException {
        Data data = this.executeWithContext("LONG(DATA($1))", this);
        if (!(data instanceof Scalar)) {
            throw new MdsException("Cannot convert Data to int");
        }
        return data.getInt();
    }

    public long getLong() throws MdsException {
        Data data = this.executeWithContext("QUADWORD(DATA($1))", this);
        if (!(data instanceof Scalar)) {
            throw new MdsException("Cannot convert Data to long");
        }
        return data.getLong();
    }

    public float getFloat() throws MdsException {
        Data data = this.executeWithContext("FLOAT(DATA($1))", this);
        if (!(data instanceof Scalar)) {
            throw new MdsException("Cannot convert Data to float");
        }
        return data.getFloat();
    }

    public double getDouble() throws MdsException {
        Data data = this.executeWithContext("FT_FLOAT(DATA($1))", this);
        if (!(data instanceof Scalar)) {
            throw new MdsException("Cannot convert Data to double");
        }
        return data.getDouble();
    }

    public int[] getShape() throws MdsException {
        Data data = this.executeWithContext("SHAPE($1)", this);
        if (!(data instanceof Array)) {
            throw new MdsException("Cannot get data shape");
        }
        return data.getIntArray();
    }

    public byte[] getByteArray() throws MdsException {
        Data data = this.executeWithContext("BYTE(DATA($1))", this);
        if (!(data instanceof Scalar) && !(data instanceof Array)) {
            throw new MdsException("Cannot convert Data to byte array");
        }
        return data.getByteArray();
    }

    public short[] getShortArray() throws MdsException {
        Data data = this.executeWithContext("WORD(DATA($1))", this);
        if (!(data instanceof Scalar) && !(data instanceof Array)) {
            throw new MdsException("Cannot convert Data to short array");
        }
        return data.getShortArray();
    }

    public int[] getIntArray() throws MdsException {
        Data data = this.executeWithContext("LONG(DATA($1))", this);
        if (!(data instanceof Scalar) && !(data instanceof Array)) {
            throw new MdsException("Cannot convert Data to int array");
        }
        return data.getIntArray();
    }

    public long[] getLongArray() throws MdsException {
        Data data = this.executeWithContext("QUADWORD(DATA($1))", this);
        if (!(data instanceof Scalar) && !(data instanceof Array)) {
            throw new MdsException("Cannot convert Data to long array");
        }
        return data.getLongArray();
    }

    public float[] getFloatArray() throws MdsException {
        Data data = this.executeWithContext("FLOAT(DATA($1))", this);
        if (!(data instanceof Scalar) && !(data instanceof Array)) {
            throw new MdsException("Cannot convert Data to float array");
        }
        return data.getFloatArray();
    }

    public double[] getDoubleArray() throws MdsException {
        Data data = this.executeWithContext("FT_FLOAT(DATA($1))", this);
        if (!(data instanceof Scalar) && !(data instanceof Array)) {
            throw new MdsException("Cannot convert Data to double array");
        }
        return data.getDoubleArray();
    }

    public java.lang.String getString() throws MdsException {
        Data data = this.data();
        if (!(data instanceof String)) {
            throw new MdsException("Cannot convert Data to string");
        }
        return data.getString();
    }

    public java.lang.String[] getStringArray() throws MdsException {
        Data data = this.data();
        if (!(data instanceof StringArray)) {
            throw new MdsException("Cannot convert Data to string array");
        }
        return data.getStringArray();
    }

    public int getSize() {
        Data data = this.data();
        return data.getSize();
    }

    public int getSizeInBytes() {
        Data data = this.data();
        return data.getSizeInBytes();
    }

    public Data getUnits() {
        if (this.units != null) {
            this.units.setCtxTree(this.ctxTree);
        }
        return this.units;
    }

    public Data getHelp() {
        if (this.help != null) {
            this.help.setCtxTree(this.ctxTree);
        }
        return this.help;
    }

    public Data getError() {
        if (this.error != null) {
            this.error.setCtxTree(this.ctxTree);
        }
        return this.error;
    }

    public Data getValidation() {
        if (this.validation != null) {
            this.validation.setCtxTree(this.ctxTree);
        }
        return this.validation;
    }

    public void setUnits(Data units) {
        this.units = units;
    }

    public void setHelp(Data help) {
        this.help = help;
    }

    public void setError(Data error) {
        this.error = error;
    }

    public void setValidation(Data validation) {
        this.validation = validation;
    }

    public Data getDimensionAt(int idx) {
        return this.executeWithContext("DIM_OF($)", this);
    }

    public void plot() {
        Scope scope = new Scope("", 100, 100, 200, 200);
        try {
            scope.plot(this.getDimensionAt(0), this, 1, 1, "black");
        }
        catch (Exception exc) {
            System.err.println("Cannot plot data: " + exc);
        }
    }

    public static Data toData(byte d) {
        return new Int8(d);
    }

    public static Data toData(short d) {
        return new Int16(d);
    }

    public static Data toData(int d) {
        return new Int32(d);
    }

    public static Data toData(long d) {
        return new Int64(d);
    }

    public static Data toData(float d) {
        return new Float32(d);
    }

    public static Data toData(double d) {
        return new Float64(d);
    }

    public static Data toData(java.lang.String d) {
        return new String(d);
    }

    public static Data toData(byte[] d) {
        return new Int8Array(d);
    }

    public static Data toData(short[] d) {
        return new Int16Array(d);
    }

    public static Data toData(int[] d) {
        return new Int32Array(d);
    }

    public static Data toData(long[] d) {
        return new Int64Array(d);
    }

    public static Data toData(float[] d) {
        return new Float32Array(d);
    }

    public static Data toData(double[] d) {
        return new Float64Array(d);
    }

    public static Data toData(java.lang.String[] d) {
        return new StringArray(d);
    }

    static {
        try {
            boolean loaded = false;
            try {
                java.lang.String value = System.getenv("JavaMdsLib");
                if (value == null) {
                    value = System.getProperty("JavaMdsLib");
                }
                if (value != null) {
                    System.load(value);
                    loaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loaded) {
                System.loadLibrary("JavaMds");
            }
        }
        catch (Throwable e) {
            System.out.println("Error loading library javamds: " + e);
            e.printStackTrace();
        }
    }
}

