/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.editor.history;

import java.awt.event.ActionEvent;
import org.mechio.api.animation.editor.actions.EditorAction;
import org.mechio.api.animation.editor.history.HistoryAction;

public class DefaultHistoryAction
implements HistoryAction {
    private EditorAction myUndo;
    private EditorAction myRedo;
    private boolean myActionPerformed;
    private String myName;

    public DefaultHistoryAction(String name, EditorAction redo, EditorAction undo, boolean actionPerformed) {
        this.myUndo = undo;
        this.myUndo.setHistory(null);
        this.myRedo = redo;
        this.myRedo.setHistory(null);
        this.myName = name;
        this.myActionPerformed = actionPerformed;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void toggle(Object invoker) {
        if (this.myActionPerformed) {
            this.undo(invoker);
        } else {
            this.redo(invoker);
        }
    }

    @Override
    public void undo(Object invoker) {
        if (this.myActionPerformed) {
            this.myUndo.actionPerformed(new ActionEvent(invoker, 0, ""));
            this.myActionPerformed = false;
        }
    }

    @Override
    public void redo(Object invoker) {
        if (!this.myActionPerformed) {
            this.myRedo.actionPerformed(new ActionEvent(invoker, 0, ""));
            this.myActionPerformed = true;
        }
    }

    @Override
    public boolean getActionPerformed() {
        return this.myActionPerformed;
    }
}

