/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mechio.api.interpolation.InterpolatorDirectory;
import org.mechio.api.interpolation.bezier.BezierInterpolatorFactory;
import org.mechio.api.interpolation.cspline.CSplineInterpolatorFactory;
import org.mechio.api.interpolation.linear.LinearInterpolatorFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "AnimationControl Activation Begin.");
        InterpolatorDirectory.instance().setContext(context);
        InterpolatorDirectory.registerFactory(context, new CSplineInterpolatorFactory());
        theLogger.log(Level.INFO, "CSplineInterpolatorFactory Service Registered Successfully.");
        InterpolatorDirectory.registerFactory(context, new LinearInterpolatorFactory());
        theLogger.log(Level.INFO, "LinearInterpolatorFactory Service Registered Successfully.");
        InterpolatorDirectory.registerFactory(context, new BezierInterpolatorFactory());
        theLogger.log(Level.INFO, "BezierInterpolatorFactory Service Registered Successfully.");
        theLogger.log(Level.INFO, "AnimationControl Activation Complete.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

