/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.editor;

import java.util.ArrayList;
import java.util.List;
import org.mechio.api.animation.editor.AbstractEditor;
import org.mechio.api.animation.editor.EditState;

public abstract class EditorListener {
    private List<AbstractEditor> myConsumingList;

    protected List<AbstractEditor> getConsumingList() {
        return this.myConsumingList;
    }

    protected void startConsuming(AbstractEditor controller) {
        if (this.myConsumingList == null) {
            this.myConsumingList = new ArrayList<AbstractEditor>();
        }
        if (!this.myConsumingList.contains((Object)controller)) {
            this.myConsumingList.add(controller);
        }
    }

    protected void stopConsuming(AbstractEditor controller) {
        if (this.myConsumingList != null && this.myConsumingList.contains((Object)controller)) {
            this.myConsumingList.remove((Object)controller);
            controller.removeFromConsumerList(this);
            controller.removeFromRecursiveList(this);
        }
    }

    public void cleanConsumer() {
        if (this.myConsumingList == null) {
            return;
        }
        for (AbstractEditor c : this.myConsumingList) {
            c.removeFromConsumerList(this);
            c.removeFromRecursiveList(this);
        }
        this.myConsumingList.clear();
        this.myConsumingList = null;
    }

    public abstract void selectionChanged(Object var1, Object var2, int var3, int var4);

    public abstract void itemAdded(Object var1, Object var2, int var3);

    public abstract void itemRemoved(Object var1, Object var2, int var3);

    public abstract void itemMoved(Object var1, Object var2, int var3, int var4);

    public abstract void stateChanged(Object var1, Object var2, EditState var3, boolean var4);

    public abstract void structureChanged(Object var1, Object var2);
}

