/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.config.VersionProperty;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.library.AnimationLibrary;

public class DefaultAnimationLibrary
implements AnimationLibrary {
    private static final Logger theLogger = Logger.getLogger(DefaultAnimationLibrary.class.getName());
    private Map<VersionProperty, Animation> myAnimationMap;
    private List<VersionProperty> myAnimtionVersions;
    private String myLibraryId;

    public DefaultAnimationLibrary(String libId) {
        if (libId == null) {
            throw new NullPointerException();
        }
        this.myLibraryId = libId;
        this.myAnimationMap = new HashMap<VersionProperty, Animation>();
        this.myAnimtionVersions = new ArrayList<VersionProperty>();
    }

    @Override
    public List<VersionProperty> getAnimationVersions() {
        return this.myAnimtionVersions;
    }

    @Override
    public Animation getAnimation(VersionProperty version) {
        return this.myAnimationMap.get(version);
    }

    @Override
    public void add(Animation animation) {
        VersionProperty version = animation.getVersion();
        if (this.myAnimationMap.containsKey(version)) {
            theLogger.log(Level.WARNING, "Not adding Animation. Animation with given version ({0}) already exists.", version);
            return;
        }
        this.myAnimationMap.put(version, animation);
        this.myAnimtionVersions.add(version);
    }

    @Override
    public void remove(Animation animation) {
        if (!this.myAnimationMap.containsValue(animation)) {
            theLogger.log(Level.WARNING, "Could not find given animation: {0}", animation);
            return;
        }
        for (Map.Entry<VersionProperty, Animation> e : this.myAnimationMap.entrySet()) {
            if (!animation.equals(e.getValue())) continue;
            VersionProperty prop = e.getKey();
            this.myAnimationMap.remove(prop);
            this.myAnimtionVersions.remove(prop);
        }
    }

    @Override
    public String getAnimationLibraryId() {
        return this.myLibraryId;
    }

    @Override
    public void clear() {
        this.myAnimationMap.clear();
        this.myAnimtionVersions.clear();
    }
}

