/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.animation.player.AnimationPlayer;
import org.mechio.api.animation.protocol.AnimationEvent;
import org.mechio.api.animation.protocol.AnimationSignal;
import org.osgi.framework.BundleContext;

public class AnimationPlayerClientLifecycle
extends AbstractLifecycleProvider<AnimationPlayer, RemoteAnimationPlayerClient> {
    private static final String theAnimationSender = "animSender";
    private static final String theSignalReceiver = "signalReceiver";
    private static final String theAnimationEventFactory = "animEventFactory";
    private String myPlayerClientId;
    private String myPlayerHostId;
    private BundleContext myContext;

    public AnimationPlayerClientLifecycle(String animPlayerId, String remotePlayerId, String animSenderId, String signalReceiverId, BundleContext context) {
        super(new DescriptorListBuilder().dependency(theAnimationSender, MessageSender.class).with("messageSenderId", animSenderId).with("messageType", AnimationEvent.class.getName()).dependency(theAnimationEventFactory, AnimationEvent.AnimationEventFactory.class).dependency(theSignalReceiver, MessageAsyncReceiver.class).with("messageReceiverId", signalReceiverId).with("messageType", AnimationSignal.class.getName()).getDescriptors());
        if (animPlayerId == null || remotePlayerId == null) {
            throw new NullPointerException();
        }
        this.myPlayerClientId = animPlayerId;
        this.myPlayerHostId = remotePlayerId;
        this.myContext = context;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("animationPlayerId", animPlayerId);
        this.myServiceClassNames = new String[]{AnimationPlayer.class.getName(), RemoteAnimationPlayerClient.class.getName()};
    }

    protected RemoteAnimationPlayerClient create(Map<String, Object> dependencies) {
        MessageSender sender = (MessageSender)dependencies.get(theAnimationSender);
        MessageAsyncReceiver receiver = (MessageAsyncReceiver)dependencies.get(theSignalReceiver);
        AnimationEvent.AnimationEventFactory factory = (AnimationEvent.AnimationEventFactory)dependencies.get(theAnimationEventFactory);
        RemoteAnimationPlayerClient client = new RemoteAnimationPlayerClient(this.myContext, this.myPlayerClientId, this.myPlayerHostId);
        client.setAnimationEventFactory(factory);
        client.setAnimationEventSender((MessageSender<AnimationEvent>)sender);
        client.setAnimationSignalReceiver((MessageAsyncReceiver<AnimationSignal>)receiver);
        return client;
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theAnimationSender.equals(name)) {
            ((RemoteAnimationPlayerClient)this.myService).setAnimationEventSender((MessageSender<AnimationEvent>)((MessageSender)dependency));
        } else if (theAnimationEventFactory.equals(name)) {
            ((RemoteAnimationPlayerClient)this.myService).setAnimationEventFactory((AnimationEvent.AnimationEventFactory)dependency);
        } else if (theSignalReceiver.equals(name)) {
            ((RemoteAnimationPlayerClient)this.myService).setAnimationSignalReceiver((MessageAsyncReceiver<AnimationSignal>)((MessageAsyncReceiver)dependency));
        }
    }

    public Class<AnimationPlayer> getServiceClass() {
        return AnimationPlayer.class;
    }
}

