/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.xml;

import java.util.Set;
import org.jflux.impl.services.rk.osgi.ClassTracker;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.editor.features.SynchronizedPointGroup;
import org.mechio.api.animation.utils.ChannelsParameterSource;
import org.mechio.api.animation.xml.AnimationFileReader;
import org.mechio.api.animation.xml.AnimationFileWriter;
import org.osgi.framework.ServiceException;

public class AnimationXML {
    public static final String ANIMATION = "Animation";
    public static final String ANIMATION_VERSION_TYPE = "Animation";
    public static final String CHANNELS = "Channels";
    public static final String CHANNEL = "Channel";
    public static final String CHANNEL_ID = "id";
    public static final String CHANNEL_NAME = "name";
    public static final String CHANNELS_PARAMETERS = "ChannelsParameters";
    public static final String CHANNELS_PARAMETER = "ChannelsParameter";
    public static final String DEFAULT_POSITION = "DefaultPosition";
    public static final String NORMALIZABLE_RANGE = "NormalizableRange";
    public static final String CHANNEL_ID_PARAM = "ChannelId";
    public static final String CHANNEL_NAME_PARAM = "ChannelName";
    public static final String RANGE_MIN = "Minimum";
    public static final String RANGE_MAX = "Maximum";
    public static final String GENERIC_PARAMETERS = "GenericParameters";
    public static final String GENERIC_PARAMETER = "GenericParameter";
    public static final String PARAM_NAME = "ParameterName";
    public static final String PARAM_VALUE = "ParameterValue";
    public static final String MOTION_PATHS = "MotionPaths";
    public static final String MOTION_PATH = "MotionPath";
    public static final String MOTION_PATH_NAME = "name";
    public static final String INTERPOLATION_VERSION_TYPE = "Interpolation";
    public static final String CONTROL_POINTS = "ControlPoints";
    public static final String CONTROL_POINT = "ControlPoint";
    public static final String TIME = "Time";
    public static final String POSITION = "Position";
    public static final String ADDONS = "AddOns";
    public static final String ADDON = "AddOn";
    public static final String ADDON_FILE = "AddOnFile";
    public static final String SYNC_POINT_GROUPS = "SyncPointGroups";
    public static final String SYNC_POINT_GROUP = "SyncPointGroup";
    public static final String SYNC_POINT = "SyncPoint";
    public static final String SYNC_POINT_CHANNEL_ID = "ChannelId";
    public static final String SYNC_POINT_MOTION_PATH_ID = "MotionPathId";
    public static final String SYNC_POINT_CONTROL_POINT_ID = "ControlPointId";
    public static final String NAMESPACE = null;
    private static ClassTracker<AnimationFileReader> myReaderTracker;
    private static ClassTracker<AnimationFileWriter> myWriterTracker;

    public static Animation loadAnimation(String path) throws ServiceException, Throwable {
        AnimationFileReader reader = AnimationXML.getRegisteredReader();
        if (reader == null) {
            throw new ServiceException("No AnimationFileReader Service found.");
        }
        return reader.readAnimation(path);
    }

    public static void saveAnimation(String file, Animation a, ChannelsParameterSource source, Set<SynchronizedPointGroup> syncPointGroups) throws ServiceException, Throwable {
        AnimationFileWriter writer = AnimationXML.getRegisteredWriter();
        if (writer == null) {
            throw new ServiceException("No AnimationFileWriter Service found.");
        }
        writer.writeAnimation(file, a, source, syncPointGroups);
    }

    public static AnimationFileReader getRegisteredReader() {
        if (myReaderTracker == null) {
            myReaderTracker = ClassTracker.build(AnimationFileReader.class, (String)"");
        }
        if (myReaderTracker == null) {
            return null;
        }
        return (AnimationFileReader)myReaderTracker.getTopService();
    }

    public static AnimationFileWriter getRegisteredWriter() {
        if (myWriterTracker == null) {
            myWriterTracker = ClassTracker.build(AnimationFileWriter.class, (String)"");
        }
        if (myWriterTracker == null) {
            return null;
        }
        return (AnimationFileWriter)myWriterTracker.getTopService();
    }
}

