/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.interpolation.linear;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.utils.ListUtils;
import org.mechio.api.interpolation.Interpolator;

public class LinearInterpolator
implements Interpolator {
    public static final String VERSION_NAME = "Linear Interpolation";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Linear Interpolation", "1.0");
    private List<Point2D> myControlPoints = new ArrayList<Point2D>();
    private List<Point2D> myInterpolatedPoints;

    @Override
    public Point2D addPoint(double x, double y) {
        this.myInterpolatedPoints = null;
        Point2D.Double p = new Point2D.Double(x, y);
        this.myControlPoints.add(p);
        return p;
    }

    @Override
    public Point2D insertPoint(int i, double x, double y) {
        this.myInterpolatedPoints = null;
        Point2D.Double p = new Point2D.Double(x, y);
        this.myControlPoints.add(i, p);
        return p;
    }

    @Override
    public void addPoints(List<Point2D> points) {
        this.myInterpolatedPoints = null;
        this.myControlPoints.addAll(points);
    }

    @Override
    public void addPoints(int i, List<Point2D> points) {
        this.myInterpolatedPoints = null;
        this.myControlPoints.addAll(i, points);
    }

    @Override
    public Point2D setPoint(int i, double x, double y) {
        this.myInterpolatedPoints = null;
        Point2D p = this.myControlPoints.get(i);
        p.setLocation(x, y);
        return p;
    }

    @Override
    public void removePoint(Point2D p) {
        this.myInterpolatedPoints = null;
        this.myControlPoints.remove(p);
    }

    @Override
    public Point2D removePoint(int i) {
        this.myInterpolatedPoints = null;
        return this.myControlPoints.remove(i);
    }

    @Override
    public List<Point2D> getControlPoints() {
        return this.myControlPoints;
    }

    @Override
    public List<Point2D> getInterpolatedPoints() {
        if (this.myInterpolatedPoints == null) {
            this.myInterpolatedPoints = ListUtils.deepCopy(this.myControlPoints);
        }
        return this.myInterpolatedPoints;
    }

    @Override
    public boolean interpolationChanged() {
        return this.myInterpolatedPoints == null;
    }

    @Override
    public void clear() {
        this.myControlPoints.clear();
    }

    @Override
    public VersionProperty getInterpolatorVersion() {
        return VERSION;
    }

    @Override
    public boolean touchesControlPoints() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinearInterpolator other = (LinearInterpolator)obj;
        return this.myControlPoints == other.myControlPoints || this.myControlPoints != null && this.myControlPoints.equals(other.myControlPoints);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.myControlPoints != null ? this.myControlPoints.hashCode() : 0);
        return hash;
    }
}

