/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.utils.Utils;
import org.mechio.api.interpolation.Interpolator;
import org.mechio.api.interpolation.InterpolatorDirectory;
import org.mechio.api.interpolation.InterpolatorFactory;

public class PathInterpolator
implements Interpolator {
    InterpolatorFactory myFactory;
    private Interpolator myInterpolator;
    protected List<Double> myXVals;
    private List<Point2D> myInterpolatedPoints;

    PathInterpolator() {
    }

    public PathInterpolator(InterpolatorFactory factory) {
        this.myFactory = factory != null ? factory : InterpolatorDirectory.instance().getDefaultFactory();
        this.myInterpolator = (Interpolator)this.myFactory.getValue();
        if (this.myInterpolator instanceof PathInterpolator) {
            throw new IllegalArgumentException("Unable to set interpolator to PathInterpolator");
        }
        this.myXVals = new ArrayList<Double>();
        this.myInterpolatedPoints = new ArrayList<Point2D>();
    }

    public void setInterpolatorFactory(InterpolatorFactory factory) {
        if (factory == null) {
            return;
        }
        this.myFactory = factory;
        Interpolator i = (Interpolator)this.myFactory.getValue();
        i.addPoints(this.myInterpolator.getControlPoints());
        this.myInterpolator = i;
        this.interpolate();
    }

    public InterpolatorFactory getInterpolatorFactory() {
        return this.myFactory;
    }

    @Override
    public Point2D addPoint(double x, double y) {
        y = Math.max(0.0, Math.min(y, 1.0));
        int i = Collections.binarySearch(this.myXVals, x);
        i = i < 0 ? -(i + 1) : i;
        this.myXVals.add(i, x);
        Point2D p = this.myInterpolator.insertPoint(i, x, y);
        return p;
    }

    @Override
    public void addPoints(List<Point2D> points) {
        for (Point2D p : points) {
            this.addPoint(p.getX(), p.getY());
        }
    }

    @Override
    public Point2D setPoint(int i, double x, double y) {
        this.myInterpolator.removePoint(i);
        this.myXVals.remove(i);
        return this.addPoint(x, y);
    }

    @Override
    public void removePoint(Point2D p) {
        this.removePoint(this.myXVals.indexOf(p.getX()));
    }

    @Override
    public Point2D removePoint(int i) {
        this.myXVals.remove(i);
        return this.myInterpolator.removePoint(i);
    }

    @Override
    public List<Point2D> getControlPoints() {
        return this.myInterpolator.getControlPoints();
    }

    @Override
    public List<Point2D> getInterpolatedPoints() {
        this.interpolate();
        return this.myInterpolatedPoints;
    }

    protected boolean interpolate() {
        if (!this.myInterpolator.interpolationChanged()) {
            return false;
        }
        List<Point2D> points = this.myInterpolator.getInterpolatedPoints();
        this.myInterpolatedPoints = new ArrayList<Point2D>();
        if (points.isEmpty()) {
            return true;
        }
        Iterator<Point2D> pIt = points.iterator();
        Point2D prev = pIt.next();
        this.myInterpolatedPoints.add(prev);
        while (pIt.hasNext()) {
            Point2D p = pIt.next();
            if (p.getX() <= prev.getX()) continue;
            this.myInterpolatedPoints.add(new Point2D.Double(p.getX(), Math.max(0.0, Math.min(p.getY(), 1.0))));
            prev = p;
        }
        return true;
    }

    @Override
    public boolean interpolationChanged() {
        return this.myInterpolator.interpolationChanged();
    }

    public boolean overlaps(PathInterpolator b) {
        if (this.myXVals.isEmpty() || b.myXVals.isEmpty()) {
            return false;
        }
        double sA = this.myXVals.get(0);
        double eA = this.myXVals.get(this.myXVals.size() - 1);
        double sB = b.myXVals.get(0);
        double eB = b.myXVals.get(b.myXVals.size() - 1);
        return sA >= sB && sA <= eB || sB >= sA && sB <= eA;
    }

    @Override
    public Point2D insertPoint(int i, double x, double y) {
        return this.addPoint(x, y);
    }

    @Override
    public void addPoints(int i, List<Point2D> points) {
        this.addPoints(points);
    }

    @Override
    public void clear() {
        this.myInterpolator.clear();
        this.myXVals.clear();
        this.myInterpolatedPoints.clear();
    }

    protected void moveControlPoint(int i, double x, double y) {
        if (i < 0 || i >= this.myXVals.size()) {
            return;
        }
        x = Math.max(x, 0.0);
        y = Utils.bound((double)y, (double)0.0, (double)1.0);
        this.myXVals.set(i, x);
        this.myInterpolator.setPoint(i, x, y);
    }

    @Override
    public VersionProperty getInterpolatorVersion() {
        return this.myInterpolator.getInterpolatorVersion();
    }

    @Override
    public boolean touchesControlPoints() {
        return this.myInterpolator.touchesControlPoints();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathInterpolator other = (PathInterpolator)obj;
        if (!(this.myInterpolator == other.myInterpolator || this.myInterpolator != null && this.myInterpolator.equals(other.myInterpolator))) {
            return false;
        }
        return this.myXVals == other.myXVals || this.myXVals != null && this.myXVals.equals(other.myXVals);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.myInterpolator != null ? this.myInterpolator.hashCode() : 0);
        hash = 79 * hash + (this.myXVals != null ? this.myXVals.hashCode() : 0);
        return hash;
    }
}

