/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.playable.Playable;
import org.jflux.api.common.rk.services.addon.ServiceAddOn;
import org.mechio.api.animation.Channel;
import org.mechio.api.animation.MotionPath;
import org.mechio.api.animation.compiled.CompiledMap;
import org.mechio.api.animation.compiled.CompiledPath;
import org.mechio.api.animation.editor.features.SyncPointGroupConfig;

public class Animation {
    private static final Logger theLogger = Logger.getLogger(Animation.class.getName());
    private List<Channel> myChannels = new ArrayList<Channel>();
    private Map<Integer, Channel> myChannelMap = new HashMap<Integer, Channel>();
    private VersionProperty myVersion;
    private Long myStartTime;
    private Long myStopTime;
    private List<ServiceAddOn<Playable>> myAddOns = new ArrayList<ServiceAddOn<Playable>>();
    private List<SyncPointGroupConfig.SyncGroupConfig> mySyncGroupConfigs;

    public Animation() {
        this(new VersionProperty("New Animation", "1.0"));
    }

    public Animation(VersionProperty version) {
        this.myVersion = version;
    }

    public VersionProperty getVersion() {
        return this.myVersion;
    }

    public void setVersion(String name, String versionNumber) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Unable to set empty Version Name.");
        }
        this.myVersion = new VersionProperty(name, versionNumber);
    }

    public void addChannel(Channel channel) throws IllegalArgumentException {
        if (channel == null) {
            throw new NullPointerException("Unable to add null channel.");
        }
        int id = channel.getId();
        if (this.myChannelMap.containsKey(id)) {
            throw new IllegalArgumentException("Unable to add channel.  Channel for servo " + id + " already exists.");
        }
        this.myChannelMap.put(id, channel);
        this.myChannels.add(channel);
    }

    public void addChannels(List<Channel> channels) throws NullPointerException {
        if (channels == null) {
            throw new NullPointerException("Unable to add null channels.");
        }
        for (Channel channel : channels) {
            try {
                this.addChannel(channel);
            }
            catch (IllegalArgumentException ex) {
                theLogger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void setStartTime(Long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("start time must be positive");
        }
        this.myStartTime = time;
        this.setChannelStartTime(time);
    }

    private void setChannelStartTime(Long time) {
        for (Channel c : this.myChannels) {
            c.setStartTime(time);
        }
    }

    public Long getStartTime() {
        return this.myStartTime;
    }

    public void setStopTime(Long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("start time must be positive");
        }
        this.myStopTime = time;
        this.setChannelStopTime(time);
    }

    private void setChannelStopTime(Long time) {
        for (Channel c : this.myChannels) {
            c.setStopTime(time);
        }
    }

    public Long getStopTime() {
        return this.myStopTime;
    }

    public void insertChannel(int i, Channel channel) throws IllegalArgumentException {
        if (channel == null) {
            throw new NullPointerException("Unable to add null channel.");
        }
        int id = channel.getId();
        if (this.myChannelMap.containsKey(id)) {
            throw new IllegalArgumentException("Unable to add channel.  Channel for servo " + id + " already exists.");
        }
        this.myChannelMap.put(id, channel);
        this.myChannels.add(i, channel);
    }

    public boolean containsLogicalId(int id) {
        return this.myChannelMap.containsKey(id);
    }

    public Channel getChannel(int id) {
        return this.myChannels.get(id);
    }

    public Channel getChannelByLogicalId(int id) {
        return this.myChannelMap.get(id);
    }

    public Set<Map.Entry<Integer, Channel>> getEntrySet() {
        return this.myChannelMap.entrySet();
    }

    public List<Channel> getChannels() {
        return this.myChannels;
    }

    public Channel removeChannelByListOrder(int i) {
        if (i < 0 || i > this.myChannels.size()) {
            return null;
        }
        Channel channel = this.myChannels.remove(i);
        int logicalId = channel.getId();
        this.myChannelMap.remove(logicalId);
        return channel;
    }

    public Channel removeChannelByLogicalId(int logicalId) {
        if (!this.myChannelMap.containsKey(logicalId)) {
            return null;
        }
        Channel channel = this.myChannelMap.remove(logicalId);
        this.myChannels.remove(channel);
        return channel;
    }

    public CompiledMap getCompiledMap(long stepLength) {
        long start = this.myStartTime == null ? -1L : this.myStartTime;
        long stop = this.myStopTime == null ? -1L : this.myStopTime;
        return this.compileMap(start, stop, stepLength);
    }

    public CompiledMap compileMap(long start, long end, long stepLength) {
        HashMap<Integer, CompiledPath> paths = new HashMap<Integer, CompiledPath>();
        for (Map.Entry<Integer, Channel> e : this.myChannelMap.entrySet()) {
            CompiledPath cp = e.getValue().compilePath(start, end, stepLength);
            if (cp == null || cp.isEmpty()) continue;
            paths.put(e.getKey(), cp);
        }
        CompiledMap cm = new CompiledMap(stepLength, start, end);
        cm.putAll((Map<? extends Integer, ? extends CompiledPath>)paths);
        return cm;
    }

    public long getLength() {
        double max = 0.0;
        for (Channel c : this.myChannels) {
            for (MotionPath m : c.getMotionPaths()) {
                double end;
                if (m.myXVals.isEmpty() || !((end = ((Double)m.myXVals.get(m.myXVals.size() - 1)).doubleValue()) > max)) continue;
                max = end;
            }
        }
        if (this.myStopTime == null || this.myStopTime < 0L || (double)this.myStopTime.longValue() > max) {
            return (long)max;
        }
        return this.myStopTime;
    }

    public void setSyncGroupConfigs(List<SyncPointGroupConfig.SyncGroupConfig> configs) {
        this.mySyncGroupConfigs = configs;
    }

    public List<SyncPointGroupConfig.SyncGroupConfig> getSyncGroupConfigs() {
        return this.mySyncGroupConfigs;
    }

    public Animation clone() {
        Animation a = new Animation();
        a.setVersion(this.myVersion.getName(), this.myVersion.getNumber());
        for (Channel channel : this.myChannels) {
            a.addChannel(channel.clone());
        }
        for (ServiceAddOn serviceAddOn : this.myAddOns) {
            a.myAddOns.add((ServiceAddOn<Playable>)serviceAddOn);
        }
        if (this.mySyncGroupConfigs != null) {
            a.mySyncGroupConfigs = new ArrayList<SyncPointGroupConfig.SyncGroupConfig>(this.mySyncGroupConfigs);
        }
        return a;
    }

    public void addAddOn(ServiceAddOn<Playable> addOn) {
        if (addOn == null) {
            throw new NullPointerException();
        }
        if (this.myAddOns.contains(addOn)) {
            return;
        }
        this.myAddOns.add(addOn);
    }

    public void removeAddOn(ServiceAddOn<Playable> addOn) {
        this.myAddOns.remove(addOn);
    }

    public List<ServiceAddOn<Playable>> getAddOns() {
        return this.myAddOns;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Animation other = (Animation)obj;
        if (!(this.myChannelMap == other.myChannelMap || this.myChannelMap != null && ((Object)this.myChannelMap).equals(other.myChannelMap))) {
            return false;
        }
        if (!(this.myVersion == other.myVersion || this.myVersion != null && this.myVersion.equals((Object)other.myVersion))) {
            return false;
        }
        if (!(this.myStartTime == other.myStartTime || this.myStartTime != null && this.myStartTime.equals(other.myStartTime))) {
            return false;
        }
        return this.myStopTime == other.myStopTime || this.myStopTime != null && this.myStopTime.equals(other.myStopTime);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.myChannelMap != null ? ((Object)this.myChannelMap).hashCode() : 0);
        hash = 23 * hash + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        hash = 23 * hash + (this.myStartTime != null ? this.myStartTime.hashCode() : 0);
        hash = 23 * hash + (this.myStopTime != null ? this.myStopTime.hashCode() : 0);
        return hash;
    }
}

