/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.localization.Localizer;
import org.jflux.api.common.rk.playable.Playable;
import org.jflux.api.common.rk.services.addon.ServiceAddOn;
import org.jflux.api.common.rk.utils.RKSource;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.Channel;
import org.mechio.api.animation.editor.AbstractEditor;
import org.mechio.api.animation.editor.ChannelEditor;
import org.mechio.api.animation.editor.ControlPointEditor;
import org.mechio.api.animation.editor.EditState;
import org.mechio.api.animation.editor.MotionPathEditor;
import org.mechio.api.animation.editor.features.SyncPointGroupConfig;
import org.mechio.api.animation.editor.features.SynchronizedPointGroup;
import org.mechio.api.animation.editor.history.HistoryStack;

public class AnimationEditor
extends AbstractEditor<Channel, ChannelEditor> {
    public static final String PROP_PATH = "Path";
    private Animation myAnimation;
    private String myPath;

    public AnimationEditor(Animation a, String path, HistoryStack hist) {
        super(hist);
        this.myAnimation = a.clone();
        this.myPath = path;
        this.setChildren(this.myAnimation.getChannels());
        this.setSyncGroups();
    }

    private void setSyncGroups() {
        List<SyncPointGroupConfig.SyncGroupConfig> configs = this.myAnimation.getSyncGroupConfigs();
        if (configs == null || configs.isEmpty()) {
            return;
        }
        for (SyncPointGroupConfig.SyncGroupConfig config : configs) {
            this.setSyncGroup(config);
        }
    }

    private SynchronizedPointGroup setSyncGroup(SyncPointGroupConfig.SyncGroupConfig config) {
        if (config.points == null) {
            return null;
        }
        ArrayList<ControlPointEditor> points = new ArrayList<ControlPointEditor>();
        for (SyncPointGroupConfig.SyncPointConfig pConfig : config.points) {
            ControlPointEditor point = this.getSyncPoint(pConfig);
            if (point == null) continue;
            points.add(point);
        }
        return new SynchronizedPointGroup(points, this.mySharedHistory, null);
    }

    private ControlPointEditor getSyncPoint(SyncPointGroupConfig.SyncPointConfig config) {
        ChannelEditor chan = this.getChildByChannelId(config.channelId);
        if (chan == null) {
            return null;
        }
        MotionPathEditor path = (MotionPathEditor)((Object)chan.getChild(config.motionPathId));
        if (chan == null) {
            return null;
        }
        return (ControlPointEditor)((Object)path.getChild(config.controlPointId));
    }

    private ChannelEditor getChildByChannelId(int id) {
        for (ChannelEditor c : this.getChildren()) {
            if (c.getId() != id) continue;
            return c;
        }
        return null;
    }

    public String getFilePath() {
        return this.myPath;
    }

    public void setFilePath(String path) {
        String oldPath = this.myPath;
        this.myPath = path;
        this.firePropertyChange(PROP_PATH, oldPath, this.myPath);
    }

    @Override
    protected void setSelected(int i, boolean sel, HistoryStack hist) {
        if (i < 0 || i >= this.myChildren.size()) {
            return;
        }
        ChannelEditor child = (ChannelEditor)((Object)this.getChild(i));
        if (child == null) {
            return;
        }
        child.setState((Object)this, EditState.SELECTED, sel, hist);
        if (!sel) {
            return;
        }
        if (child.getSelectedIndex() == -1) {
            if (child.getChildren().isEmpty()) {
                return;
            }
            child.select((Object)this, 0, hist);
        }
    }

    @Override
    public String getName() {
        VersionProperty ver = this.myAnimation.getVersion();
        if (ver != null) {
            return ver.display();
        }
        return Localizer.$((String)"new.animation");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        VersionProperty oldVersion = this.myAnimation.getVersion();
        String versionNumber = this.myAnimation.getVersion().getNumber();
        this.myAnimation.setVersion(name, versionNumber);
        this.firePropertyChange("name", oldVersion.display(), this.myAnimation.getVersion().display());
    }

    public void setVersionNumber(String versionNumber) {
        VersionProperty oldVersion = this.myAnimation.getVersion();
        String name = this.myAnimation.getVersion().getName();
        this.myAnimation.setVersion(name, versionNumber);
        this.firePropertyChange("name", oldVersion.display(), this.myAnimation.getVersion().display());
    }

    public VersionProperty getVersion() {
        return this.myAnimation.getVersion();
    }

    public void setVersion(VersionProperty version) {
        if (version == null) {
            return;
        }
        VersionProperty oldVersion = this.myAnimation.getVersion();
        String name = version.getName();
        String ver = version.getNumber();
        if (name == null || name.isEmpty()) {
            name = this.myAnimation.getVersion().getName();
        }
        this.myAnimation.setVersion(name, ver);
        this.firePropertyChange("name", oldVersion.display(), this.myAnimation.getVersion().display());
    }

    @Override
    protected Channel removeChild(Object invoker, int i) {
        return this.myAnimation.removeChannelByListOrder(i);
    }

    public Animation getAnimation() {
        return this.myAnimation.clone();
    }

    public Animation getEnabledAnimation() {
        Animation anim = new Animation();
        for (ChannelEditor cc : this.myChildren) {
            if (cc.hasFlag(EditState.DISABLED)) continue;
            anim.addChannel(cc.getChannelView());
        }
        Animation a = anim.clone();
        for (ServiceAddOn<Playable> addon : this.myAnimation.getAddOns()) {
            a.addAddOn(addon);
        }
        return a;
    }

    public boolean containsLogicalId(int i) {
        return this.myAnimation.containsLogicalId(i);
    }

    public long getEnd() {
        long end = 0L;
        for (ChannelEditor mpc : this.myChildren) {
            long nEnd = mpc.getEnd();
            if (nEnd <= end) continue;
            end = nEnd;
        }
        return end;
    }

    @Override
    protected ChannelEditor createChildController(Channel channel) {
        return new ChannelEditor(channel, this.mySharedHistory);
    }

    @Override
    public boolean isChildUIController() {
        return true;
    }

    @Override
    protected int addChildBase(Object invoker, RKSource<Channel> channelSource, int i) {
        this.myAnimation.insertChannel(i, (Channel)channelSource.getValue());
        return this.myAnimation.getChannels().indexOf(channelSource.getValue());
    }

    @Override
    protected int insertChildControllerBase(ChannelEditor controller, int i) {
        Channel channel = controller.getChannel();
        this.myAnimation.insertChannel(i, channel);
        return this.myAnimation.getChannels().indexOf(channel);
    }

    public Set<SynchronizedPointGroup> collectSynchronizedPointGroups() {
        HashSet<SynchronizedPointGroup> groups = new HashSet<SynchronizedPointGroup>();
        for (ChannelEditor chan : this.getChildren()) {
            for (MotionPathEditor path : chan.getChildren()) {
                for (ControlPointEditor point : path.getChildren()) {
                    SynchronizedPointGroup g;
                    if (!point.isGrouped() || (g = point.getPointGroup()) == null) continue;
                    groups.add(g);
                }
            }
        }
        return groups;
    }
}

