/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jflux.api.common.rk.playable.AbstractPlayable;
import org.jflux.api.common.rk.playable.PlayState;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.animation.player.AnimationJob;
import org.mechio.api.animation.player.AnimationJobListener;
import org.mechio.api.animation.player.AnimationPlayer;

public class RemoteAnimationJob
extends AbstractPlayable
implements AnimationJob {
    private RemoteAnimationPlayerClient myPlayer;
    private Animation myAnimation;
    private long myMaxRampTimeMillisec;
    private boolean myLoopFlag;
    private long myAnimStartTime;
    private long myEndTime;
    private List<AnimationJobListener> myAnimationListeners;

    RemoteAnimationJob(RemoteAnimationPlayerClient player, Animation anim, Long start, Long stop, int maxRampMillisec) {
        if (anim == null || player == null) {
            throw new NullPointerException();
        }
        this.myPlayer = player;
        this.myLoopFlag = false;
        this.myAnimation = anim;
        this.myMaxRampTimeMillisec = maxRampMillisec;
        this.myAnimStartTime = start == null || start < 0L ? 0L : start;
        this.myEndTime = stop == null || stop < 0L ? anim.getLength() : stop.longValue();
        this.myAnimationListeners = new ArrayList<AnimationJobListener>();
    }

    @Override
    public AnimationPlayer getSource() {
        return this.myPlayer;
    }

    @Override
    public void addAnimationListener(AnimationJobListener listener) {
        if (this.myAnimationListeners == null) {
            this.myAnimationListeners = new ArrayList<AnimationJobListener>();
        }
        if (!this.myAnimationListeners.contains(listener)) {
            this.myAnimationListeners.add(listener);
        }
    }

    @Override
    public void removeAnimationListener(AnimationJobListener listener) {
        if (this.myAnimationListeners == null) {
            return;
        }
        this.myAnimationListeners.remove(listener);
    }

    @Override
    public Animation getAnimation() {
        return this.myAnimation;
    }

    public Long getCurrentTime(long time) {
        Long l = this.getElapsedPlayTime(time);
        if (l == null) {
            return null;
        }
        return l + this.myAnimStartTime;
    }

    @Override
    public Map<Integer, Double> advanceAnimation(long time, long interval) {
        return null;
    }

    public boolean onStart(long time) {
        if (this.myAnimationListeners != null) {
            for (AnimationJobListener listener : this.myAnimationListeners) {
                listener.animationStart(this.myAnimStartTime, this.myEndTime);
            }
        }
        return true;
    }

    @Override
    public Long getAnimationLength() {
        return this.myEndTime - this.myAnimStartTime + this.myMaxRampTimeMillisec;
    }

    @Override
    public Long getRemainingTime(long time) {
        if (this.getPlayState() == PlayState.COMPLETED) {
            return 0L;
        }
        long now = this.getElapsedPlayTime(time);
        long end = this.getAnimationLength();
        return end - now;
    }

    protected boolean onPause(long time) {
        return true;
    }

    protected boolean onResume(long time) {
        return true;
    }

    protected boolean onStop(long time) {
        this.myPlayer.stopAnimation(this.myAnimation);
        return true;
    }

    protected boolean onComplete(long time) {
        return true;
    }

    @Override
    public void setLoop(boolean loop) {
        if (loop) {
            this.myPlayer.loopAnimation(this.myAnimation, false);
        } else if (this.myPlayState == PlayState.RUNNING) {
            this.myPlayer.playAnimation(this.myAnimation, false);
        }
        this.myLoopFlag = loop;
    }

    @Override
    public boolean getLoop() {
        return this.myLoopFlag;
    }
}

