/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.compiled;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompiledPath
extends ArrayList<Double> {
    private Long myStepLength;
    private Long myStartTime;

    public CompiledPath(long start, long stepLength) {
        this.myStartTime = start;
        this.myStepLength = stepLength;
    }

    public Long getEndTime() {
        return this.myStartTime + (long)this.size() * this.myStepLength;
    }

    public Long getStartTime() {
        return this.myStartTime;
    }

    public Long getStepLength() {
        return this.myStepLength;
    }

    public double getStep(long time) {
        int i = (int)Math.floor((double)(time - this.myStartTime) / (double)this.myStepLength.longValue());
        if (i < 0 || i >= this.size()) {
            return -1.0;
        }
        return (Double)this.get(i);
    }

    public double estimatePosition(long time) {
        double t1 = (double)(time - this.myStartTime) / (double)this.myStepLength.longValue();
        int min = (int)Math.floor(t1);
        int max = min + 1;
        int len = this.size();
        if (min < 0) {
            if (max == 0) {
                return (Double)this.get(0);
            }
            return -1.0;
        }
        if (max == len) {
            return (Double)this.get(len - 1);
        }
        if (max == len + 1) {
            return (Double)this.get(len - 1);
        }
        if (max > len) {
            return -1.0;
        }
        double p1 = (Double)this.get(min);
        double p2 = (Double)this.get(max);
        if (p1 < 0.0 || p2 < 0.0) {
            if (p1 > 0.0) {
                return p1;
            }
            if (p2 > 0.0) {
                return p2;
            }
            return -1.0;
        }
        double pX = t1 - (double)min;
        return pX * (p2 - p1) + p1;
    }

    public boolean matches(long start, long end, long step) {
        return start == this.myStartTime && end == this.getEndTime() && step == this.myStepLength;
    }

    @Override
    public CompiledPath clone() {
        CompiledPath cp = new CompiledPath(this.myStartTime, this.myStepLength);
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            cp.add(d);
        }
        return cp;
    }

    public static CompiledPath combine(List<CompiledPath> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        int len = paths.size();
        if (len == 1) {
            return paths.get(0).clone();
        }
        long step = paths.get((int)0).myStepLength;
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        for (CompiledPath p : paths) {
            if (p.myStepLength != step) {
                throw new IllegalArgumentException("Cannot add CompiledPaths with different step lengths.");
            }
            if (p.myStartTime < start) {
                start = p.myStartTime;
            }
            if (p.getEndTime() <= end) continue;
            end = p.getEndTime();
        }
        CompiledPath cp = new CompiledPath(start, step);
        for (long t = start; t <= end; t += step) {
            double d = -1.0;
            for (CompiledPath p : paths) {
                if (d != -1.0) break;
                d = p.getStep(t);
            }
            cp.add(d);
        }
        return cp;
    }

    public CompiledPath setTimes(long start, long end) {
        if (start == this.myStartTime && end == this.getEndTime()) {
            return this;
        }
        if (start > end) {
            return new CompiledPath(start, this.myStepLength);
        }
        ArrayList<Double> vals = new ArrayList<Double>((int)((end - start) / this.myStepLength) + 1);
        for (long t = start; t <= end; t += this.myStepLength.longValue()) {
            double pos = this.getStep(t);
            vals.add(pos);
        }
        CompiledPath p = new CompiledPath(start, this.myStepLength);
        p.addAll(vals);
        return p;
    }

    public static CompiledPath compilePath(long start, long end, List<Point2D> interpolated, long stepLength) {
        Point2D prev;
        if (interpolated == null || interpolated.isEmpty()) {
            return null;
        }
        Iterator<Point2D> it = interpolated.iterator();
        Point2D next = prev = it.next();
        CompiledPath path = new CompiledPath(start, stepLength);
        for (long t = start; t <= end; t += stepLength) {
            if ((double)t < prev.getX()) {
                if ((double)(t + stepLength) > prev.getX()) {
                    path.add(prev.getY());
                    continue;
                }
                path.add(-1.0);
                continue;
            }
            while ((double)t >= next.getX()) {
                if (!it.hasNext()) {
                    path.add(next.getY());
                    t += stepLength;
                    while (t <= end) {
                        path.add(-1.0);
                        t += stepLength;
                    }
                    return path;
                }
                prev = next;
                next = it.next();
            }
            if (next.getY() == -1.0 || prev.getY() == -1.0) {
                if (next.getY() > 0.0) {
                    path.add(next.getY());
                    continue;
                }
                if (prev.getY() > 0.0) {
                    path.add(prev.getY());
                    continue;
                }
                path.add(-1.0);
                continue;
            }
            double pX = ((double)t - prev.getX()) / (next.getX() - prev.getX());
            path.add(pX * (next.getY() - prev.getY()) + prev.getY());
        }
        return path;
    }
}

