/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.messaging;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.playable.Playable;
import org.jflux.api.common.rk.services.addon.ServiceAddOn;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.jflux.api.core.util.DefaultNotifier;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.Channel;
import org.mechio.api.animation.MotionPath;
import org.mechio.api.animation.messaging.RemoteAnimationJob;
import org.mechio.api.animation.player.AnimationJob;
import org.mechio.api.animation.player.AnimationPlayer;
import org.mechio.api.animation.protocol.AnimationEvent;
import org.mechio.api.animation.protocol.AnimationSignal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RemoteAnimationPlayerClient
extends DefaultNotifier<AnimationSignal>
implements AnimationPlayer,
Listener<AnimationSignal> {
    private static final Logger theLogger = Logger.getLogger(RemoteAnimationPlayerClient.class.getName());
    private String myAnimationPlayerId;
    private String myRemotePlayerId;
    private MessageSender<AnimationEvent> myAnimationSender;
    private AnimationEvent.AnimationEventFactory myEventFactory;
    private List<RemoteAnimationJob> myAnimationJobs;
    private MessageAsyncReceiver<AnimationSignal> mySignalReceiver;
    private BundleContext myContext;
    private Map<AnimationJob, ServiceRegistration> myRegistry;

    public RemoteAnimationPlayerClient(BundleContext context, String animPlayerClientId, String animPlayerHostId) {
        if (animPlayerClientId == null || animPlayerHostId == null) {
            throw new NullPointerException();
        }
        this.myAnimationPlayerId = animPlayerClientId;
        this.myRemotePlayerId = animPlayerHostId;
        this.myContext = context;
        this.myRegistry = new HashMap<AnimationJob, ServiceRegistration>();
        this.myAnimationJobs = new ArrayList<RemoteAnimationJob>();
    }

    @Override
    public String getAnimationPlayerId() {
        return this.myAnimationPlayerId;
    }

    public void setAnimationEventFactory(AnimationEvent.AnimationEventFactory factory) {
        this.myEventFactory = factory;
    }

    public void setAnimationEventSender(MessageSender<AnimationEvent> sender) {
        this.myAnimationSender = sender;
    }

    public void setAnimationSignalReceiver(MessageAsyncReceiver<AnimationSignal> receiver) {
        if (this.mySignalReceiver != null) {
            this.mySignalReceiver.removeListener((Listener)this);
        }
        this.mySignalReceiver = receiver;
        if (this.mySignalReceiver != null) {
            this.mySignalReceiver.addListener((Listener)this);
        }
    }

    public AnimationJob playAnimation(Animation animation, boolean register) {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return null;
        }
        String[] names = new String[]{AnimationJob.class.getName()};
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, this.myRemotePlayerId, animation);
        this.myAnimationSender.notifyListeners((Object)event);
        for (ServiceAddOn<Playable> add : animation.getAddOns()) {
            ((Playable)add.getAddOn()).start(TimeUtils.now());
        }
        RemoteAnimationJob job = new RemoteAnimationJob(this, animation, animation.getStartTime(), animation.getStopTime(), 800);
        if (register && this.myContext != null) {
            Properties props = new Properties();
            ServiceRegistration reg = this.myContext.registerService(names, (Object)job, (Dictionary)props);
            this.myRegistry.put(job, reg);
        }
        this.myAnimationJobs.add(job);
        job.start(TimeUtils.now());
        return job;
    }

    @Override
    public AnimationJob playAnimation(Animation animation) {
        return this.playAnimation(animation, true);
    }

    public AnimationJob loopAnimation(Animation animation, boolean register) {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return null;
        }
        String[] names = new String[]{AnimationJob.class.getName()};
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, "LOOP", animation);
        this.myAnimationSender.notifyListeners((Object)event);
        for (ServiceAddOn<Playable> add : animation.getAddOns()) {
            ((Playable)add.getAddOn()).start(TimeUtils.now());
        }
        RemoteAnimationJob job = new RemoteAnimationJob(this, animation, animation.getStartTime(), animation.getStopTime(), 800);
        if (register && this.myContext != null) {
            Properties props = new Properties();
            ServiceRegistration reg = this.myContext.registerService(names, (Object)job, (Dictionary)props);
            this.myRegistry.put(job, reg);
        }
        job.start(TimeUtils.now());
        return job;
    }

    public AnimationJob loopAnimation(Animation animation) {
        return this.loopAnimation(animation, true);
    }

    public void stopAnimation(Animation animation) {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return;
        }
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, "STOP", animation);
        this.myAnimationSender.notifyListeners((Object)event);
        for (ServiceAddOn<Playable> add : animation.getAddOns()) {
            ((Playable)add.getAddOn()).stop(TimeUtils.now());
        }
    }

    public void clearAnimations() {
        if (this.myEventFactory == null || this.myAnimationSender == null) {
            return;
        }
        Animation empty = new Animation(new VersionProperty("empty", "1.0"));
        empty.addChannel(new Channel(0, "emptyChan"));
        MotionPath path = new MotionPath();
        path.addPoint(0.0, 0.5);
        path.addPoint(1.0, 0.5);
        empty.getChannel(0).addPath(path);
        AnimationEvent event = this.myEventFactory.createAnimationEvent(this.myAnimationPlayerId, "CLEAR", empty);
        this.myAnimationSender.notifyListeners((Object)event);
    }

    @Override
    public AnimationJob playAnimation(Animation animation, Long start, Long stop) {
        animation.setStartTime(start);
        animation.setStopTime(stop);
        return this.playAnimation(animation);
    }

    @Override
    public List<AnimationJob> getCurrentAnimations() {
        return this.myAnimationJobs;
    }

    @Override
    public void removeAnimationJob(AnimationJob job) {
        if (!(job instanceof RemoteAnimationJob)) {
            return;
        }
        RemoteAnimationJob rjob = (RemoteAnimationJob)job;
        if (!this.myAnimationJobs.contains(rjob)) {
            return;
        }
        rjob.stop(TimeUtils.now());
        if (this.myContext != null) {
            ServiceRegistration reg = this.myRegistry.remove(job);
            if (reg == null) {
                return;
            }
            try {
                reg.unregister();
            }
            catch (IllegalStateException ex) {
                theLogger.log(Level.WARNING, "Unable to unregister AnimationJob.  Already unregistered.", ex);
            }
        }
        this.myAnimationJobs.remove(rjob);
    }

    @Override
    public void addAnimationSignalListener(Listener<AnimationSignal> listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeAnimationSignalListener(Listener<AnimationSignal> listener) {
        this.myListeners.remove(listener);
    }

    public void handleEvent(AnimationSignal t) {
        boolean hashFound = false;
        RemoteAnimationJob goodJob = null;
        for (RemoteAnimationJob job : this.myAnimationJobs) {
            if (job.getAnimation().hashCode() != t.getAnimationHash().intValue()) continue;
            hashFound = true;
            goodJob = job;
            break;
        }
        if (!hashFound) {
            for (RemoteAnimationJob job : this.myAnimationJobs) {
                if (!job.getAnimation().getVersion().getName().equals(t.getAnimationName()) || !job.getAnimation().getVersion().getNumber().equals(t.getAnimationVersion())) continue;
                goodJob = job;
                break;
            }
        }
        if (goodJob != null) {
            if (t.getEventType().equals("START")) {
                goodJob.start(TimeUtils.now());
            } else if (t.getEventType().equals("PAUSE")) {
                goodJob.pause(TimeUtils.now());
            } else if (t.getEventType().equals("RESUME")) {
                goodJob.resume(TimeUtils.now());
            } else if (t.getEventType().equals("CANCELED")) {
                goodJob.stop(TimeUtils.now());
            } else if (t.getEventType().equals("COMPLETED")) {
                goodJob.complete(TimeUtils.now());
            }
        }
        this.notifyListeners(t);
    }

    public void stopAllAnimations() {
        for (AnimationJob job : this.getCurrentAnimations()) {
            this.stopAnimation(job.getAnimation());
        }
    }
}

