/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.utils;

import java.util.HashMap;
import java.util.Map;
import org.jflux.api.common.rk.position.DoubleRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;

public class ChannelsParameter {
    private int myChannelID;
    private String myChannelName;
    private NormalizedDouble myDefaultPosition;
    private NormalizableRange<Double> myNormalizableRange;
    private Map<String, String> myKeyValuePairs;

    public ChannelsParameter(int channelID, String channelName, NormalizedDouble defaultPosition, NormalizableRange<Double> normalizableRange) {
        if (channelName == null || defaultPosition == null) {
            throw new IllegalArgumentException();
        }
        this.myChannelID = channelID;
        this.myChannelName = channelName;
        this.myDefaultPosition = defaultPosition;
        this.myNormalizableRange = normalizableRange;
        if (this.myNormalizableRange == null) {
            this.myNormalizableRange = new DoubleRange(0.0, 1.0);
        }
        this.myKeyValuePairs = new HashMap<String, String>();
    }

    public ChannelsParameter(int channelID, String channelName, NormalizedDouble defaultPosition) {
        if (channelName == null || defaultPosition == null) {
            throw new IllegalArgumentException();
        }
        this.myChannelID = channelID;
        this.myChannelName = channelName;
        this.myDefaultPosition = defaultPosition;
        this.myNormalizableRange = null;
        this.myKeyValuePairs = new HashMap<String, String>();
    }

    public Object getParameter(String key) {
        return this.myKeyValuePairs.get(key);
    }

    public void setParameter(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        if (this.myKeyValuePairs.containsKey(key)) {
            this.myKeyValuePairs.remove(key);
        }
        this.myKeyValuePairs.put(key, value);
    }

    public void dropParameter(String key) {
        if (key == null || !this.myKeyValuePairs.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        this.myKeyValuePairs.remove(key);
    }

    public int getChannelID() {
        return this.myChannelID;
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myDefaultPosition;
    }

    public NormalizableRange<Double> getNormalizableRange() {
        if (this.myNormalizableRange == null) {
            throw new IllegalArgumentException();
        }
        return this.myNormalizableRange;
    }

    public String getChannelName() {
        return this.myChannelName;
    }

    public Map<String, String> getKeyValuePairs() {
        return this.myKeyValuePairs;
    }
}

