/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.interpolation.bezier;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jflux.api.common.rk.config.VersionProperty;
import org.mechio.api.interpolation.Interpolator;

public class BezierInterpolator
implements Interpolator {
    public static final String VERSION_NAME = "Bezier Interpolation";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("Bezier Interpolation", "1.0");
    private List<Point2D> myControlPoints = new ArrayList<Point2D>();
    private List<Point2D> myInterpolatedPoints;
    private List<Point2D> segmentPoints;
    private List<Point2D> mySortedControlPoints = new ArrayList<Point2D>();
    private int pointamt = 64;

    @Override
    public Point2D addPoint(double x, double y) {
        this.myInterpolatedPoints = null;
        Point2D.Double p = new Point2D.Double(x, y);
        this.myControlPoints.add(p);
        return p;
    }

    @Override
    public Point2D insertPoint(int i, double x, double y) {
        this.myInterpolatedPoints = null;
        Point2D.Double p = new Point2D.Double(x, y);
        this.myControlPoints.add(i, p);
        return p;
    }

    @Override
    public void addPoints(List<Point2D> points) {
        this.myInterpolatedPoints = null;
        this.myControlPoints.addAll(points);
    }

    @Override
    public void addPoints(int i, List<Point2D> points) {
        this.myInterpolatedPoints = null;
        this.myControlPoints.addAll(i, points);
    }

    @Override
    public Point2D setPoint(int i, double x, double y) {
        this.myInterpolatedPoints = null;
        Point2D p = this.myControlPoints.get(i);
        p.setLocation(x, y);
        return p;
    }

    @Override
    public void removePoint(Point2D p) {
        this.myInterpolatedPoints = null;
        this.myControlPoints.remove(p);
    }

    @Override
    public Point2D removePoint(int i) {
        this.myInterpolatedPoints = null;
        return this.myControlPoints.remove(i);
    }

    @Override
    public List<Point2D> getControlPoints() {
        return this.myControlPoints;
    }

    public void updateInterpolation() {
        this.myInterpolatedPoints = new ArrayList<Point2D>();
        int bezierOrder = this.myControlPoints.size() - 1;
        this.myInterpolatedPoints.addAll(this.doSegment(0, 0));
    }

    public List<Point2D> doSegment(int seg, int j) {
        this.segmentPoints = new ArrayList<Point2D>();
        for (int k = 0; k <= this.pointamt; ++k) {
            ArrayList<Point2D> ctrl = new ArrayList<Point2D>();
            ctrl.addAll(this.myControlPoints);
            List<Point2D> arr = this.condensePoints(ctrl, k);
            if (arr.isEmpty()) continue;
            this.segmentPoints.add(arr.get(0));
        }
        return this.segmentPoints;
    }

    public List<Point2D> condensePoints(ArrayList<Point2D> A, int step) {
        int i;
        if (A.size() <= 1) {
            return A;
        }
        int size = A.size();
        for (i = 0; i <= size - 2; ++i) {
            A.add(this.dissect(A.get(i), A.get(i + 1), step));
        }
        for (i = 0; i <= size - 1; ++i) {
            A.remove(0);
        }
        return this.condensePoints(A, step);
    }

    public Point2D getBPoint(int segpos, Point2D a, Point2D b, Point2D c) {
        return this.dissect(this.dissect(a, b, segpos), this.dissect(b, c, segpos), segpos);
    }

    public Point2D dissect(Point2D a, Point2D b, int segpos) {
        double x = a.getX() + (b.getX() - a.getX()) * ((double)segpos / (double)this.pointamt);
        double y = a.getY() + (b.getY() - a.getY()) * ((double)segpos / (double)this.pointamt);
        Point2D.Double q = new Point2D.Double(x, y);
        return q;
    }

    @Override
    public List<Point2D> getInterpolatedPoints() {
        if (this.myInterpolatedPoints != null) {
            return this.myInterpolatedPoints;
        }
        this.updateInterpolation();
        return this.myInterpolatedPoints;
    }

    @Override
    public boolean interpolationChanged() {
        return this.myInterpolatedPoints == null;
    }

    @Override
    public void clear() {
        this.myControlPoints.clear();
    }

    @Override
    public VersionProperty getInterpolatorVersion() {
        return VERSION;
    }

    @Override
    public boolean touchesControlPoints() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BezierInterpolator other = (BezierInterpolator)obj;
        return this.myControlPoints == other.myControlPoints || this.myControlPoints != null && ((Object)this.myControlPoints).equals(other.myControlPoints);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.myControlPoints != null ? ((Object)this.myControlPoints).hashCode() : 0);
        return hash;
    }
}

