/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.animation.editor.history;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.jflux.api.common.rk.localization.Localizer;
import org.mechio.api.animation.editor.actions.EditorAction;
import org.mechio.api.animation.editor.history.DefaultHistoryAction;
import org.mechio.api.animation.editor.history.HistoryAction;
import org.mechio.api.animation.editor.history.HistoryListener;

public class HistoryStack {
    private List<HistoryListener> myListeners;
    private List<HistoryAction> myEvents = new ArrayList<HistoryAction>();
    private int myTime;

    public HistoryStack() {
        this.myEvents.add(new DefaultHistoryAction(Localizer.$((String)"history.start"), new EmptyAction(), new EmptyAction(), true));
        this.myTime = 0;
        this.myListeners = new ArrayList<HistoryListener>();
    }

    public void addListener(HistoryListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeListener(HistoryListener listener) {
        this.myListeners.remove(listener);
    }

    public List<HistoryAction> getHistory() {
        return this.myEvents;
    }

    public void addEvent(HistoryAction e) {
        int prevSize = this.myEvents.size();
        if (this.myTime == prevSize - 1) {
            this.myEvents.add(e);
        } else {
            this.myEvents.subList(this.myTime + 1, prevSize).clear();
            this.myEvents.add(e);
        }
        ++this.myTime;
        for (HistoryListener listener : this.myListeners) {
            listener.eventAdded(this, e, prevSize);
        }
    }

    public HistoryAction getEvent(int i) {
        return this.myEvents.get(i);
    }

    public synchronized void gotoTime(int t) {
        if (t < 0 || t >= this.myEvents.size() || t == this.myTime) {
            return;
        }
        if (t > this.myTime) {
            this.fastforward(t);
        } else {
            this.rewind(t);
        }
    }

    public void gotoEnd() {
        this.gotoTime(this.myEvents.size() - 1);
    }

    public synchronized void move(int t) {
        if (t == 0) {
            return;
        }
        if (t > 0) {
            this.forward(t);
        } else {
            this.back(-t);
        }
    }

    public synchronized void forward(int t) {
        this.fastforward(this.myTime + t);
    }

    public synchronized void back(int t) {
        this.rewind(this.myTime - t);
    }

    public int getSelectedIndex() {
        return this.myTime;
    }

    public int getCurrentUndoCount() {
        return this.myTime;
    }

    public int getCurrentRedoCount() {
        return this.myEvents.size() - this.myTime - 1;
    }

    private void fastforward(int t) {
        for (int i = this.myTime + 1; i <= t && i < this.size(); ++i) {
            this.myEvents.get(i).redo(this);
        }
        this.myTime = Math.min(t, this.size() - 1);
        this.changeTime();
    }

    private void rewind(int t) {
        for (int i = this.myTime; i > t && i >= 0; --i) {
            this.myEvents.get(i).undo(this);
        }
        this.myTime = Math.max(t, 0);
        this.changeTime();
    }

    private void changeTime() {
        for (HistoryListener listener : this.myListeners) {
            listener.timeSelected(this, this.myTime);
        }
    }

    public int size() {
        return this.myEvents.size();
    }

    public synchronized void clear() {
        int prevSize = this.myEvents.size();
        this.myEvents.clear();
        DefaultHistoryAction e = new DefaultHistoryAction(Localizer.$((String)"history.start"), new EmptyAction(), new EmptyAction(), true);
        this.myEvents.add(e);
        this.myTime = 0;
        this.myListeners = new ArrayList<HistoryListener>();
        for (HistoryListener listener : this.myListeners) {
            listener.eventAdded(this, e, prevSize);
        }
    }

    public class EmptyAction
    extends EditorAction {
        public EmptyAction() {
            super(null, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

