/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.audio;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import org.jflux.api.common.rk.playable.Playable;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.common.rk.utils.Utils;

class AudioPlayLoop
implements Runnable {
    private static final int theDelaySleepLength = 20;
    private byte[] myAudio;
    private long myStartDelayMillisec;
    private long myStartDelayBytes;
    private int myStartIndex;
    private int myPlayIndex;
    private int myStopIndex;
    private int myBufferSize;
    private AudioFormat myFormat;
    private SourceDataLine myOutputLine;
    private boolean myRunningFlag;
    private boolean myStopFlag;
    private Playable myParent;
    private long myStartTime;
    private long myStopTime;
    private long myElapsedPlayTime;
    private long myLoopDelayTime;

    public AudioPlayLoop(AudioFormat format, byte[] audio, int start, int end, long startDelay, int bufferSize, Playable parent) {
        if (audio == null) {
            throw new NullPointerException();
        }
        this.myAudio = audio;
        this.myStopIndex = end <= -1 ? this.myAudio.length : end;
        this.myStopIndex = Math.min(this.myStopIndex, this.myAudio.length);
        this.myPlayIndex = this.myStartIndex = Utils.bound((int)start, (int)0, (int)this.myStopIndex);
        this.myRunningFlag = false;
        this.myBufferSize = bufferSize;
        this.myStopFlag = false;
        this.myParent = parent;
        this.myFormat = format;
        this.setStartDelayMillisec(startDelay);
    }

    public void initialize(SourceDataLine outputLine) {
        if (outputLine == null) {
            throw new NullPointerException();
        }
        this.myOutputLine = outputLine;
    }

    public void setStartDelayMillisec(long msec) {
        if (this.isRunning()) {
            return;
        }
        this.myStartDelayMillisec = msec;
        int frameSize = this.myFormat.getFrameSize();
        double frameRate = this.myFormat.getFrameRate();
        double delaySecs = (double)msec / 1000.0;
        double frames = delaySecs * frameRate;
        this.myStartDelayBytes = (long)(frames * (double)frameSize);
    }

    public long getStartDelayMillisec() {
        return this.myStartDelayMillisec;
    }

    public long getStartDelayBytes() {
        return this.myStartDelayBytes;
    }

    public int getBytePosition() {
        int delayBytes = (int)this.myStartDelayBytes;
        long time = this.myElapsedPlayTime + this.myLoopDelayTime;
        if (time < this.myStartDelayMillisec) {
            double frameRate = this.myFormat.getFrameRate();
            double frameSize = this.myFormat.getFrameSize();
            double playSec = (double)time / 1000.0;
            delayBytes = (int)(playSec * frameRate * frameSize);
        }
        int playBytes = this.myPlayIndex - this.myStartIndex;
        return playBytes + delayBytes;
    }

    public void setStartIndex(int start) {
        if (this.isRunning()) {
            return;
        }
        this.myStartIndex = start;
    }

    public int getStartIndex() {
        return this.myStartIndex;
    }

    public void setStopIndex(int stop) {
        if (this.isRunning()) {
            return;
        }
        this.myStopIndex = stop;
    }

    public int getStopIndex() {
        return this.myStopIndex;
    }

    public void setBytePosition(long position) {
        int playPos = (int)(position - this.myStartDelayBytes);
        int frameSize = this.myFormat.getFrameSize();
        double frameRate = this.myFormat.getFrameRate();
        double frames = position / (long)frameSize;
        double sec = frames / frameRate;
        long msec = (long)(sec * 1000.0);
        this.myPlayIndex = playPos >= 0 ? Utils.bound((int)(playPos + this.myStartIndex), (int)this.myStartIndex, (int)this.myStopIndex) : this.myStartIndex;
        this.myElapsedPlayTime = msec;
    }

    public void reset() {
        this.myPlayIndex = this.myStartIndex;
        this.myElapsedPlayTime = 0L;
        this.myStartTime = 0L;
        this.myStopTime = 0L;
    }

    public boolean isRunning() {
        return this.myRunningFlag;
    }

    @Override
    public void run() {
        this.myStopFlag = false;
        if (!this.myRunningFlag) {
            this.start();
        }
    }

    public void stop() {
        if (!this.myRunningFlag || this.myStopFlag) {
            return;
        }
        this.myStopFlag = true;
        this.myStopTime = TimeUtils.now();
        long elapsed = this.myStopTime - this.myStartTime;
        this.myElapsedPlayTime += elapsed;
    }

    public void start() {
        if (this.myOutputLine == null) {
            throw new NullPointerException();
        }
        this.myStopFlag = false;
        this.myRunningFlag = true;
        if (!this.myOutputLine.isRunning()) {
            this.myOutputLine.start();
        }
        this.myStartTime = TimeUtils.now();
        boolean finishedDelay = this.myElapsedPlayTime >= this.myStartDelayMillisec;
        this.myLoopDelayTime = 0L;
        while (this.myPlayIndex != this.myStopIndex && !this.myStopFlag) {
            if (!finishedDelay) {
                this.myLoopDelayTime = TimeUtils.now() - this.myStartTime;
                long elapsed = this.myLoopDelayTime + this.myElapsedPlayTime;
                long delayRemaining = this.myStartDelayMillisec - elapsed;
                finishedDelay = this.delay(delayRemaining);
                continue;
            }
            this.myLoopDelayTime = 0L;
            int play = this.myPlayIndex;
            int remaining = this.myStopIndex - play;
            int len = Math.min(remaining, this.myBufferSize);
            if (len <= 0) {
                return;
            }
            byte[] audio = Arrays.copyOfRange(this.myAudio, play, play + len);
            int bytesRead = audio.length;
            if (bytesRead == 0) {
                return;
            }
            this.myOutputLine.write(audio, 0, bytesRead);
            if (play != this.myPlayIndex) continue;
            this.myPlayIndex += bytesRead;
        }
        this.myLoopDelayTime = 0L;
        this.myRunningFlag = false;
        if (this.myPlayIndex == this.myStopIndex) {
            this.myStopTime = TimeUtils.now();
            this.myParent.complete(TimeUtils.now());
        }
    }

    private boolean delay(long remaining) {
        if (remaining <= 0L) {
            System.out.println("Delay Finished: " + remaining);
            return true;
        }
        if (remaining > 20L) {
            TimeUtils.sleep((long)20L);
            return false;
        }
        long rh = remaining / 2L;
        TimeUtils.sleep((long)rh);
        return false;
    }

    public void close() {
        if (this.myOutputLine != null) {
            this.myOutputLine.drain();
            this.myOutputLine.close();
        }
    }
}

