/*
 * Copyright 2014 the MechIO Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mechio.api.audio.config;

import java.io.File;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.services.ServiceFactory;
import org.mechio.api.audio.WavBuffer;
import org.mechio.api.audio.WavBufferPlayer;
import org.mechio.api.audio.WavPlayer;

/**
 *
 * @author Matthew Stevenson <www.mechio.org>
 */
public class WavPlayerServiceFactory implements ServiceFactory<WavPlayer, WavPlayerConfig> {

    @Override
    public VersionProperty getServiceVersion() {
        return WavBufferPlayer.VERSION;
    }

    @Override
    public WavPlayer build(WavPlayerConfig config) throws Exception {
        if(config == null){
            throw new NullPointerException();
        }
        File wavFile = new File(config.getWavLocation());
        WavBuffer buffer = new WavBuffer(wavFile);
        WavPlayer player = new WavBufferPlayer(config.getWavPlayerId(), buffer);
        player.initAudioLine();
        return player;
    }

    @Override
    public Class<WavPlayer> getServiceClass() {
        return WavPlayer.class;
    }

    @Override
    public Class<WavPlayerConfig> getConfigurationClass() {
        return WavPlayerConfig.class;
    }
    
}
