/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.audio.processing;

import org.mechio.api.audio.processing.AudioConverter;

public class VisualizationConverter
implements AudioConverter {
    private int myChannelCount;
    private int mySampleBytes;
    private int myFrameBytes;
    private boolean myIsSigned;
    private int myRange;
    private int myMax;
    private boolean myIsBigEndian;

    public VisualizationConverter(int channelCount, int sampleByte, boolean signed, boolean bigEndian) {
        if (sampleByte > 3) {
            throw new IllegalArgumentException("Cannot convert greater than 24-bit samples.");
        }
        this.myChannelCount = channelCount;
        this.mySampleBytes = sampleByte;
        this.myIsSigned = signed;
        this.myRange = 1 << sampleByte * 8;
        this.myMax = 1 << sampleByte * 8 - 1;
        this.myFrameBytes = this.myChannelCount * this.mySampleBytes;
        this.myIsBigEndian = bigEndian;
    }

    @Override
    public double[][] convert(byte[] data) {
        return this.convert(data, 0, data.length);
    }

    @Override
    public double[][] convert(byte[] data, int offset, int len) {
        if (len % this.myFrameBytes != 0) {
            throw new IllegalArgumentException("Bad conversion length.  Len " + len + " is not a multiple of the frame size " + this.myFrameBytes);
        }
        int frames = len / this.myFrameBytes;
        double[][] samples = new double[this.myChannelCount][frames];
        int i = 0;
        while (i < frames) {
            Double[] frame = this.getFrame(data, offset);
            for (int j = 0; j < this.myChannelCount; ++j) {
                samples[j][i] = frame[j];
            }
            ++i;
            offset += this.myFrameBytes;
        }
        return samples;
    }

    private Double[] getFrame(byte[] data, int offset) {
        Double[] frame = new Double[this.myChannelCount];
        for (int i = 0; i < this.myChannelCount; ++i) {
            frame[i] = this.getSample(data, offset + i * this.mySampleBytes, this.myIsBigEndian);
        }
        return frame;
    }

    private double getSample(byte[] data, int offset, boolean bigEndian) {
        int sample;
        int n = sample = bigEndian ? this.getBESample(data, offset) : this.getLESample(data, offset);
        if (!this.myIsSigned) {
            if (sample < 0) {
                sample += this.myRange;
            }
            sample -= this.myMax;
        }
        if (sample > 0) {
            return (double)sample / (double)(this.myMax - 1);
        }
        return (double)sample / (double)this.myMax;
    }

    private int getBESample(byte[] data, int offset) {
        int sample = data[offset];
        for (int i = 1; i < this.mySampleBytes; ++i) {
            sample = (sample << 8) + (data[offset + i] & 0xFF);
        }
        return sample;
    }

    private int getLESample(byte[] data, int offset) {
        int sample = data[offset + this.mySampleBytes - 1];
        for (int i = this.mySampleBytes - 2; i >= 0; --i) {
            sample = (sample << 8) + (data[offset + i] & 0xFF);
        }
        return sample;
    }
}

