/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.audio;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.playable.AbstractPlayable;
import org.mechio.api.audio.AudioPlayLoop;
import org.mechio.api.audio.AudioProgressListener;
import org.mechio.api.audio.WavBuffer;
import org.mechio.api.audio.WavPlayer;
import org.mechio.api.audio.WavProgressMonitor;

public class WavBufferPlayer
extends AbstractPlayable
implements WavPlayer {
    private static final Logger theLogger = Logger.getLogger(WavBufferPlayer.class.getName());
    private static final int theDefaultBufferSize = 512;
    public static final String VERSION_NAME = "WavBufferPlayer";
    public static final String VERSION_NUMBER = "1.0";
    public static final VersionProperty VERSION = new VersionProperty("WavBufferPlayer", "1.0");
    private String myPlayerId;
    private SourceDataLine myOutputLine;
    private AudioPlayLoop myPlayLoop;
    private WavBuffer myWavBuffer;
    private int myStartByte;
    private int myStopByte;
    private long myStartDelayMillisec;
    private List<LineListener> myListeners;
    private WavProgressMonitor myMonitor;

    public WavBufferPlayer(String playerId, WavBuffer wav) {
        this.init(playerId, wav, 0L, 0L, 0L);
    }

    public WavBufferPlayer(String playerId, WavBuffer wav, long startMicrosec, long stopMicrosec, long startDelayMillisec) {
        this.init(playerId, wav, startMicrosec, stopMicrosec, startDelayMillisec);
    }

    private void init(String playerId, WavBuffer wav, long startMicrosec, long stopMicrosec, long startDelayMillisec) {
        if (playerId == null || wav == null) {
            throw new NullPointerException();
        }
        this.myPlayerId = playerId;
        this.myWavBuffer = wav;
        this.myStartByte = (int)this.microsecToByte(startMicrosec);
        this.myStopByte = stopMicrosec <= startMicrosec ? this.myWavBuffer.getAudioBytes().length : (int)this.microsecToByte(stopMicrosec);
        this.myStartDelayMillisec = startDelayMillisec;
        this.myListeners = new ArrayList<LineListener>();
        AudioFormat format = this.myWavBuffer.getFormat();
        int bytesPerSample = format.getSampleSizeInBits() / 8;
        int sampleSize = bytesPerSample * format.getChannels();
        int bufferSize = 512 * sampleSize;
        this.myPlayLoop = new AudioPlayLoop(this.myWavBuffer.getFormat(), this.myWavBuffer.getAudioBytes(), this.myStartByte, this.myStopByte, this.myStartDelayMillisec, bufferSize, this);
    }

    @Override
    public void initAudioLine() throws Exception {
        if (this.myOutputLine != null) {
            return;
        }
        AudioFormat format = this.myWavBuffer.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        this.myOutputLine = (SourceDataLine)AudioSystem.getLine(info);
        this.myOutputLine.open(format);
        this.myPlayLoop.initialize(this.myOutputLine);
        this.myMonitor = new WavProgressMonitor(this, 100);
    }

    @Override
    public WavBuffer getWavBuffer() {
        return this.myWavBuffer;
    }

    @Override
    public String getWavPlayerId() {
        return this.myPlayerId;
    }

    private long microsecToByte(double usec) {
        long framePos = this.microsecToFrame(usec);
        return this.frameToByte(framePos);
    }

    private long microsecToFrame(double usec) {
        AudioFormat format = this.myWavBuffer.getFormat();
        double frameRate = format.getFrameRate();
        double sec = usec / 1000000.0;
        long framePos = (long)(sec * frameRate);
        return framePos;
    }

    private double byteToMicrosec(long bytePos) {
        long framePos = this.byteToFrame(bytePos);
        return this.frameToMicrosec(framePos);
    }

    private long byteToFrame(long bytePos) {
        AudioFormat format = this.myWavBuffer.getFormat();
        long frameSize = format.getFrameSize();
        return bytePos / frameSize;
    }

    private long frameToByte(long framePos) {
        AudioFormat format = this.myWavBuffer.getFormat();
        long frameSize = format.getFrameSize();
        return framePos * frameSize;
    }

    private double frameToMicrosec(long framePos) {
        AudioFormat format = this.myWavBuffer.getFormat();
        double frameRate = format.getFrameRate();
        double sec = (double)framePos / frameRate;
        return sec * 1000000.0;
    }

    public String getPlayerId() {
        return this.myPlayerId;
    }

    @Override
    public void setStartDelayMillisec(long startDelayMillisec) {
        if (this.myPlayLoop == null) {
            return;
        }
        this.myPlayLoop.setStartDelayMillisec(startDelayMillisec);
    }

    @Override
    public void setStartDelayFrames(long startDelayFrames) {
        if (this.myPlayLoop == null) {
            return;
        }
        double usec = this.frameToMicrosec(startDelayFrames);
        long msec = (long)(usec / 1000.0);
        this.myPlayLoop.setStartDelayMillisec(msec);
    }

    @Override
    public long getStartDelayFrames() {
        if (this.myPlayLoop == null) {
            return 0L;
        }
        return this.byteToFrame(this.myPlayLoop.getStartDelayBytes());
    }

    @Override
    public long getStartDelayMillisec() {
        if (this.myPlayLoop == null) {
            return 0L;
        }
        return this.myPlayLoop.getStartDelayMillisec();
    }

    @Override
    public void setPositionFrame(long frame) {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return;
        }
        long bytes = this.frameToByte(frame);
        this.myPlayLoop.setBytePosition(bytes);
    }

    @Override
    public void setPositionMicrosec(double usec) {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return;
        }
        long frame = this.microsecToFrame(usec);
        this.setPositionFrame(frame);
    }

    @Override
    public long getPositionFrame() {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return 0L;
        }
        return this.byteToFrame(this.myPlayLoop.getBytePosition());
    }

    @Override
    public double getPositionMicrosec() {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return 0.0;
        }
        long framePos = this.getPositionFrame();
        double usec = this.frameToMicrosec(framePos);
        return usec;
    }

    private boolean isOpen() {
        if (this.myOutputLine == null) {
            return false;
        }
        return this.myOutputLine.isOpen();
    }

    public Long getElapsedPlayTime(long time) {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return 0L;
        }
        return (long)(this.getPositionMicrosec() / 1000.0);
    }

    protected boolean onStart(long time) {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return false;
        }
        if (this.myPlayLoop.isRunning()) {
            return false;
        }
        new Thread(this.myPlayLoop).start();
        this.myMonitor.start();
        this.myMonitor.timerTick(0L, 0L);
        return true;
    }

    protected boolean onPause(long time) {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return false;
        }
        if (!this.myPlayLoop.isRunning()) {
            return false;
        }
        this.myPlayLoop.stop();
        return true;
    }

    protected boolean onResume(long time) {
        return this.onStart(time);
    }

    protected boolean onStop(long time) {
        if (this.myPlayLoop != null) {
            this.myPlayLoop.reset();
        }
        this.killTheLine();
        return this.onPause(time);
    }

    protected boolean onComplete(long time) {
        if (!this.isOpen() || this.myPlayLoop == null) {
            return false;
        }
        if (this.myPlayLoop.isRunning()) {
            this.myPlayLoop.stop();
        }
        this.myPlayLoop.reset();
        this.killTheLine();
        return true;
    }

    @Override
    public void addLineListener(LineListener listener) {
        if (this.myOutputLine == null) {
            return;
        }
        this.myOutputLine.addLineListener(listener);
        this.myListeners.add(listener);
    }

    @Override
    public void removeLineListener(LineListener listener) {
        if (this.myOutputLine == null) {
            return;
        }
        this.myOutputLine.removeLineListener(listener);
        this.myListeners.remove(listener);
    }

    @Override
    public void addAudioProgressListener(AudioProgressListener listener) {
        if (this.myMonitor == null) {
            return;
        }
        this.myMonitor.addAudioProgressListener(listener);
    }

    @Override
    public void removeAudioProgressListener(AudioProgressListener listener) {
        if (this.myMonitor == null) {
            return;
        }
        this.myMonitor.removeAudioProgressListener(listener);
    }

    @Override
    public void setStartPositionFrame(long frame) {
        int bytes = (int)this.frameToByte(frame);
        this.myPlayLoop.setStartIndex(bytes);
    }

    @Override
    public void setStartPositionMicrosec(double usec) {
        long frame = this.microsecToFrame(usec);
        this.setStartPositionFrame(frame);
    }

    @Override
    public long getStartPositionFrame() {
        return this.byteToFrame(this.myPlayLoop.getStartIndex());
    }

    @Override
    public double getStartPositionMicrosec() {
        return this.frameToMicrosec(this.getStartPositionFrame());
    }

    @Override
    public void setEndPositionFrame(long frame) {
        int bytePos = (int)this.frameToByte(frame);
        this.myPlayLoop.setStopIndex(bytePos);
    }

    @Override
    public void setEndPositionMicrosec(double usec) {
        long frame = this.microsecToFrame(usec);
        this.setEndPositionFrame(frame);
    }

    @Override
    public long getEndPositionFrame() {
        return this.byteToFrame(this.myPlayLoop.getStopIndex());
    }

    @Override
    public double getEndPositionMicrosec() {
        return this.frameToMicrosec(this.getEndPositionFrame());
    }

    @Override
    public long getLengthFrames() {
        long bytes = this.myStopByte - this.myStartByte;
        long frames = this.byteToFrame(bytes);
        long delay = this.byteToFrame(this.myPlayLoop.getStartDelayBytes());
        return delay + frames;
    }

    @Override
    public double getLengthMicrosec() {
        return this.frameToMicrosec(this.getLengthFrames());
    }

    private void killTheLine() {
        if (this.myOutputLine != null && this.myOutputLine.isOpen()) {
            if (this.myOutputLine.isActive()) {
                this.myOutputLine.stop();
            }
            this.myOutputLine.flush();
            this.myOutputLine.close();
        }
    }
}

