/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.audio;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.jflux.api.common.rk.utils.TimerLoop;
import org.mechio.api.audio.AudioProgressListener;
import org.mechio.api.audio.WavPlayer;

public class WavProgressMonitor
extends TimerLoop {
    private WavPlayer myWavPlayer;
    private List<AudioProgressListener> myListeners;
    private WavMonitorLineListener myLineListener;

    public WavProgressMonitor(WavPlayer wavPlayer, int intervalMillisec) {
        super((long)intervalMillisec);
        if (wavPlayer == null) {
            throw new NullPointerException();
        }
        this.myWavPlayer = wavPlayer;
        this.myListeners = new ArrayList<AudioProgressListener>(3);
        this.myLineListener = new WavMonitorLineListener();
        this.myWavPlayer.addLineListener(this.myLineListener);
    }

    protected void timerTick(long time, long interval) {
        long frame = this.myWavPlayer.getPositionFrame();
        double usec = this.myWavPlayer.getPositionMicrosec();
        for (AudioProgressListener listener : this.myListeners) {
            listener.update(frame, usec);
        }
    }

    public void addAudioProgressListener(AudioProgressListener listener) {
        if (listener == null || this.myListeners.contains(listener)) {
            return;
        }
        this.myListeners.add(listener);
    }

    public void removeAudioProgressListener(AudioProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.myListeners.remove(listener);
    }

    private class WavMonitorLineListener
    implements LineListener {
        private WavMonitorLineListener() {
        }

        @Override
        public void update(LineEvent event) {
            if (event == null) {
                return;
            }
            LineEvent.Type t = event.getType();
            if (LineEvent.Type.START == t) {
                WavProgressMonitor.this.start();
                WavProgressMonitor.this.timerTick(0L, 0L);
            } else if (LineEvent.Type.STOP == t) {
                WavProgressMonitor.this.stop();
                WavProgressMonitor.this.timerTick(0L, 0L);
            }
        }
    }
}

