/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.audio.processing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import org.mechio.api.audio.processing.SampleProcessor;
import org.mechio.api.audio.processing.WavProcessor;

public class AmplitudeImage {
    private int myImageColumnIndex;
    private int myStepSize;
    private int myStepCount;
    private int myBuffSize;
    private int myChannelCount;
    private BufferedImage[] myChannelImages;
    private WavProcessor myWavProc;
    private AmplitudeProcessor myProc;
    private int myImageHeight;

    public AmplitudeImage(WavProcessor wavProc, int stepSize, int stepCount, int imgHeight, double normalizeFactor) {
        this.myWavProc = wavProc;
        this.myStepSize = stepSize;
        this.myStepCount = stepCount;
        AudioFormat format = this.myWavProc.getFormat();
        if (format == null) {
            throw new NullPointerException();
        }
        this.myChannelCount = format.getChannels();
        this.myBuffSize = this.myStepSize * this.myStepCount;
        this.myWavProc.setSamplesBufferSize(this.myBuffSize);
        this.myImageColumnIndex = 0;
        this.myImageHeight = imgHeight;
        this.myChannelImages = new BufferedImage[this.myChannelCount];
        this.myProc = new AmplitudeProcessor();
        this.initImage();
    }

    private void initImage() {
        long frame = this.myWavProc.getFrameCount();
        int width = (int)(frame / (long)this.myBuffSize) + 1;
        int height = this.myImageHeight;
        for (int c = 0; c < this.myChannelCount; ++c) {
            this.myChannelImages[c] = new BufferedImage(width, height, 1);
        }
    }

    public void generateImages() {
        this.myWavProc.process(this.myProc);
    }

    private void addData(int c, double min, double max, double avgMin, double avgMax) {
        Graphics2D g = this.myChannelImages[c].createGraphics();
        this.line(g, this.myImageHeight, this.myImageColumnIndex, max, min, Color.RED);
        this.line(g, this.myImageHeight, this.myImageColumnIndex, avgMax, avgMin, Color.BLUE);
    }

    private void line(Graphics g, int h, int x, double y1, double y2, Color col) {
        double ma = (y1 + 1.0) / 2.0 * (double)h;
        double mi = (y2 + 1.0) / 2.0 * (double)h;
        g.setColor(col);
        g.drawLine(x, (int)ma, x, (int)mi);
    }

    public Image getImage(int c) {
        return this.myChannelImages[c];
    }

    public void addProcessorListener(SampleProcessor.ProcessorListener listener) {
        this.myProc.addProcessorListener(listener);
    }

    public void removeProcessorListener(SampleProcessor.ProcessorListener listener) {
        this.myProc.removeProcessorListener(listener);
    }

    private class AmplitudeProcessor
    implements SampleProcessor {
        private List<SampleProcessor.ProcessorListener> myListeners = new ArrayList<SampleProcessor.ProcessorListener>(3);

        @Override
        public void processSamples(double[][] samples, int frame, int total) {
            for (int c = 0; c < AmplitudeImage.this.myChannelCount; ++c) {
                this.handleChannel(c, samples[c]);
            }
            AmplitudeImage.this.myImageColumnIndex++;
            this.fireProcessorUpdate(frame, total);
        }

        private void handleChannel(int c, double[] samples) {
            double[] totals = new double[2];
            Double max = Double.NEGATIVE_INFINITY;
            Double min = Double.POSITIVE_INFINITY;
            for (int i = 0; i < AmplitudeImage.this.myStepCount; ++i) {
                int offset = i * AmplitudeImage.this.myStepSize;
                double[] vals = this.handleStep(samples, offset);
                if (vals[0] < min) {
                    min = vals[0];
                }
                if (vals[1] > max) {
                    max = vals[1];
                }
                totals[0] = totals[0] + vals[0];
                totals[1] = totals[1] + vals[1];
            }
            totals[0] = totals[0] / (double)AmplitudeImage.this.myStepCount;
            totals[1] = totals[1] / (double)AmplitudeImage.this.myStepCount;
            AmplitudeImage.this.addData(c, min, max, totals[0], totals[1]);
        }

        private double[] handleStep(double[] samples, int offset) {
            int len = samples.length - offset;
            if (len < 0) {
                return new double[]{0.0, 0.0};
            }
            len = Math.min(len, AmplitudeImage.this.myStepSize);
            Double max = Double.NEGATIVE_INFINITY;
            Double min = Double.POSITIVE_INFINITY;
            for (int i = 0; i < len; ++i) {
                double s = samples[i + offset];
                if (s > max) {
                    max = s;
                }
                if (!(s < min)) continue;
                min = s;
            }
            return new double[]{min, max};
        }

        @Override
        public void addProcessorListener(SampleProcessor.ProcessorListener listener) {
            if (listener == null || this.myListeners.contains(listener)) {
                return;
            }
            this.myListeners.add(listener);
        }

        @Override
        public void removeProcessorListener(SampleProcessor.ProcessorListener listener) {
            this.myListeners.remove(listener);
        }

        protected void fireProcessorUpdate(int count, int total) {
            for (SampleProcessor.ProcessorListener pl : this.myListeners) {
                pl.framesProcessed(count, total);
            }
        }
    }
}

