/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.JointProperty;

public abstract class AbstractJoint
extends PropertyChangeNotifier
implements Joint,
PropertyChangeListener {
    private static final Logger theLogger = Logger.getLogger(AbstractJoint.class.getName());
    private Joint.Id myJointId;
    protected Map<String, JointProperty> myProperties;

    public AbstractJoint(Joint.Id id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.myJointId = id;
        this.myProperties = new HashMap<String, JointProperty>();
    }

    @Override
    public Joint.Id getId() {
        return this.myJointId;
    }

    protected void addProperty(JointProperty prop) {
        String name;
        if (this.myProperties == null) {
            this.myProperties = new HashMap<String, JointProperty>();
        }
        if (this.myProperties.containsKey(name = prop.getPropertyName())) {
            return;
        }
        prop.addPropertyChangeListener(this);
        this.myProperties.put(name, prop);
    }

    protected void removeProperty(JointProperty prop) {
        if (this.myProperties == null || prop == null || prop.getPropertyName() == null) {
            return;
        }
        this.myProperties.remove(prop.getPropertyName());
    }

    @Override
    public <T> JointProperty<T> getProperty(String name, Class<T> propertyType) {
        if (this.myProperties == null) {
            return null;
        }
        JointProperty prop = this.myProperties.get(name);
        if (prop == null) {
            return null;
        }
        Class c = prop.getPropertyClass();
        if (!propertyType.isAssignableFrom(c)) {
            theLogger.log(Level.WARNING, "Found Joint property ({0}) with bad type ({1}).  Expected type ({2}).", new Object[]{name, c, propertyType});
            return null;
        }
        return prop;
    }

    @Override
    public JointProperty getProperty(String name) {
        return this.getProperty(name, Object.class);
    }

    @Override
    public Collection<JointProperty> getProperties() {
        if (this.myProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return this.myProperties.values();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.firePropertyChange(pce);
    }
}

