/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.jointgroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.jointgroup.JointGroup;

public abstract class AbstractJointGroup<Id, G extends JointGroup, J extends Joint>
extends PropertyChangeNotifier
implements JointGroup<Id, G, J> {
    private static final Logger theLogger = Logger.getLogger(AbstractJointGroup.class.getName());
    protected String myName;
    protected List<Id> myJointIds;
    protected List<G> myGroups;
    private boolean myEnabledFlag;

    public AbstractJointGroup() {
        this.myJointIds = new ArrayList<Id>();
        this.myGroups = new ArrayList<G>();
        this.myEnabledFlag = true;
    }

    public AbstractJointGroup(String name, List<Id> ids, List<G> groups) {
        this.myName = name;
        this.myJointIds = ids == null ? new ArrayList<Id>() : new ArrayList<Id>(ids);
        this.myGroups = groups == null ? new ArrayList<G>() : new ArrayList<G>(groups);
        this.myEnabledFlag = true;
    }

    protected abstract J getJointById(Id var1);

    @Override
    public void setName(String name) {
        String oldName = this.myName;
        this.myName = name;
        this.firePropertyChange("name", oldName, this.myName);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean old = this.myEnabledFlag;
        this.myEnabledFlag = enabled;
        for (Joint joint : this.getJoints()) {
            if (joint == null) continue;
            joint.setEnabled(enabled);
        }
        for (JointGroup group : this.myGroups) {
            group.setEnabled(enabled);
        }
        this.firePropertyChange("enabled", old, this.myEnabledFlag);
    }

    @Override
    public J getJoint(int index) {
        if (index < 0 || index >= this.myJointIds.size()) {
            return null;
        }
        Id jointId = this.myJointIds.get(index);
        return this.getJointById(jointId);
    }

    @Override
    public List<J> getJoints() {
        ArrayList<J> joints = new ArrayList<J>();
        for (Id id : this.myJointIds) {
            J joint = this.getJointById(id);
            joints.add(joint);
        }
        return joints;
    }

    @Override
    public boolean getEnabled() {
        return this.myEnabledFlag;
    }

    @Override
    public void addJointId(Id jointId) {
        if (this.myJointIds.contains(jointId)) {
            theLogger.log(Level.WARNING, "Unable to add Joint Id.  Id ''{0}'' already exists.", jointId);
            return;
        }
        this.myJointIds.add(jointId);
        this.firePropertyChange("addJointId", null, jointId);
    }

    @Override
    public void insertJointId(Id jointId, int index) {
        if (this.myJointIds.contains(jointId)) {
            theLogger.log(Level.WARNING, "Unable to add Joint Id.  Id ''{0}'' already exists.", jointId);
            return;
        }
        if (index < 0 || index > this.myJointIds.size()) {
            throw new IllegalArgumentException("Unable to add JointId.  Index '" + index + "'out of range.");
        }
        this.myJointIds.add(index, jointId);
        this.firePropertyChange("addJointId", null, jointId);
    }

    @Override
    public void removeJointId(Id jointId) {
        if (!this.myJointIds.contains(jointId)) {
            theLogger.log(Level.WARNING, "Unable to remove Joint Id.  Id ''{0}'' not found.", jointId);
            return;
        }
        this.myJointIds.remove(jointId);
        this.firePropertyChange("removeJointId", null, jointId);
    }

    @Override
    public void removeJointIdAt(int index) {
        Id jointId = this.myJointIds.remove(index);
        this.firePropertyChange("removeJointId", null, jointId);
    }

    @Override
    public List<Id> getJointIds() {
        return Collections.unmodifiableList(this.myJointIds);
    }

    @Override
    public Id getJointId(int index) {
        return this.myJointIds.get(index);
    }

    @Override
    public int getJointCount() {
        return this.myJointIds.size();
    }

    @Override
    public void addGroup(G group) {
        if (this == group) {
            theLogger.log(Level.WARNING, "Unable to add JointGroup.  JointGroup cannot contain itself.");
            return;
        }
        if (this.myGroups.contains(group)) {
            theLogger.log(Level.WARNING, "Unable to add JointGroup.  JointGroup already exists.");
            return;
        }
        this.myGroups.add(group);
        this.firePropertyChange("addJointGroup", null, group);
    }

    @Override
    public void insertGroup(G group, int index) {
        if (this == group) {
            theLogger.log(Level.WARNING, "Unable to add JointGroup.  JointGroup cannot contain itself.");
            return;
        }
        if (this.myGroups.contains(group)) {
            theLogger.log(Level.WARNING, "Unable to add JointGroup.  JointGroup already exists.");
            return;
        }
        if (index < 0 || index > this.myGroups.size()) {
            throw new IllegalArgumentException("Unable to add JointGroup.  Index '" + index + "'out of range.");
        }
        this.myGroups.add(index, group);
        this.firePropertyChange("addJointGroup", null, group);
    }

    @Override
    public void removeGroup(G group) {
        if (!this.myGroups.contains(group)) {
            theLogger.log(Level.WARNING, "Unable to remove JointGroup.  Cannot find JointGroup.");
            return;
        }
        this.myGroups.remove(group);
        this.firePropertyChange("removeJointGroup", null, group);
    }

    @Override
    public void removeGroupAt(int index) {
        JointGroup group = (JointGroup)this.myGroups.remove(index);
        this.firePropertyChange("removeJointGroup", null, group);
    }

    @Override
    public List<G> getJointGroups() {
        return Collections.unmodifiableList(this.myGroups);
    }

    @Override
    public G getJointGroup(int index) {
        return (G)((JointGroup)this.myGroups.get(index));
    }

    @Override
    public int getGroupCount() {
        return this.myGroups.size();
    }

    public String toString() {
        String format = "{\"name\":\"%s\", \"jointIds\":[%s], \"groups\":[%s]}";
        String ids = "";
        Iterator<Id> idIt = this.myJointIds.iterator();
        while (idIt.hasNext()) {
            if (!ids.isEmpty()) {
                ids = ids + ",";
            }
            ids = ids + idIt.next().toString();
        }
        String groups = "";
        Iterator<G> groupIt = this.myGroups.iterator();
        while (groupIt.hasNext()) {
            if (!groups.isEmpty()) {
                groups = groups + ",";
            }
            groups = groups + ((JointGroup)groupIt.next()).toString();
        }
        return String.format(format, this.myName, ids, groups);
    }
}

