/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.core.Listener;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.blending.FrameSource;
import org.mechio.api.motion.messaging.RobotMoveHandler;
import org.mechio.api.motion.protocol.MotionFrameEvent;

public class RobotMoveHandlerLifecycle
extends AbstractLifecycleProvider<Listener, RobotMoveHandler> {
    private static final String theRobot = "robot";

    public RobotMoveHandlerLifecycle(String moveHandlerId, Robot.Id robotId) {
        super(new DescriptorListBuilder().dependency(theRobot, Robot.class).with("robotId", robotId.getRobtIdString()).getDescriptors());
        if (moveHandlerId == null) {
            throw new NullPointerException();
        }
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
        this.myRegistrationProperties.put("listenerId", moveHandlerId);
        this.myRegistrationProperties.put("listenerType", MotionFrameEvent.class.getName());
        this.myRegistrationProperties.put("positionMapType", Robot.RobotPositionMap.class.getName());
        this.myServiceClassNames = new String[]{Listener.class.getName(), FrameSource.class.getName()};
    }

    protected RobotMoveHandler create(Map<String, Object> dependencies) {
        Robot robot = (Robot)dependencies.get(theRobot);
        return new RobotMoveHandler(robot);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theRobot.equals(name)) {
            ((RobotMoveHandler)this.myService).setRobot((Robot)dependency);
        }
    }

    public Class<Listener> getServiceClass() {
        return Listener.class;
    }
}

