/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.messaging.RobotResponseFactory;
import org.mechio.api.motion.protocol.MotionFrameEvent;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;
import org.mechio.api.motion.protocol.RobotRequest;
import org.mechio.api.motion.protocol.RobotResponse;

public class RemoteRobotHost {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotHost.class.getName());
    private Robot myRobot;
    private String mySourceId;
    private String myDestinationId;
    private MessageSender<RobotResponse> myResponseSender;
    private MessageAsyncReceiver<RobotRequest> myRequestReceiver;
    private RequestListener myRequestListener;
    private RobotResponseFactory myResponseFactory;
    private MessageAsyncReceiver<MotionFrameEvent> myMotionFrameReceiver;
    private Listener<MotionFrameEvent> myMoveHandler;
    private Thread myDefinitionThread;
    private boolean myPusherActive;
    private MessageSender<RobotDefinitionResponse> myDefSender;

    public RemoteRobotHost(Robot robot, String sourceId, String destinationId, MessageSender<RobotResponse> sender, MessageAsyncReceiver<RobotRequest> receiver, RobotResponseFactory factory, MessageAsyncReceiver<MotionFrameEvent> motionFrameReceiver, Listener<MotionFrameEvent> moveHandler, MessageSender<RobotDefinitionResponse> defSender) {
        this(sourceId, destinationId);
        this.initialize(robot, sender, receiver, factory, motionFrameReceiver, moveHandler, defSender);
    }

    protected RemoteRobotHost(String sourceId, String destinationId) {
        if (sourceId == null || destinationId == null) {
            throw new NullPointerException();
        }
        this.mySourceId = sourceId;
        this.myDestinationId = destinationId;
        this.myRequestListener = new RequestListener();
        theLogger.log(Level.INFO, "Creating Remote Robot.  sourceId={0}, destId={1}", new Object[]{this.mySourceId, this.myDestinationId});
    }

    private void initialize(Robot robot, MessageSender<RobotResponse> sender, MessageAsyncReceiver<RobotRequest> receiver, RobotResponseFactory factory, MessageAsyncReceiver<MotionFrameEvent> motionFrameReceiver, Listener<MotionFrameEvent> moveHandler, MessageSender<RobotDefinitionResponse> defSender) {
        if (this.myRequestReceiver != null && this.myRequestListener != null) {
            this.myRequestReceiver.removeListener((Listener)this.myRequestListener);
        }
        if (this.myMotionFrameReceiver != null && this.myMoveHandler != null) {
            this.myMotionFrameReceiver.removeListener(this.myMoveHandler);
        }
        this.myRobot = robot;
        this.myResponseSender = sender;
        this.myRequestReceiver = receiver;
        this.myResponseFactory = factory;
        this.myMotionFrameReceiver = motionFrameReceiver;
        this.myMoveHandler = moveHandler;
        this.myPusherActive = false;
        this.myDefSender = defSender;
        if (this.myRequestReceiver != null) {
            this.myRequestReceiver.addListener((Listener)this.myRequestListener);
        }
        if (this.myMotionFrameReceiver != null) {
            this.myMotionFrameReceiver.addListener(this.myMoveHandler);
        }
        theLogger.log(Level.INFO, "Initializing Remote Robot.  sourceId={0}, destId={1}, robotId={2}", new Object[]{this.mySourceId, this.myDestinationId, this.myRobot.getRobotId()});
    }

    public void setRobot(Robot robot) {
        this.myRobot = robot;
    }

    public void setResponseSender(MessageSender<RobotResponse> sender) {
        this.myResponseSender = sender;
    }

    public MessageSender<RobotResponse> getResponseSender() {
        return this.myResponseSender;
    }

    public void setDefSender(MessageSender<RobotDefinitionResponse> sender) {
        this.myDefSender = sender;
    }

    public MessageSender<RobotDefinitionResponse> getDefSender() {
        return this.myDefSender;
    }

    public void setRequestReceiver(MessageAsyncReceiver<RobotRequest> receiver) {
        if (this.myRequestReceiver != null && this.myRequestListener != null) {
            this.myRequestReceiver.removeListener((Listener)this.myRequestListener);
        }
        this.myRequestReceiver = receiver;
        if (this.myRequestReceiver != null && this.myRequestListener != null) {
            this.myRequestReceiver.addListener((Listener)this.myRequestListener);
        }
    }

    public void setResponseFactory(RobotResponseFactory factory) {
        this.myResponseFactory = factory;
    }

    public void setMotionFrameReceiver(MessageAsyncReceiver<MotionFrameEvent> receiver) {
        if (this.myMotionFrameReceiver != null && this.myMoveHandler != null) {
            this.myMotionFrameReceiver.removeListener(this.myMoveHandler);
        }
        this.myMotionFrameReceiver = receiver;
        if (this.myMotionFrameReceiver != null && this.myMoveHandler != null) {
            this.myMotionFrameReceiver.addListener(this.myMoveHandler);
        }
    }

    public void setMoveHandler(Listener<MotionFrameEvent> moveHandler) {
        if (this.myMotionFrameReceiver != null && this.myMoveHandler != null) {
            this.myMotionFrameReceiver.removeListener(this.myMoveHandler);
        }
        this.myMoveHandler = moveHandler;
        if (this.myMotionFrameReceiver != null && this.myMoveHandler != null) {
            this.myMotionFrameReceiver.addListener(this.myMoveHandler);
        }
    }

    public Robot.Id getRobotId() {
        if (this.myRobot == null) {
            return null;
        }
        return this.myRobot.getRobotId();
    }

    public String getSourceId() {
        return this.mySourceId;
    }

    public String getDestinationId() {
        return this.myDestinationId;
    }

    public Robot getRobot() {
        return this.myRobot;
    }

    public void shutDown() {
        this.myPusherActive = false;
    }

    protected void handleDefinitionRequest(RobotRequest req) {
        this.sendDefinitionResponse(req);
        if (this.myDefinitionThread == null || !this.myPusherActive) {
            this.myPusherActive = true;
            this.myDefinitionThread = new Thread(new DefinitionPusher());
            this.myDefinitionThread.start();
        }
    }

    protected void handleConnectRequest(RobotRequest req) {
        if (this.myDefinitionThread == null || !this.myPusherActive) {
            this.myPusherActive = true;
            this.myDefinitionThread = new Thread(new DefinitionPusher());
            this.myDefinitionThread.start();
        }
        this.sendStatusResponse(req, this.getRobot().connect());
    }

    protected void handleDisconnectRequest(RobotRequest req) {
        this.getRobot().disconnect();
        if (this.myDefinitionThread != null && this.myPusherActive) {
            this.shutDown();
        }
        this.sendStatusResponse(req, true);
    }

    protected void handleConnectionStatusRequest(RobotRequest req) {
        this.sendStatusResponse(req, this.getRobot().isConnected());
    }

    protected void handleEnableRequest(RobotRequest req) {
        this.getRobot().setEnabled(true);
        this.sendStatusResponse(req, true);
    }

    protected void handleDisableRequest(RobotRequest req) {
        this.getRobot().setEnabled(false);
        this.sendStatusResponse(req, true);
    }

    protected void handleEnabledStatusRequest(RobotRequest req) {
        this.sendStatusResponse(req, this.getRobot().isEnabled());
    }

    protected void handleEnableRequestForJoint(RobotRequest req) {
        this.getRequestedJoint(req).setEnabled(true);
        this.sendStatusResponse(req, true);
    }

    protected void handleDisableRequestForJoint(RobotRequest req) {
        this.getRequestedJoint(req).setEnabled(false);
        this.sendStatusResponse(req, true);
    }

    protected void handleEnabledStatusRequestForJoint(RobotRequest req) {
        this.sendStatusResponse(req, this.getRequestedJoint(req).getEnabled());
    }

    protected Joint getRequestedJoint(RobotRequest req) {
        Integer jIdInt = req.getRequestIndex();
        if (jIdInt == null) {
            throw new NullPointerException();
        }
        Joint.Id jId = new Joint.Id(jIdInt);
        Robot.Id rId = req.getRobotId();
        Robot.JointId jointId = new Robot.JointId(rId, jId);
        Object j = this.getRobot().getJoint(jointId);
        if (j == null) {
            throw new NullPointerException();
        }
        return j;
    }

    protected void handleDefaultPositionRequest(RobotRequest req) {
        this.sendPositionResponse(req, this.getRobot().getDefaultPositions());
    }

    protected void handleGoalPositionRequest(RobotRequest req) {
        this.sendPositionResponse(req, this.getRobot().getGoalPositions());
    }

    protected void handleCurrentPositionRequest(RobotRequest req) {
        this.sendPositionResponse(req, this.getRobot().getCurrentPositions());
    }

    private void sendDefinitionResponse(RobotRequest req) {
        theLogger.log(Level.INFO, "Sending Definition Response.  Request Timestamp: {0}, Type: {1}, Source: {2}, Dest: {3}, Robot: {4}.", new Object[]{req.getTimestampMillisecUTC(), req.getRequestType(), req.getSourceId(), req.getDestinationId(), req.getRobotId()});
        if (this.myResponseSender == null) {
            theLogger.log(Level.INFO, "Unable to send Definition Response, missing ResponseSender.  Request Timestamp: {0}, Type: {1}, Source: {2}, Dest: {3}, Robot: {4}.", new Object[]{req.getTimestampMillisecUTC(), req.getRequestType(), req.getSourceId(), req.getDestinationId(), req.getRobotId()});
            return;
        }
        RobotResponse.RobotResponseHeader header = this.getHeader(req);
        Robot robot = this.getRobot();
        theLogger.log(Level.INFO, "Creating Definition Response.  Request Timestamp: {0}, Type: {1}, Source: {2}, Dest: {3}, Robot: {4}.  Using Header: {5}, Robot: {6}", new Object[]{req.getTimestampMillisecUTC(), req.getRequestType(), req.getSourceId(), req.getDestinationId(), req.getRobotId(), header, robot});
        RobotDefinitionResponse def = this.myResponseFactory.createDefinitionResponse(header, robot);
        this.myResponseSender.notifyListeners((Object)def);
        theLogger.log(Level.INFO, "Definition Response Sent.  Request Timestamp: {0}, Type: {1}, Source: {2}, Dest: {3}, Robot: {4}.", new Object[]{req.getTimestampMillisecUTC(), req.getRequestType(), req.getSourceId(), req.getDestinationId(), req.getRobotId()});
    }

    private void sendStatusResponse(RobotRequest req, boolean value) {
        if (this.myResponseSender == null) {
            return;
        }
        this.myResponseSender.notifyListeners((Object)this.myResponseFactory.createStatusResponse(this.getHeader(req), value));
    }

    private void sendPositionResponse(RobotRequest req, Robot.RobotPositionMap positions) {
        if (this.myResponseSender == null) {
            return;
        }
        this.myResponseSender.notifyListeners((Object)this.myResponseFactory.createPositionResponse(this.getHeader(req), positions));
    }

    private RobotResponse.RobotResponseHeader getHeader(RobotRequest req) {
        return this.myResponseFactory.createHeader(this.getRobotId(), this.mySourceId, this.myDestinationId, req.getRequestType(), req.getTimestampMillisecUTC());
    }

    private RobotResponse.RobotResponseHeader getHeader() {
        return this.myResponseFactory.createHeader(this.getRobotId(), this.mySourceId, this.myDestinationId, "getRobotDefinition", TimeUtils.now());
    }

    class DefinitionPusher
    implements Runnable {
        DefinitionPusher() {
        }

        @Override
        public void run() {
            while (RemoteRobotHost.this.myPusherActive) {
                theLogger.log(Level.INFO, "Sending Definition Response.");
                if (RemoteRobotHost.this.myDefSender == null) {
                    theLogger.log(Level.INFO, "Unable to send Definition Response, missing DefSender.");
                    return;
                }
                RobotResponse.RobotResponseHeader header = RemoteRobotHost.this.getHeader();
                Robot robot = RemoteRobotHost.this.getRobot();
                theLogger.log(Level.INFO, "Creating Definition Response.");
                RobotDefinitionResponse def = RemoteRobotHost.this.myResponseFactory.createDefinitionResponse(header, robot);
                RemoteRobotHost.this.myDefSender.notifyListeners((Object)def);
                theLogger.log(Level.INFO, "Definition Response Sent.");
                TimeUtils.sleep((long)100L);
            }
        }
    }

    class RequestListener
    implements Listener<RobotRequest> {
        RequestListener() {
        }

        public void handleEvent(RobotRequest event) {
            String reqType = event.getRequestType();
            if (reqType == null) {
                theLogger.info("Received RobotRequest with null RequestType.");
            } else {
                theLogger.log(Level.INFO, "Received RobotRequest with RequestType: {0}.", reqType);
            }
            if (reqType.equals("getRobotDefinition")) {
                RemoteRobotHost.this.handleDefinitionRequest(event);
            } else if (reqType.equals("connectRobot")) {
                RemoteRobotHost.this.handleConnectRequest(event);
            } else if (reqType.equals("disconnectRobot")) {
                RemoteRobotHost.this.handleDisconnectRequest(event);
            } else if (reqType.equals("getConnectionStatus")) {
                RemoteRobotHost.this.handleConnectionStatusRequest(event);
            } else if (reqType.equals("enableRobot")) {
                RemoteRobotHost.this.handleEnableRequest(event);
            } else if (reqType.equals("disableRobot")) {
                RemoteRobotHost.this.handleDisableRequest(event);
            } else if (reqType.equals("getEnabledStatus")) {
                RemoteRobotHost.this.handleEnabledStatusRequest(event);
            } else if (reqType.equals("getDefaultPositions")) {
                RemoteRobotHost.this.handleDefaultPositionRequest(event);
            } else if (reqType.equals("getGoalPositions")) {
                RemoteRobotHost.this.handleGoalPositionRequest(event);
            } else if (reqType.equals("getGoalPositions")) {
                RemoteRobotHost.this.handleGoalPositionRequest(event);
            } else if (reqType.equals("enableJoint")) {
                RemoteRobotHost.this.handleEnableRequestForJoint(event);
            } else if (reqType.equals("disableJoint")) {
                RemoteRobotHost.this.handleDisableRequestForJoint(event);
            } else if (reqType.equals("getJointEnabledStatus")) {
                RemoteRobotHost.this.handleEnabledStatusRequestForJoint(event);
            } else {
                theLogger.log(Level.WARNING, "Received unknown request type: {0}", reqType);
            }
        }
    }
}

