/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.servos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.servos.Servo;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.config.ServoConfig;
import org.mechio.api.motion.servos.config.ServoControllerConfig;

public abstract class AbstractServo<Id, Conf extends ServoConfig<Id>, Ctrl extends ServoController<Id, Conf, ? extends AbstractServo<Id, Conf, Ctrl>, ? extends ServoControllerConfig<Id, Conf>>>
extends PropertyChangeNotifier
implements Servo<Id, Conf>,
PropertyChangeListener {
    private static final Logger theLogger = Logger.getLogger(AbstractServo.class.getName());
    protected Id myServoId;
    protected Conf myConfig;
    protected Ctrl myController;
    protected NormalizedDouble myGoalPosition;
    private NormalizableRange<Double> myRange;

    public AbstractServo(Conf config, Ctrl controller) {
        if (config == null) {
            throw new NullPointerException("Cannot create AbstractServo with null ServoConfig.");
        }
        this.myConfig = config;
        this.myServoId = this.myConfig.getServoId();
        if (this.myServoId == null) {
            throw new NullPointerException();
        }
        this.myController = controller;
        this.myRange = new ServoRange();
    }

    @Override
    public Id getId() {
        return this.myServoId;
    }

    public Ctrl getController() {
        return this.myController;
    }

    @Override
    public Conf getConfig() {
        return this.myConfig;
    }

    @Override
    public NormalizedDouble getGoalPosition() {
        return this.myGoalPosition;
    }

    public Integer getAbsoluteGoalPosition() {
        if (this.myGoalPosition == null) {
            return null;
        }
        double goal = this.myGoalPosition.getValue();
        double range = this.myConfig.getMaxPosition() - this.myConfig.getMinPosition();
        return (int)(goal * range + (double)this.myConfig.getMinPosition());
    }

    @Override
    public void setGoalPosition(NormalizedDouble pos) {
        NormalizedDouble oldPos = this.myGoalPosition;
        this.myGoalPosition = pos;
        this.firePropertyChange("goalPosition", oldPos, pos);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.firePropertyChange(pce);
    }

    @Override
    public NormalizableRange<Double> getPositionRange() {
        return this.myRange;
    }

    private class ServoRange
    implements NormalizableRange<Double> {
        private ServoRange() {
        }

        public boolean isValid(Double t) {
            int min = AbstractServo.this.getMinPosition();
            int max = AbstractServo.this.getMaxPosition();
            return max >= min ? t >= (double)min && t <= (double)max : t <= (double)min && t >= (double)max;
        }

        public NormalizedDouble normalizeValue(Double val) {
            if (!this.isValid(val)) {
                return null;
            }
            int min = AbstractServo.this.getMinPosition();
            double norm = (val - (double)min) / (double)(AbstractServo.this.getMaxPosition() - min);
            return new NormalizedDouble(norm);
        }

        public Double denormalizeValue(NormalizedDouble v) {
            int min = AbstractServo.this.getMinPosition();
            return v.getValue() * (double)(AbstractServo.this.getMaxPosition() - min) + (double)min;
        }

        public Double getMin() {
            return AbstractServo.this.getMinPosition();
        }

        public Double getMax() {
            return AbstractServo.this.getMaxPosition();
        }
    }
}

