/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.servos.utils;

import org.jflux.api.common.rk.position.DoubleRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.joint_properties.ReadCurrentPosition;
import org.mechio.api.motion.servos.Servo;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.ServoJoint;
import org.mechio.api.motion.servos.config.ServoConfig;

public class EmptyServoJoint
extends ServoJoint {
    public EmptyServoJoint(Joint.Id jointId, String name, NormalizedDouble defPos, int min, int max) {
        super(jointId, new EmptyServo(jointId, name, defPos, min, max), null);
        this.addProperty(new ReadCurrentPosition(){

            @Override
            public NormalizedDouble getValue() {
                return EmptyServoJoint.this.getGoalPosition();
            }

            @Override
            public NormalizableRange<NormalizedDouble> getNormalizableRange() {
                return NormalizableRange.NORMALIZED_RANGE;
            }
        });
    }

    public EmptyServoJoint(Joint.Id jointId, String name, NormalizedDouble defPos) {
        this(jointId, name, defPos, 0, 1023);
    }

    static class EmptyServo
    extends PropertyChangeNotifier
    implements Servo {
        private Object myId;
        private String myName;
        private NormalizedDouble myDefaultPosition;
        private NormalizedDouble myGoalPosition;
        private boolean myEnabledFlag;
        private int myMin;
        private int myMax;

        private EmptyServo(Object id, String name, NormalizedDouble defPos, int min, int max) {
            if (id == null || name == null || defPos == null) {
                throw new NullPointerException();
            }
            this.myId = id;
            this.myName = name;
            this.myDefaultPosition = defPos;
            this.myGoalPosition = defPos;
            this.myEnabledFlag = true;
            this.myMin = min;
            this.myMax = max;
        }

        public Object getId() {
            return this.myId;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public NormalizedDouble getDefaultPosition() {
            return this.myDefaultPosition;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.myEnabledFlag = enabled;
        }

        @Override
        public Boolean getEnabled() {
            return this.myEnabledFlag;
        }

        @Override
        public NormalizedDouble getGoalPosition() {
            return this.myGoalPosition;
        }

        @Override
        public void setGoalPosition(NormalizedDouble pos) {
            NormalizedDouble oldPos = this.myGoalPosition;
            this.myGoalPosition = pos;
            this.firePropertyChange("goalPosition", oldPos, pos);
        }

        public ServoConfig getConfig() {
            return null;
        }

        @Override
        public ServoController getController() {
            return null;
        }

        @Override
        public int getMinPosition() {
            return this.myMin;
        }

        @Override
        public int getMaxPosition() {
            return this.myMax;
        }

        @Override
        public NormalizableRange<Double> getPositionRange() {
            return new DoubleRange((double)this.getMinPosition(), (double)this.getMaxPosition());
        }
    }
}

