/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.servos.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.osgi.lifecycle.ConfiguredServiceLifecycle;
import org.jflux.api.common.rk.osgi.lifecycle.ConfiguredServiceParams;
import org.jflux.impl.services.rk.lifecycle.ManagedService;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.ServoRobot;
import org.mechio.api.motion.servos.config.ServoControllerConfig;
import org.mechio.api.motion.servos.config.ServoRobotConfig;

public class ServoRobotLifecycle<P>
extends ConfiguredServiceLifecycle<Robot, ServoRobotConfig, P> {
    private static final Logger theLogger = Logger.getLogger(ServoRobotLifecycle.class.getName());
    private ManagedServiceFactory myServiceFactory;
    private List<ManagedService> myServoControllerServices;

    public ServoRobotLifecycle(ConfiguredServiceParams<Robot, ServoRobotConfig, P> params, ManagedServiceFactory mangedServiceFactory) {
        super(params);
        if (mangedServiceFactory == null) {
            throw new NullPointerException();
        }
        this.myServiceFactory = mangedServiceFactory;
        this.myServoControllerServices = new ArrayList<ManagedService>();
    }

    protected Robot create(Map dependencies) {
        Robot r = (Robot)super.create(dependencies);
        if (r == null) {
            return null;
        }
        r.connect();
        if (r instanceof ServoRobot) {
            ServoRobot sr = (ServoRobot)r;
            for (ServoController sc : sr.getControllerList()) {
                ServoControllerConfig config = sc == null ? null : (ServoControllerConfig)sc.getConfig();
                VersionProperty prop = config == null ? null : config.getControllerTypeVersion();
                Properties props = new Properties();
                if (prop != null) {
                    props.put("servoControllerVersion", prop.toString());
                } else {
                    props.put("servoControllerVersion", "UNKNOWN");
                }
                Robot.Id robotId = r.getRobotId();
                if (r != null) {
                    props.put("robotId", robotId.getRobtIdString());
                } else {
                    props.put("robotId", "UNKNOWN");
                }
                SimpleLifecycle lifecycle = new SimpleLifecycle((Object)sc, ServoController.class);
                ManagedService service = this.myServiceFactory.createService((ServiceLifecycleProvider)lifecycle, props);
                this.myServoControllerServices.add(service);
                service.start();
            }
        }
        return r;
    }

    protected void cleanupService(Robot service) {
        try {
            service.disconnect();
            for (ManagedService s : this.myServoControllerServices) {
                try {
                    s.dispose();
                }
                catch (Throwable t) {
                    theLogger.log(Level.WARNING, "Error disposing controller service.", t);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanupService((Object)service);
    }
}

