/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.property.PropertyChangeSource;
import org.jflux.impl.services.rk.utils.GlobalIdentifier;
import org.jflux.impl.services.rk.utils.HashCodeUtil;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.protocol.JointPositionMap;

public interface Robot<J extends Joint>
extends PropertyChangeSource {
    public static final String PROP_ID = "robotId";
    public static final String PROP_CONNECTED = "isConnected";
    public static final String PROP_ENABLED = "isEnabled";

    public Id getRobotId();

    public boolean connect();

    public void disconnect();

    public boolean isConnected();

    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public J getJoint(JointId var1);

    public Set<JointId> getJointIds();

    public List<J> getJointList();

    public String getJointName(JointId var1);

    public RobotPositionMap getDefaultPositions();

    public RobotPositionMap getCurrentPositions();

    public RobotPositionMap getGoalPositions();

    public void move(RobotPositionMap var1, long var2);

    public static class JointId
    implements GlobalIdentifier {
        private Id myRobotId;
        private Joint.Id myJointId;
        private int myHashCode;

        public JointId(Id robotId, Joint.Id jointId) {
            if (robotId == null || jointId == null) {
                throw new NullPointerException();
            }
            this.myRobotId = robotId;
            this.myJointId = jointId;
        }

        public final Joint.Id getJointId() {
            return this.myJointId;
        }

        public final Id getRobotId() {
            return this.myRobotId;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JointId id = (JointId)obj;
            return this.myRobotId.equals(id.myRobotId) && this.myJointId.equals(id.myJointId);
        }

        public int hashCode() {
            if (this.myHashCode == 0) {
                this.myHashCode = HashCodeUtil.hash((int)23, (Object[])new Object[]{this.myRobotId, this.myJointId});
            }
            return this.myHashCode;
        }

        public String toString() {
            return this.myRobotId.toString() + "::" + this.myJointId.toString();
        }
    }

    public static class Id
    implements GlobalIdentifier {
        private String myRobotIdString;
        private int myHashCode;

        public Id(String robotId) {
            if (robotId == null) {
                throw new NullPointerException();
            }
            if (robotId.isEmpty()) {
                throw new NullPointerException("Robot.Id cannot be empty.");
            }
            this.myRobotIdString = robotId;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Id id = (Id)obj;
            return this.myRobotIdString.equals(id.myRobotIdString);
        }

        public int hashCode() {
            if (this.myHashCode == 0) {
                this.myHashCode = HashCodeUtil.hash((int)23, (Object)this.myRobotIdString);
            }
            return this.myHashCode;
        }

        public String getRobtIdString() {
            return this.myRobotIdString;
        }

        public String toString() {
            return this.myRobotIdString;
        }
    }

    public static class RobotPositionHashMap
    extends HashMap<JointId, NormalizedDouble>
    implements RobotPositionMap {
        public RobotPositionHashMap() {
        }

        public RobotPositionHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        public RobotPositionHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public RobotPositionHashMap(Map<? extends JointId, ? extends NormalizedDouble> m) {
            super(m);
        }
    }

    public static interface RobotPositionMap
    extends JointPositionMap<JointId, NormalizedDouble> {
    }
}

