/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.lifecycle;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.jflux.spec.discovery.SerialNumberSpec;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.messaging.RemoteRobotHost;
import org.mechio.api.motion.messaging.RobotResponseFactory;
import org.mechio.api.motion.protocol.MotionFrameEvent;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;
import org.mechio.api.motion.protocol.RobotRequest;
import org.mechio.api.motion.protocol.RobotResponse;

public class RemoteRobotHostLifecycle
extends AbstractLifecycleProvider<RemoteRobotHost, RemoteRobotHost> {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotHostLifecycle.class.getName());
    private static final String theRobot = "robot";
    private static final String theRequestReceiver = "requestReceiver";
    private static final String theResponseSender = "responseSender";
    private static final String theFrameReceiver = "frameReceiver";
    private static final String theMoveHandler = "moveHandler";
    private static final String theResponseFactory = "responseFactory";
    private static final String theDefSender = "definitionSender";
    private String mySourceId;
    private String myDestId;
    private String mySerial;
    private int mySendDataIntervalMillisec = 100;

    public RemoteRobotHostLifecycle(String sourceId, String destId, Robot.Id robotId, String reqReceiverId, String respSenderId, String frameReceiverId, String moveHandlerId, String defSenderId, String serial, int sendDataIntervalMillisec) {
        super(new DescriptorListBuilder().dependency(theRobot, Robot.class).with("robotId", robotId.getRobtIdString()).dependency(theRequestReceiver, MessageAsyncReceiver.class).with("messageReceiverId", reqReceiverId).with("messageType", RobotRequest.class.getName()).dependency(theResponseSender, MessageSender.class).with("messageSenderId", respSenderId).with("messageType", RobotResponse.class.getName()).dependency(theFrameReceiver, MessageAsyncReceiver.class).with("messageReceiverId", frameReceiverId).with("messageType", MotionFrameEvent.class.getName()).dependency(theMoveHandler, Listener.class).with("listenerId", moveHandlerId).with("listenerType", MotionFrameEvent.class.getName()).dependency(theResponseFactory, RobotResponseFactory.class).dependency(theDefSender, MessageSender.class).with("messageSenderId", defSenderId).with("messageType", RobotDefinitionResponse.class.getName()).getDescriptors());
        if (sourceId == null || destId == null) {
            throw new NullPointerException();
        }
        this.mySourceId = sourceId;
        this.myDestId = destId;
        this.mySerial = serial;
        this.mySendDataIntervalMillisec = sendDataIntervalMillisec;
    }

    protected RemoteRobotHost create(Map<String, Object> services) {
        Robot robot = (Robot)services.get(theRobot);
        MessageAsyncReceiver reqReceiver = (MessageAsyncReceiver)services.get(theRequestReceiver);
        MessageSender respSender = (MessageSender)services.get(theResponseSender);
        MessageAsyncReceiver frameReceiver = (MessageAsyncReceiver)services.get(theFrameReceiver);
        Listener moveHandler = (Listener)services.get(theMoveHandler);
        RobotResponseFactory respFact = (RobotResponseFactory)services.get(theResponseFactory);
        MessageSender defSender = (MessageSender)services.get(theDefSender);
        SerialNumberSpec spec = new SerialNumberSpec();
        spec.setSerialNumber(this.mySerial);
        RemoteRobotHost host = new RemoteRobotHost(robot, this.mySourceId, this.myDestId, (MessageSender<RobotResponse>)respSender, (MessageAsyncReceiver<RobotRequest>)reqReceiver, respFact, (MessageAsyncReceiver<MotionFrameEvent>)frameReceiver, (Listener<MotionFrameEvent>)moveHandler, (MessageSender<RobotDefinitionResponse>)defSender, spec, this.mySendDataIntervalMillisec);
        try {
            reqReceiver.start();
            respSender.start();
            defSender.start();
            frameReceiver.start();
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error starting RemoteRobotHost messaging components.", ex);
        }
        return host;
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            if (this.isSatisfied()) {
                this.myService = this.create((Map)dependencies);
            }
            return;
        }
        if (theRobot.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setRobot((Robot)service);
        } else if (theResponseSender.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setResponseSender((MessageSender<RobotResponse>)((MessageSender)service));
        } else if (theRequestReceiver.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setRequestReceiver((MessageAsyncReceiver<RobotRequest>)((MessageAsyncReceiver)service));
        } else if (theFrameReceiver.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setMotionFrameReceiver((MessageAsyncReceiver<MotionFrameEvent>)((MessageAsyncReceiver)service));
        } else if (theMoveHandler.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setMoveHandler((Listener<MotionFrameEvent>)((Listener)service));
        } else if (theResponseFactory.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setResponseFactory((RobotResponseFactory)service);
        } else if (theDefSender.equals(serviceId)) {
            ((RemoteRobotHost)this.myService).setDefSender((MessageSender<RobotDefinitionResponse>)((MessageSender)service));
        }
    }

    public Class<RemoteRobotHost> getServiceClass() {
        return RemoteRobotHost.class;
    }
}

